/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.general.i18n;

import com.sap.ide.metamodel.core.service.LoggingService;
import com.sap.ide.metamodel.general.exception.I18NException;
import com.sap.ide.metamodel.general.i18n.LanguageInfo;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.core.types.LangType;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;

public class I18NService {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.general.i18n.I18NService");
    private static final Category sCategoryTexts = Category.getCategory((String)"/MetamodelCore/TranslatableTexts");
    private static I18NService sInstance = null;
    private static HashMap sLanguageInfo = null;
    private boolean mCodepageValidationEnabled = true;

    public static I18NService getInstance() {
        if (sInstance == null) {
            sInstance = new I18NService();
        }
        return sInstance;
    }

    public LanguageInfo[] getValidLanguages() throws I18NException {
        String method = "getValidLanguages()";
        if (sLanguageInfo == null) {
            sLanguageInfo = new HashMap();
            S2XDocument lDocument = null;
            try {
                lDocument = new S2XDocument(false);
            }
            catch (Exception ex) {
                LoggingService.getInstance().logException(ex, sLocation, sCategoryTexts, "getValidLanguages()", "constructor of S2XDocument threw exception: ");
                throw new I18NException("Could not create S2XDocument!", ex);
            }
            if (lDocument != null) {
                ArrayList lLangTypes = lDocument.getS2XTypes().getLangTypes();
                int i = 0;
                while (i < lLangTypes.size()) {
                    LangType lLangType = (LangType)lLangTypes.get(i);
                    sLanguageInfo.put(lLangType.getXLIFFValue(), new LanguageInfo(lLangType.getXLIFFValue(), lLangType.getDescription()));
                    ++i;
                }
            }
        }
        return sLanguageInfo.values().toArray(new LanguageInfo[0]);
    }

    public boolean isLanguageValid(String language) {
        if (language == null) {
            return false;
        }
        if (sLanguageInfo == null) {
            try {
                this.getValidLanguages();
            }
            catch (I18NException ex) {
                return false;
            }
        }
        return sLanguageInfo.containsKey(language);
    }

    public void enableCodepageValidation() {
        this.mCodepageValidationEnabled = true;
    }

    public void disableCodepageValidation() {
        this.mCodepageValidationEnabled = false;
    }

    public boolean isCodepageValidationEnabled() {
        return this.mCodepageValidationEnabled;
    }

    public boolean isValidationAvailable() {
        return true;
    }
}

