/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.general.exception;

import com.sap.ide.metamodel.general.exception.MetamodelException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class I18NException
extends MetamodelException {
    private Exception mException = null;

    public I18NException() {
    }

    public I18NException(String exceptionText) {
        super(exceptionText);
    }

    public I18NException(Exception exception) {
        if (exception != null) {
            super.setMessage(exception.getMessage());
            this.mException = exception;
        }
    }

    public I18NException(String message, Exception exception) {
        super(message);
        this.mException = exception;
    }

    public Throwable getCause() {
        return this.mException;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
            if (this.mException != null) {
                ps.print("nested: ");
                this.mException.printStackTrace(ps);
            }
        }
    }

    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            if (this.mException != null) {
                pw.print("nested: ");
                this.mException.printStackTrace(pw);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("I18NValidationException: ");
        String message = this.getMessage();
        if (message != null) {
            sb.append(message);
        }
        return sb.toString();
    }
}

