/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.general.event;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.refactoring.RefactoredMDOImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoredObjectImpl;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.refactoring.RefactoredObject;

public class ObjectRefactoredEvent
extends MetamodelEvent {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private RefactoredObjectImpl mRefactoredObject;

    public ObjectRefactoredEvent(DevelopmentObjectProxy modifiedObject, RefactoredObjectImpl refactoredObject) {
        super(modifiedObject);
        this.mEventId = 64;
        this.mRefactoredObject = refactoredObject;
    }

    public RefactoredObject getRefactoredObject() {
        return this.mRefactoredObject;
    }

    public String toString() {
        String lResult = "ObjectRefactoredEvent: " + this.mModifiedObject._getKey();
        if (this.mRefactoredObject.getOriginalName() != null) {
            lResult = lResult + LINE_SEPARATOR + "  original name:    " + this.mRefactoredObject.getOriginalName();
        }
        if (this.mRefactoredObject.getOriginalParent() != null) {
            lResult = lResult + LINE_SEPARATOR + "  original parent:  " + ((DevelopmentObjectProxy)this.mRefactoredObject.getOriginalParent())._getKey();
        }
        if (this.mRefactoredObject instanceof RefactoredMDOImpl) {
            if (((RefactoredMDOImpl)this.mRefactoredObject).getOriginalPackage() != null) {
                lResult = lResult + LINE_SEPARATOR + "  original package: " + ((RefactoredMDOImpl)this.mRefactoredObject).getOriginalPackage();
            }
            if (((RefactoredMDOImpl)this.mRefactoredObject).getOriginalAbsolutePath() != null) {
                lResult = lResult + LINE_SEPARATOR + "  original path:    " + ((RefactoredMDOImpl)this.mRefactoredObject).getOriginalAbsolutePath();
            }
        }
        return lResult;
    }
}

