/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.service;

import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class ObjectPathResolver {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.service.ObjectPathResolver");
    private static final Category sCategoryIntegrity = Category.getCategory((String)"/MetamodelCore/Integrity");
    private static final char SLASH_ESCAPE = '\u2215';
    private static ObjectPathResolver sInstance = null;
    static /* synthetic */ Class class$java$lang$String;

    private ObjectPathResolver() {
    }

    public static ObjectPathResolver getInstance() {
        if (sInstance == null) {
            sInstance = new ObjectPathResolver();
        }
        return sInstance;
    }

    public String getPathFromObject(DevelopmentObjectProxy object) {
        if (object instanceof CoreMainDevelopmentObject) {
            return "";
        }
        String lPath = "";
        DevelopmentObjectProxy lTmp = object;
        DevelopmentObjectProxy lParent = lTmp._getParent();
        do {
            String lRole;
            lRole = (lRole = lParent._getAggregatedViaRole(lTmp)).endsWith("{1}") ? lRole.substring(0, lRole.length() - 3) : lRole + ":" + lTmp.getName().replace('/', '\u2215');
            lPath = lPath.equals("") ? lRole : lRole + "/" + lPath;
            lTmp = lParent;
            lParent = lTmp._getParent();
        } while (!(lTmp instanceof CoreMainDevelopmentObject));
        return lPath;
    }

    public DevelopmentObjectProxy getObjectFromPathNoWarning(DevelopmentObjectProxy object, String path) {
        return this.getObjectFromPathInternal(object, path);
    }

    public DevelopmentObjectProxy getObjectFromPath(DevelopmentObjectProxy object, String path) {
        String method = "getObjectFromPath()";
        DevelopmentObjectProxy lResult = this.getObjectFromPathInternal(object, path);
        if (lResult == null) {
            sCategoryIntegrity.warningT(sLocation, "getObjectFromPath()", "could not resolve " + path + " (MDO: " + object.getKey() + ")");
        }
        return lResult;
    }

    private DevelopmentObjectProxy getObjectFromPathInternal(DevelopmentObjectProxy object, String path) {
        if (path == null) {
            return object;
        }
        StringTokenizer lTokenizer = new StringTokenizer(path, "/");
        String lMethodName = "";
        String lKey = "";
        DevelopmentObjectProxy lObject = object;
        while (lTokenizer.hasMoreTokens() && lObject != null) {
            String lToken = lTokenizer.nextToken();
            int lPos = lToken.indexOf(58);
            if (lPos != -1) {
                lMethodName = "get" + lToken.substring(0, lPos);
                lKey = lToken.substring(lPos + 1, lToken.length()).replace('\u2215', '/');
            } else {
                lMethodName = "get" + lToken;
                lKey = null;
            }
            lObject = this.invokeMethod(lObject, lMethodName, lKey);
        }
        return lObject;
    }

    private DevelopmentObjectProxy invokeMethod(DevelopmentObjectProxy object, String methodName, String key) {
        String method = "invokeMethod()";
        DevelopmentObjectProxy lResult = null;
        try {
            Class<?>[] lInterfaces = object.getClass().getInterfaces();
            Class<?> lClass = null;
            int i = 0;
            while (i < lInterfaces.length) {
                if (lInterfaces[i].getName().indexOf("com.sap.ide.metamodel.core.") == -1 && lInterfaces[i].getName().indexOf("com.sap.ide.metamodel.general.") == -1) {
                    lClass = lInterfaces[i];
                    break;
                }
                ++i;
            }
            if (key != null) {
                Method lMethod = lClass.getMethod(methodName, class$java$lang$String == null ? (class$java$lang$String = ObjectPathResolver.class$("java.lang.String")) : class$java$lang$String);
                lResult = (DevelopmentObjectProxy)lMethod.invoke((Object)object, key);
            } else {
                Method lMethod = lClass.getMethod(methodName, new Class[0]);
                lResult = (DevelopmentObjectProxy)lMethod.invoke((Object)object, new Object[0]);
            }
        }
        catch (Exception ex) {
            sCategoryIntegrity.warningT(sLocation, "invokeMethod()", "error invoking " + object.getName() + "." + methodName + "(): " + ex.getMessage());
        }
        return lResult;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

