/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.service;

import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.service.LoggingService;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class NotificationService {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.service.NotificationService");
    private static final Category sCategoryEventing = Category.getCategory((String)"/MetamodelCore/Eventing");
    private HashMap mObservers = new HashMap();
    private HashMap mMDOObservers = new HashMap();
    private ArrayList mGlobalObservers = new ArrayList();
    private HashMap mClassObservers = new HashMap();
    private HashMap mObserverInfo = new HashMap();
    private ArrayList mModifiedObjects = new ArrayList();
    private HashMap mEvents = new HashMap();
    private ArrayList mAllEvents = new ArrayList();
    private boolean mAutoNotify = true;
    private int mPendingEvents = 0;

    public synchronized void setAutoNotify(boolean autoNotify) {
        String method = "setAutoNotify()";
        if (autoNotify == this.mAutoNotify) {
            return;
        }
        sCategoryEventing.infoT(sLocation, "setAutoNotify()", (autoNotify ? "enabling" : "disabling") + " AutoNotify");
        if (autoNotify && this.mPendingEvents > 0) {
            this.notifyObservers();
        }
        this.mAutoNotify = autoNotify;
    }

    public synchronized boolean getAutoNotify() {
        return this.mAutoNotify;
    }

    public synchronized void registerGlobalObserver(DevelopmentObjectObserver observer, int eventMask) {
        String method = "registerGlobalObserver()";
        if (this.mGlobalObservers.contains(observer)) {
            return;
        }
        sCategoryEventing.infoT(sLocation, "registerGlobalObserver()", "registering global observer " + observer + ", event mask: " + eventMask);
        this.mGlobalObservers.add(observer);
        ObserverInfo lInfo = (ObserverInfo)this.mObserverInfo.get(observer);
        if (lInfo != null && lInfo.mEventMask != eventMask) {
            sCategoryEventing.warningT(sLocation, "registerGlobalObserver()", "global observer " + observer + " overrides previously registered observer with different event mask");
        }
        this.mObserverInfo.put(observer, new ObserverInfo(eventMask));
    }

    public synchronized void unregisterGlobalObserver(DevelopmentObjectObserver observer) {
        String method = "unregisterGlobalObserver()";
        if (!this.mGlobalObservers.contains(observer)) {
            return;
        }
        sCategoryEventing.infoT(sLocation, "unregisterGlobalObserver()", "unregistering global observer " + observer);
        ((AbstractCollection)this.mGlobalObservers).remove(observer);
        this.mObserverInfo.remove(observer);
    }

    public synchronized void unregisterAllGlobalObservers() {
        String method = "unregisterAllGlobalObservers()";
        if (!this.mGlobalObservers.isEmpty()) {
            sCategoryEventing.infoT(sLocation, "unregisterAllGlobalObservers()", "unregistering all global observers: " + this.mGlobalObservers);
        }
        int i = 0;
        while (i < this.mGlobalObservers.size()) {
            this.mObserverInfo.remove(this.mGlobalObservers.get(i));
            ++i;
        }
        this.mGlobalObservers.clear();
    }

    public synchronized void registerClassObserver(Class clazz, DevelopmentObjectObserver observer, int eventMask) {
        String method = "registerClassObserver()";
        String lClassName = clazz.getName();
        ArrayList<DevelopmentObjectObserver> lObservers = (ArrayList<DevelopmentObjectObserver>)this.mClassObservers.get(lClassName = lClassName.substring(lClassName.lastIndexOf(46) + 1));
        if (lObservers == null || !lObservers.contains(observer)) {
            sCategoryEventing.infoT(sLocation, "registerClassObserver()", "registering class observer for " + clazz + ": " + observer + ", event mask: " + eventMask);
        }
        if (lObservers == null) {
            lObservers = new ArrayList<DevelopmentObjectObserver>();
            lObservers.add(observer);
            this.mClassObservers.put(lClassName, lObservers);
        } else if (!lObservers.contains(observer)) {
            lObservers.add(observer);
        }
        ObserverInfo lInfo = (ObserverInfo)this.mObserverInfo.get(observer);
        if (lInfo != null && lInfo.mEventMask != eventMask) {
            sCategoryEventing.warningT(sLocation, "registerClassObserver()", "class observer " + observer + " overrides previously registered observer with different event mask");
        }
        this.mObserverInfo.put(observer, new ObserverInfo(eventMask));
    }

    public synchronized void unregisterClassObserver(Class clazz, DevelopmentObjectObserver observer) {
        String method = "unregisterClassObserver()";
        String lClassName = clazz.getName();
        ArrayList lObservers = (ArrayList)this.mClassObservers.get(lClassName = lClassName.substring(lClassName.lastIndexOf(46) + 1));
        if (lObservers != null) {
            if (!lObservers.contains(observer)) {
                return;
            }
            sCategoryEventing.infoT(sLocation, "unregisterClassObserver()", "unregistering class observer for " + clazz + ": " + observer);
            ((AbstractCollection)lObservers).remove(observer);
            this.mObserverInfo.remove(observer);
        }
    }

    public synchronized void unregisterAllClassObservers(Class clazz) {
        String method = "unregisterAllClassObservers()";
        String lClassName = clazz.getName();
        ArrayList lObservers = (ArrayList)this.mClassObservers.get(lClassName = lClassName.substring(lClassName.lastIndexOf(46) + 1));
        if (lObservers != null) {
            sCategoryEventing.infoT(sLocation, "unregisterAllClassObservers()", "unregistering all class observers for " + clazz + ": " + lObservers);
            Iterator it = ((AbstractList)lObservers).iterator();
            while (it.hasNext()) {
                this.mObserverInfo.remove((DevelopmentObjectObserver)it.next());
            }
        }
        this.mClassObservers.remove(lClassName);
    }

    public synchronized void registerMDOObserver(CoreMainDevelopmentObject object, DevelopmentObjectObserver observer, int eventMask) {
        String method = "registerMDOObserver()";
        ArrayList<DevelopmentObjectObserver> lObservers = (ArrayList<DevelopmentObjectObserver>)this.mMDOObservers.get(object);
        if (lObservers == null || !lObservers.contains(observer)) {
            sCategoryEventing.infoT(sLocation, "registerMDOObserver()", "registering MDO observer for " + ((DevelopmentObjectProxy)((Object)object))._getKey() + ": " + observer + ", event mask: " + eventMask);
        }
        if (lObservers == null) {
            lObservers = new ArrayList<DevelopmentObjectObserver>();
            lObservers.add(observer);
            this.mMDOObservers.put(object, lObservers);
        } else if (!lObservers.contains(observer)) {
            lObservers.add(observer);
        }
        ObserverInfo lInfo = (ObserverInfo)this.mObserverInfo.get(observer);
        if (lInfo != null && lInfo.mEventMask != eventMask) {
            sCategoryEventing.warningT(sLocation, "registerMDOObserver()", "MDO observer " + observer + " overrides previously registered observer with different event mask");
        }
        this.mObserverInfo.put(observer, new ObserverInfo(eventMask));
    }

    public synchronized void unregisterMDOObserver(CoreMainDevelopmentObject object, DevelopmentObjectObserver observer) {
        String method = "unregisterMDOObserver()";
        ArrayList lObservers = (ArrayList)this.mMDOObservers.get(object);
        if (lObservers != null) {
            if (!lObservers.contains(observer)) {
                return;
            }
            sCategoryEventing.infoT(sLocation, "unregisterMDOObserver()", "unregistering MDO observer for " + ((DevelopmentObjectProxy)((Object)object))._getKey() + ": " + observer);
            ((AbstractCollection)lObservers).remove(observer);
            this.mObserverInfo.remove(observer);
        }
    }

    public synchronized void unregisterAllMDOObservers(CoreMainDevelopmentObject object) {
        String method = "unregisterAllMDOObservers()";
        ArrayList lObservers = (ArrayList)this.mMDOObservers.get(object);
        if (lObservers != null) {
            sCategoryEventing.infoT(sLocation, "unregisterAllMDOObservers()", "unregistering all MDO observers for " + ((DevelopmentObjectProxy)((Object)object))._getKey() + ": " + lObservers);
            Iterator it = ((AbstractList)lObservers).iterator();
            while (it.hasNext()) {
                this.mObserverInfo.remove((DevelopmentObjectObserver)it.next());
            }
        }
        this.mMDOObservers.remove(object);
    }

    public synchronized void registerObserver(DevelopmentObjectProxy object, DevelopmentObjectObserver observer, int eventMask) {
        String method = "registerObserver()";
        ArrayList<DevelopmentObjectObserver> lObservers = (ArrayList<DevelopmentObjectObserver>)this.mObservers.get(object);
        if (lObservers == null || !lObservers.contains(observer)) {
            sCategoryEventing.infoT(sLocation, "registerObserver()", "registering observer " + observer + ", event mask: " + eventMask);
        }
        if (lObservers == null) {
            lObservers = new ArrayList<DevelopmentObjectObserver>();
            lObservers.add(observer);
            this.mObservers.put(object, lObservers);
        } else if (!lObservers.contains(observer)) {
            lObservers.add(observer);
        }
        ObserverInfo lInfo = (ObserverInfo)this.mObserverInfo.get(observer);
        if (lInfo != null && lInfo.mEventMask != eventMask) {
            sCategoryEventing.warningT(sLocation, "registerObserver()", "observer " + observer + " overrides previously registered observer with different event mask");
        }
        this.mObserverInfo.put(observer, new ObserverInfo(eventMask));
    }

    public synchronized void unregisterObserver(DevelopmentObjectProxy object, DevelopmentObjectObserver observer) {
        String method = "unregisterObserver()";
        ArrayList lObservers = (ArrayList)this.mObservers.get(object);
        if (lObservers != null) {
            if (!lObservers.contains(observer)) {
                return;
            }
            sCategoryEventing.infoT(sLocation, "unregisterObserver()", "unregistering observer for " + object._getKey() + ": " + observer);
            ((AbstractCollection)lObservers).remove(observer);
            this.mObserverInfo.remove(observer);
        }
    }

    public synchronized void unregisterAllObservers(DevelopmentObjectProxy object) {
        String method = "unregisterAllObservers()";
        ArrayList lObservers = (ArrayList)this.mObservers.get(object);
        if (lObservers != null) {
            sCategoryEventing.infoT(sLocation, "unregisterAllObservers()", "unregistering all observers for " + object._getKey() + ": " + lObservers);
            Iterator it = ((AbstractList)lObservers).iterator();
            while (it.hasNext()) {
                this.mObserverInfo.remove((DevelopmentObjectObserver)it.next());
            }
        }
        this.mObservers.remove(object);
    }

    private void storeEvent(MetamodelEvent event) {
        ArrayList<MetamodelEvent> lEvents;
        DevelopmentObjectProxy modifiedObject = (DevelopmentObjectProxy)event.getModifiedObject();
        if (!this.mModifiedObjects.contains(modifiedObject)) {
            this.mModifiedObjects.add(modifiedObject);
        }
        if ((lEvents = (ArrayList<MetamodelEvent>)this.mEvents.get(modifiedObject)) == null) {
            lEvents = new ArrayList<MetamodelEvent>();
            lEvents.add(event);
            this.mEvents.put(modifiedObject, lEvents);
        } else {
            lEvents.add(event);
        }
        this.mAllEvents.add(event);
        ++this.mPendingEvents;
    }

    public synchronized void notifyObservers(MetamodelEvent event) {
        String method = "notifyObservers(MetamodelEvent)";
        if (!this.mAutoNotify) {
            this.storeEvent(event);
        } else {
            DevelopmentObjectProxy lModifiedObject = (DevelopmentObjectProxy)event.getModifiedObject();
            ArrayList lObservers = new ArrayList();
            lObservers.addAll(this.mGlobalObservers);
            ArrayList lClassObservers = (ArrayList)this.mClassObservers.get(lModifiedObject._getClassName());
            if (lClassObservers != null) {
                lObservers.addAll(lClassObservers);
            }
            lObservers.addAll(this.findObserversToUpdate(lModifiedObject));
            int i = 0;
            while (i < lObservers.size()) {
                DevelopmentObjectObserver lObserver = (DevelopmentObjectObserver)lObservers.get(i);
                ObserverInfo lObserverInfo = (ObserverInfo)this.mObserverInfo.get(lObserver);
                if (lObserverInfo != null && this.filterEvent(event, lObserverInfo.mEventMask)) {
                    try {
                        lObserver.update(event);
                    }
                    catch (Throwable t) {
                        LoggingService.getInstance().logException(t, sLocation, sCategoryEventing, "notifyObservers(MetamodelEvent)", "DevelopmentObjectObserver " + lObserver + " threw exception: ");
                    }
                }
                ++i;
            }
        }
    }

    public synchronized void notifyObservers() {
        String method = "notifyObservers()";
        if (this.mAutoNotify || this.mPendingEvents == 0) {
            return;
        }
        if (!this.mGlobalObservers.isEmpty()) {
            int i = 0;
            while (i < this.mGlobalObservers.size()) {
                MetamodelEvent[] lArray;
                DevelopmentObjectObserver lObserver = (DevelopmentObjectObserver)this.mGlobalObservers.get(i);
                ObserverInfo lObserverInfo = (ObserverInfo)this.mObserverInfo.get(lObserver);
                if (lObserverInfo != null && (lArray = this.filterEvents(this.mAllEvents, lObserverInfo.mEventMask)).length > 0) {
                    try {
                        lObserver.update(lArray);
                    }
                    catch (Throwable t) {
                        LoggingService.getInstance().logException(t, sLocation, sCategoryEventing, "notifyObservers()", "DevelopmentObjectObserver " + lObserver + " threw exception: ");
                    }
                }
                ++i;
            }
        }
        if (!this.mClassObservers.isEmpty()) {
            Iterator lIterator = this.mClassObservers.keySet().iterator();
            while (lIterator.hasNext()) {
                String lClassName = (String)lIterator.next();
                ArrayList lObservers = (ArrayList)this.mClassObservers.get(lClassName);
                int i = 0;
                while (i < lObservers.size()) {
                    DevelopmentObjectObserver lObserver = (DevelopmentObjectObserver)lObservers.get(i);
                    ObserverInfo lObserverInfo = (ObserverInfo)this.mObserverInfo.get(lObserver);
                    if (lObserverInfo != null) {
                        ArrayList<MetamodelEvent> lResult = new ArrayList<MetamodelEvent>();
                        int j = 0;
                        while (j < this.mAllEvents.size()) {
                            MetamodelEvent lEvent = (MetamodelEvent)this.mAllEvents.get(j);
                            if (((DevelopmentObjectProxy)lEvent.getModifiedObject())._getClassName().equals(lClassName) && this.filterEvent(lEvent, lObserverInfo.mEventMask)) {
                                lResult.add(lEvent);
                            }
                            ++j;
                        }
                        if (!lResult.isEmpty()) {
                            MetamodelEvent[] lArray = new MetamodelEvent[]{};
                            try {
                                lObserver.update(lResult.toArray(lArray));
                            }
                            catch (Throwable t) {
                                LoggingService.getInstance().logException(t, sLocation, sCategoryEventing, "notifyObservers()", "DevelopmentObjectObserver " + lObserver + " threw exception: ");
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < this.mModifiedObjects.size()) {
            DevelopmentObjectProxy lObject = (DevelopmentObjectProxy)this.mModifiedObjects.get(i);
            ArrayList lEvents = (ArrayList)this.mEvents.get(lObject);
            ArrayList lObservers = this.findObserversToUpdate(lObject);
            int j = 0;
            while (j < lObservers.size()) {
                DevelopmentObjectObserver lObserver = (DevelopmentObjectObserver)lObservers.get(j);
                ObserverInfo lObserverInfo = (ObserverInfo)this.mObserverInfo.get(lObserver);
                if (lObserverInfo != null) {
                    try {
                        lObserver.update(this.filterEvents(lEvents, lObserverInfo.mEventMask));
                    }
                    catch (Throwable t) {
                        LoggingService.getInstance().logException(t, sLocation, sCategoryEventing, "notifyObservers()", "DevelopmentObjectObserver " + lObserver + " threw exception: ");
                    }
                }
                ++j;
            }
            ++i;
        }
        this.mModifiedObjects.clear();
        this.mEvents.clear();
        this.mAllEvents.clear();
        this.mPendingEvents = 0;
    }

    private ArrayList findObserversToUpdate(DevelopmentObjectProxy object) {
        ArrayList lObservers;
        ArrayList lResult = new ArrayList();
        ArrayList lMDOObservers = (ArrayList)this.mMDOObservers.get(object._getMDO());
        if (lMDOObservers != null) {
            lResult.addAll(lMDOObservers);
        }
        if ((lObservers = (ArrayList)this.mObservers.get(object)) != null) {
            lResult.addAll(lObservers);
        }
        return lResult;
    }

    private boolean filterEvent(MetamodelEvent event, int eventMask) {
        return (eventMask & event.getEventId()) != 0;
    }

    private MetamodelEvent[] filterEvents(ArrayList events, int eventMask) {
        if (eventMask == 65535) {
            return events.toArray(new MetamodelEvent[0]);
        }
        ArrayList<MetamodelEvent> lFilteredEvents = new ArrayList<MetamodelEvent>();
        int i = 0;
        while (i < events.size()) {
            MetamodelEvent lEvent = (MetamodelEvent)events.get(i);
            if ((eventMask & lEvent.getEventId()) != 0) {
                lFilteredEvents.add(lEvent);
            }
            ++i;
        }
        return lFilteredEvents.toArray(new MetamodelEvent[0]);
    }

    private class ObserverInfo {
        protected int mEventMask;

        ObserverInfo(int eventMask) {
            this.mEventMask = eventMask;
        }
    }
}

