/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.service;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.service.FileSystemService;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.IllegalNamingException;
import com.sap.ide.metamodel.general.service.NamingService;
import java.util.StringTokenizer;

public class NamingServiceImpl
implements NamingService {
    private static NamingServiceImpl sInstance = null;
    private static String[] sForbiddenMDONames = new String[]{"aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};

    private NamingServiceImpl() {
    }

    public static NamingServiceImpl getInstance() {
        if (sInstance == null) {
            sInstance = new NamingServiceImpl();
        }
        return sInstance;
    }

    public boolean isValidDevelopmentObjectName(String name) {
        try {
            this.checkDevelopmentObjectName(name);
        }
        catch (IllegalNamingException ex) {
            return false;
        }
        return true;
    }

    public boolean isValidMainDevelopmentObjectName(String mdoName) {
        try {
            this.checkMainDevelopmentObjectName(mdoName);
        }
        catch (IllegalNamingException ex) {
            return false;
        }
        return true;
    }

    public boolean isValidMainDevelopmentObjectPackage(String mdoPackage) {
        try {
            this.checkMainDevelopmentObjectPackage(mdoPackage);
        }
        catch (IllegalNamingException ex) {
            return false;
        }
        return true;
    }

    public boolean isValidMainDevelopmentObjectPath(Metamodel metamodel, String mdoName, String mdoPackage, MDOEnum mdoType, SourcePathIdentifier sourcePathIdentifier) throws IllegalNamingException {
        try {
            this.checkMainDevelopmentObjectPath(metamodel, mdoName, mdoPackage, mdoType, sourcePathIdentifier);
        }
        catch (IllegalNamingException ex) {
            return false;
        }
        return true;
    }

    public void checkDevelopmentObjectName(String name) throws IllegalNamingException {
        if (name == null) {
            throw new IllegalNamingException("The name is null.");
        }
        if (name.length() == 0) {
            throw new IllegalNamingException("The name is empty.");
        }
    }

    public void checkMainDevelopmentObjectName(String mdoName) throws IllegalNamingException {
        if (mdoName == null) {
            throw new IllegalNamingException("The name is null.");
        }
        if (mdoName.length() == 0) {
            throw new IllegalNamingException("The name is empty.");
        }
        int i = 0;
        while (i < sForbiddenMDONames.length) {
            if (mdoName.equalsIgnoreCase(sForbiddenMDONames[i])) {
                throw new IllegalNamingException("The file name \"" + mdoName + "\" is reserved under Windows.");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < mdoName.length()) {
            char c = mdoName.charAt(i2);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c))) {
                throw new IllegalNamingException("The name contains the illegal character '" + c + "'.");
            }
            ++i2;
        }
    }

    public void checkMainDevelopmentObjectPackage(String mdoPackage) throws IllegalNamingException {
        int lDot = 46;
        if (mdoPackage == null) {
            throw new IllegalNamingException("The package is null.");
        }
        int length = mdoPackage.length();
        if (length == 0) {
            return;
        }
        if (mdoPackage.charAt(0) == '.') {
            throw new IllegalNamingException("The package starts with a dot.");
        }
        if (mdoPackage.charAt(length - 1) == '.') {
            throw new IllegalNamingException("The package ends with a dot.");
        }
        int lPos = 0;
        while (lPos != -1 && lPos < length - 1) {
            if ((lPos = mdoPackage.indexOf(46, lPos + 1)) == -1 || lPos >= length - 1 || mdoPackage.charAt(lPos + 1) != '.') continue;
            throw new IllegalNamingException("The package contains consecutive dots.");
        }
        StringTokenizer lTokenizer = new StringTokenizer(mdoPackage, new String(new char[]{'.'}));
        while (lTokenizer.hasMoreTokens()) {
            String lToken = lTokenizer.nextToken();
            int i = 0;
            while (i < sForbiddenMDONames.length) {
                if (lToken.equalsIgnoreCase(sForbiddenMDONames[i])) {
                    throw new IllegalNamingException("The package segment \"" + lToken + "\" cannot be used as a folder name under Windows.");
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < lToken.length()) {
                char c = lToken.charAt(i2);
                if (i2 == 0 && Character.isDigit(c)) {
                    throw new IllegalNamingException("A package segment starts with a digit.");
                }
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isDigit(c) || c == '_')) {
                    throw new IllegalNamingException("The package contains the illegal character '" + c + "'.");
                }
                ++i2;
            }
        }
    }

    public void checkMainDevelopmentObjectPath(Metamodel metamodel, String mdoName, String mdoPackage, MDOEnum mdoType, SourcePathIdentifier sourcePathIdentifier) throws IllegalNamingException {
        this.checkMainDevelopmentObjectName(mdoName);
        this.checkMainDevelopmentObjectPackage(mdoPackage);
        String lAbsolutePath = FileSystemService.getInstance().computeAbsolutePathNoLogging(metamodel.getMDOLocator(), mdoName, mdoPackage, mdoType, sourcePathIdentifier);
        if (lAbsolutePath == null) {
            String lMessage = "Could not get a valid path for " + mdoType + " \"" + mdoPackage + "." + mdoName + "\" (path too long?)";
            throw new IllegalNamingException(lMessage);
        }
    }
}

