/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.service;

import com.sap.ide.metamodel.MetamodelObserver;
import com.sap.ide.metamodel.core.service.LoggingService;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class MetamodelNotificationService {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.service.MetamodelNotificationService");
    private static final Category sCategoryCaching = Category.getCategory((String)"/MetamodelCore/Caching");
    private static final Category sCategoryEventing = Category.getCategory((String)"/MetamodelCore/Eventing");
    private boolean mMetamodelEventingEnabled = false;
    private ArrayList mObservers = new ArrayList();
    private boolean mAutoNotify = true;
    private boolean mDirty = false;
    private Boolean mPendingDirtyEvent = null;
    private boolean mPreviousDirtyEvent = false;

    public void enableMetamodelEventing() {
        String method = "enableMetamodelEventing()";
        this.mMetamodelEventingEnabled = true;
        sCategoryEventing.infoT(sLocation, "enableMetamodelEventing()", "enabling metamodel eventing for: " + this);
    }

    public void disableMetamodelEventing() {
        String method = "enableMetamodelEventing()";
        this.mMetamodelEventingEnabled = false;
        sCategoryEventing.infoT(sLocation, "enableMetamodelEventing()", "disabling metamodel eventing for: " + this);
    }

    public synchronized void setAutoNotify(boolean autoNotify) {
        String method = "setAutoNotify()";
        if (autoNotify == this.mAutoNotify) {
            return;
        }
        this.mAutoNotify = autoNotify;
        sCategoryEventing.infoT(sLocation, "setAutoNotify()", (autoNotify ? "enabling" : "disabling") + " AutoNotify");
        if (autoNotify && this.mPendingDirtyEvent != null) {
            this.setDirty(this.mPendingDirtyEvent);
        }
    }

    public synchronized boolean getAutoNotify() {
        return this.mAutoNotify;
    }

    public boolean isMetamodelEventingEnabled() {
        return this.mMetamodelEventingEnabled;
    }

    public void attachMetamodelObserver(MetamodelObserver observer) {
        String method = "attachMetamodelObserver()";
        if (!this.mObservers.contains(observer)) {
            sCategoryEventing.infoT(sLocation, "attachMetamodelObserver()", "registering metamodel observer: " + observer);
            this.mObservers.add(observer);
        }
    }

    public void detachMetamodelObserver(MetamodelObserver observer) {
        String method = "detachMetamodelObserver()";
        if (this.mObservers.contains(observer)) {
            sCategoryEventing.infoT(sLocation, "detachMetamodelObserver()", "unregistering metamodel observer: " + observer);
            ((AbstractCollection)this.mObservers).remove(observer);
        }
    }

    public void detachAllMetamodelObservers() {
        String method = "detachAllMetamodelObservers()";
        if (!this.mObservers.isEmpty()) {
            sCategoryEventing.infoT(sLocation, "detachAllMetamodelObservers()", "unregistering all metamodel observers: " + this.mObservers);
            this.mObservers.clear();
        }
    }

    public void setDirty(boolean dirty) {
        String method = "setDirty()";
        this.mDirty = dirty;
        if (!this.mMetamodelEventingEnabled) {
            return;
        }
        if (!this.mAutoNotify) {
            this.mPendingDirtyEvent = new Boolean(dirty);
        } else if (dirty != this.mPreviousDirtyEvent) {
            this.notifyObservers(dirty);
        }
    }

    public boolean isDirty() {
        return this.mDirty;
    }

    private void notifyObservers(boolean isDirty) {
        String method = "notifyObservers()";
        this.mPreviousDirtyEvent = isDirty;
        if (this.mObservers.isEmpty()) {
            return;
        }
        sCategoryEventing.infoT(sLocation, "notifyObservers()", "Metamodel dirty flag is \"" + this.mPreviousDirtyEvent + "\", notifying observers: " + this.mObservers);
        int i = 0;
        while (i < this.mObservers.size()) {
            MetamodelObserver lObserver = (MetamodelObserver)this.mObservers.get(i);
            try {
                lObserver.dirtyFlagChanged(isDirty);
            }
            catch (Throwable t) {
                LoggingService.getInstance().logException(t, sLocation, sCategoryEventing, "notifyObservers()", "MetamodelObserver " + lObserver + " threw exception: ");
            }
            ++i;
        }
        this.mPendingDirtyEvent = null;
    }

    public synchronized void notifyObservers() {
        String method = "notifyObservers()";
        if (this.mAutoNotify || this.mPendingDirtyEvent == null) {
            return;
        }
        if (this.mPendingDirtyEvent != this.mPreviousDirtyEvent) {
            this.notifyObservers(this.mPendingDirtyEvent);
        }
    }
}

