/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.service;

import com.sap.ide.metamodel.core.service.TransactionResultImpl;
import com.sap.ide.metamodel.general.CommitResult;
import com.sap.ide.metamodel.general.MDOAccessProblem;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.i18n.LanguageObject;
import com.sap.ide.metamodel.general.refactoring.RefactoredLanguageObject;
import com.sap.ide.metamodel.general.refactoring.RefactoredMDO;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

class CommitResultImpl
extends TransactionResultImpl
implements CommitResult {
    private ArrayList mDeleted;
    private ArrayList mCreated;
    private ArrayList mModified;
    private ArrayList mCreatedLanguages;
    private ArrayList mDeletedLanguages;
    private ArrayList mModifiedLanguages;
    private ArrayList mRefactored;
    private ArrayList mRefactoredLanguages;

    CommitResultImpl(MDOAccessProblem[] obstacles, ArrayList cancelled, ArrayList deleted, ArrayList created, ArrayList modified, ArrayList refactored, ArrayList createdLanguages, ArrayList deletedLanguages, ArrayList modifiedLanguages, ArrayList refactoredLanguages) {
        super(obstacles, cancelled);
        this.mDeleted = deleted;
        this.mCreated = created;
        this.mModified = modified;
        this.mRefactored = refactored;
        this.mCreatedLanguages = createdLanguages;
        this.mDeletedLanguages = deletedLanguages;
        this.mModifiedLanguages = modifiedLanguages;
        this.mRefactoredLanguages = refactoredLanguages;
    }

    public MainDevelopmentObject[] getDeletedMDOs() {
        return this.mDeleted.toArray(new MainDevelopmentObject[0]);
    }

    public MainDevelopmentObject[] getCreatedMDOs() {
        return this.mCreated.toArray(new MainDevelopmentObject[0]);
    }

    public MainDevelopmentObject[] getModifiedMDOs() {
        return this.mModified.toArray(new MainDevelopmentObject[0]);
    }

    public RefactoredMDO[] getRefactoredMDOs() {
        return this.mRefactored.toArray(new RefactoredMDO[0]);
    }

    public LanguageObject[] getCreatedLanguageObjects() {
        return this.mCreatedLanguages.toArray(new LanguageObject[0]);
    }

    public LanguageObject[] getDeletedLanguageObjects() {
        return this.mDeletedLanguages.toArray(new LanguageObject[0]);
    }

    public LanguageObject[] getModifiedLanguageObjects() {
        return this.mModifiedLanguages.toArray(new LanguageObject[0]);
    }

    public RefactoredLanguageObject[] getRefactoredLanguageObjects() {
        return this.mRefactoredLanguages.toArray(new RefactoredLanguageObject[0]);
    }

    public String[] getAllDeletedFiles() {
        HashSet<String> lAllDeletedFiles = new HashSet<String>();
        Iterator it = ((AbstractList)this.mDeleted).iterator();
        while (it.hasNext()) {
            lAllDeletedFiles.add(((MainDevelopmentObject)it.next()).getAbsolutePath());
        }
        Iterator it2 = ((AbstractList)this.mRefactored).iterator();
        while (it2.hasNext()) {
            RefactoredMDO lRefactoredMDO = (RefactoredMDO)it2.next();
            MainDevelopmentObject lMDO = (MainDevelopmentObject)lRefactoredMDO.getObject();
            if (lRefactoredMDO.getOriginalAbsolutePath().equals(lMDO.getAbsolutePath())) continue;
            lAllDeletedFiles.add(lRefactoredMDO.getOriginalAbsolutePath());
            if (this.mDeleted.contains(lMDO)) continue;
            lAllDeletedFiles.remove(lMDO.getAbsolutePath());
        }
        Iterator it3 = ((AbstractList)this.mCreated).iterator();
        while (it3.hasNext()) {
            lAllDeletedFiles.remove(((MainDevelopmentObject)it3.next()).getAbsolutePath());
        }
        Iterator it4 = ((AbstractList)this.mModified).iterator();
        while (it4.hasNext()) {
            lAllDeletedFiles.remove(((MainDevelopmentObject)it4.next()).getAbsolutePath());
        }
        Iterator it5 = ((AbstractList)this.mDeletedLanguages).iterator();
        while (it5.hasNext()) {
            lAllDeletedFiles.add(((LanguageObject)it5.next()).getAbsolutePath());
        }
        Iterator it6 = ((AbstractList)this.mRefactoredLanguages).iterator();
        while (it6.hasNext()) {
            lAllDeletedFiles.add(((RefactoredLanguageObject)it6.next()).getOriginalAbsolutePath());
        }
        Iterator it7 = ((AbstractList)this.mCreatedLanguages).iterator();
        while (it7.hasNext()) {
            lAllDeletedFiles.remove(((LanguageObject)it7.next()).getAbsolutePath());
        }
        Iterator it8 = ((AbstractList)this.mModifiedLanguages).iterator();
        while (it8.hasNext()) {
            lAllDeletedFiles.remove(((LanguageObject)it8.next()).getAbsolutePath());
        }
        return ((AbstractCollection)lAllDeletedFiles).toArray(new String[0]);
    }

    public String[] getAllCreatedFiles() {
        HashSet<String> lAllCreatedFiles = new HashSet<String>();
        Iterator it = ((AbstractList)this.mCreated).iterator();
        while (it.hasNext()) {
            lAllCreatedFiles.add(((MainDevelopmentObject)it.next()).getAbsolutePath());
        }
        Iterator it2 = ((AbstractList)this.mRefactored).iterator();
        while (it2.hasNext()) {
            RefactoredMDO lRefactoredMDO = (RefactoredMDO)it2.next();
            MainDevelopmentObject lMDO = (MainDevelopmentObject)lRefactoredMDO.getObject();
            if (lRefactoredMDO.getOriginalAbsolutePath().equals(lMDO.getAbsolutePath())) continue;
            lAllCreatedFiles.add(lMDO.getAbsolutePath());
            lAllCreatedFiles.remove(lRefactoredMDO.getOriginalAbsolutePath());
        }
        Iterator it3 = ((AbstractList)this.mDeleted).iterator();
        while (it3.hasNext()) {
            lAllCreatedFiles.remove(((MainDevelopmentObject)it3.next()).getAbsolutePath());
        }
        Iterator it4 = ((AbstractList)this.mCreatedLanguages).iterator();
        while (it4.hasNext()) {
            lAllCreatedFiles.add(((LanguageObject)it4.next()).getAbsolutePath());
        }
        Iterator it5 = ((AbstractList)this.mRefactoredLanguages).iterator();
        while (it5.hasNext()) {
            lAllCreatedFiles.add(((RefactoredLanguageObject)it5.next()).getAbsolutePath());
        }
        Iterator it6 = ((AbstractList)this.mDeletedLanguages).iterator();
        while (it6.hasNext()) {
            lAllCreatedFiles.remove(((LanguageObject)it6.next()).getAbsolutePath());
        }
        return ((AbstractCollection)lAllCreatedFiles).toArray(new String[0]);
    }
}

