/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.service;

import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.service.FileSystemService;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocation;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.RootMDOEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.i18n.I18NService;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ArchiveManager
implements MDOLocator {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.service.ArchiveManager");
    private static final Category sCategoryArchiveAccess = Category.getCategory((String)"/MetamodelCore/ArchiveAccess");
    private static FileSystemService sFileSystemService = FileSystemService.getInstance();
    private HashMap mArchives = new HashMap();
    private ArrayList mArchivesOrdered = new ArrayList();
    private String mExtensions = ".xlf";

    public void registerRoot(Root root) {
        ArrayList lEnums = ((RootImpl)root)._getMDOEnums();
        int i = 0;
        while (i < lEnums.size()) {
            this.mExtensions = this.mExtensions + "." + ((MDOEnum)lEnums.get(i)).getFileExtension();
            ++i;
        }
        Iterator it = ((AbstractList)this.mArchivesOrdered).iterator();
        while (it.hasNext()) {
            Archive lArchive = (Archive)it.next();
            lArchive.scan(this.mExtensions);
        }
    }

    public void addArchive(String path) {
        this.addArchive(path, "");
    }

    public void addArchive(String path, String rootFolder) {
        String method = "addArchive()";
        if (!sFileSystemService.fileExists(path)) {
            sCategoryArchiveAccess.errorT(sLocation, "addArchive()", "invalid path to archive: " + path);
            return;
        }
        String lArchiveKey = this.getArchiveKeyFromPath(path).toLowerCase();
        if (this.mArchives.containsKey(lArchiveKey)) {
            sCategoryArchiveAccess.errorT(sLocation, "addArchive()", "archive already added: " + path);
            return;
        }
        Archive lArchive = new Archive(path, rootFolder);
        this.mArchives.put(lArchiveKey, lArchive);
        this.mArchivesOrdered.add(lArchive);
        sCategoryArchiveAccess.infoT(sLocation, "addArchive()", "adding archive " + path);
        lArchive.scan(this.mExtensions);
    }

    public String[] getArchives() {
        String[] lResult = new String[this.mArchivesOrdered.size()];
        int i = 0;
        Iterator it = ((AbstractList)this.mArchivesOrdered).iterator();
        while (it.hasNext()) {
            Archive lArchive = (Archive)it.next();
            lResult[i] = lArchive.getPath();
            ++i;
        }
        return lResult;
    }

    public void removeArchive(String path) {
        String method = "removeArchive()";
        String lArchiveKey = this.getArchiveKeyFromPath(path).toLowerCase();
        if (!this.mArchives.containsKey(lArchiveKey)) {
            sCategoryArchiveAccess.errorT(sLocation, "removeArchive()", "attempt to remove non-existing archive: " + path);
            return;
        }
        ((AbstractCollection)this.mArchivesOrdered).remove(this.mArchives.get(lArchiveKey));
        this.mArchives.remove(lArchiveKey);
        sCategoryArchiveAccess.infoT(sLocation, "removeArchive()", "removing archive " + path);
    }

    public void removeAllArchives() {
        this.mArchivesOrdered.clear();
        this.mArchives.clear();
    }

    public void rescanArchive(String path) {
        String method = "rescanArchive()";
        String lArchiveKey = this.getArchiveKeyFromPath(path).toLowerCase();
        if (!this.mArchives.containsKey(lArchiveKey)) {
            sCategoryArchiveAccess.errorT(sLocation, "rescanArchive()", "attempt to rescan non-existing archive: " + path);
            return;
        }
        Archive lArchive = (Archive)this.mArchives.get(lArchiveKey);
        sCategoryArchiveAccess.infoT(sLocation, "rescanArchive()", "rescanning archive " + lArchive.getPath());
        lArchive.scan(this.mExtensions);
    }

    public void rescanArchives() {
        String method = "rescanArchives()";
        Iterator it = ((AbstractList)this.mArchivesOrdered).iterator();
        while (it.hasNext()) {
            Archive lArchive = (Archive)it.next();
            sCategoryArchiveAccess.infoT(sLocation, "rescanArchives()", "rescanning archive " + lArchive.getPath());
            lArchive.scan(this.mExtensions);
        }
    }

    public String[] getRootMDOPaths(String mdoPackage, RootMDOEnum rootMDOType) {
        ArrayList lResult = new ArrayList();
        Iterator it = ((AbstractList)this.mArchivesOrdered).iterator();
        while (it.hasNext()) {
            lResult.addAll(((Archive)it.next()).getRootMDOPaths(mdoPackage, rootMDOType));
        }
        return lResult.toArray(new String[0]);
    }

    public MDOLocation[] getRootMDOLocations(RootMDOEnum rootMDOType) {
        ArrayList lResult = new ArrayList();
        Iterator it = ((AbstractList)this.mArchivesOrdered).iterator();
        while (it.hasNext()) {
            lResult.addAll(((Archive)it.next()).getRootMDOLocations(rootMDOType));
        }
        return lResult.toArray(new MDOLocation[0]);
    }

    public String getMDOPath(String mdoPackage, String mdoName, MDOEnum mdoType) {
        String lKey = mdoPackage.replace('.', '/') + "/" + mdoName + "." + mdoType.getFileExtension();
        Iterator it = ((AbstractList)this.mArchivesOrdered).iterator();
        while (it.hasNext()) {
            String lUri = ((Archive)it.next()).getUri(lKey);
            if (lUri == null) continue;
            return lUri;
        }
        return null;
    }

    public String getSourcePath() {
        throw new UnsupportedOperationException();
    }

    public String getSourcePath(SourcePathIdentifier identifier) {
        throw new UnsupportedOperationException();
    }

    public InputStream getJarEntryInputStream(String jarUri) {
        String method = "getJarEntryInputStream()";
        int lPos = jarUri.indexOf(33);
        if (lPos == -1 || jarUri.length() <= lPos) {
            return null;
        }
        String lEntryName = jarUri.substring(lPos + 2);
        Iterator it = ((AbstractList)this.mArchivesOrdered).iterator();
        while (it.hasNext()) {
            Archive lArchive = (Archive)it.next();
            JarEntry lJarEntry = lArchive.getJarEntry(lEntryName);
            if (lJarEntry == null) continue;
            try {
                InputStream lStream = new JarFile(lArchive.getPath()).getInputStream(lJarEntry);
                sCategoryArchiveAccess.infoT(sLocation, "getJarEntryInputStream()", "acquired input stream for " + jarUri);
                return lStream;
            }
            catch (IOException ex) {
                sCategoryArchiveAccess.errorT(sLocation, "getJarEntryInputStream()", "error acquiring input stream for " + jarUri + ": " + ex.getMessage());
            }
        }
        return null;
    }

    public String[] getAvailableLanguages(String jarUri) {
        String method = "getAvailableLanguages()";
        int lPos = jarUri.indexOf(33);
        if (lPos == -1 || jarUri.length() <= lPos) {
            sCategoryArchiveAccess.errorT(sLocation, "getAvailableLanguages()", "invalid jar uri: " + jarUri);
            return new String[0];
        }
        String lArchiveKey = this.getArchiveKeyFromUri(jarUri);
        Archive lArchive = (Archive)this.mArchives.get(lArchiveKey);
        if (lArchive == null) {
            sCategoryArchiveAccess.errorT(sLocation, "getAvailableLanguages()", "archive not registered: " + jarUri);
            return new String[0];
        }
        return lArchive.getAvailableLanguages(jarUri.substring(lPos + 2)).toArray(new String[0]);
    }

    private String getArchiveKeyFromPath(String path) {
        return new File(path).getAbsolutePath().replace('\\', '/').toLowerCase();
    }

    private String getArchiveKeyFromUri(String jarUri) {
        return this.getArchiveKeyFromPath(jarUri.substring(12, jarUri.indexOf(33)));
    }

    private class Archive {
        private final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.service.ArchiveManager.$Archive");
        private final Category sCategoryArchiveAccess = Category.getCategory((String)"/MetamodelCore/ArchiveAccess");
        private String mPath;
        private String mRootFolder = "";
        private HashMap mContent = new HashMap();

        Archive(String path) {
            this(path, "");
        }

        Archive(String path, String rootFolder) {
            this.mPath = path;
            if (!rootFolder.equals("")) {
                this.mRootFolder = rootFolder.trim().replace('\\', '/').toLowerCase();
                if (this.mRootFolder.startsWith("/")) {
                    this.mRootFolder = this.mRootFolder.substring(1);
                }
                if (!this.mRootFolder.endsWith("/")) {
                    this.mRootFolder = this.mRootFolder + "/";
                }
            }
        }

        public String getPath() {
            return this.mPath;
        }

        public void scan(String extensions) {
            String method = "$Archive.scan()";
            JarFile lJar = null;
            try {
                lJar = new JarFile(this.mPath);
            }
            catch (IOException ex) {
                this.sCategoryArchiveAccess.errorT(this.sLocation, "$Archive.scan()", "error opening archive " + this.mPath + ": " + ex.getMessage());
                return;
            }
            this.mContent.clear();
            Enumeration<JarEntry> lEntries = lJar.entries();
            while (lEntries.hasMoreElements()) {
                String lExtension;
                String lName;
                JarEntry lEntry = lEntries.nextElement();
                if (lEntry.isDirectory() || !(lName = lEntry.getName()).startsWith(this.mRootFolder) || lName.lastIndexOf(46) == -1 || extensions.indexOf(lExtension = lName.substring(lName.lastIndexOf(46))) == -1) continue;
                String lKey = lName;
                if (this.mRootFolder.length() > 0) {
                    lKey = lKey.substring(this.mRootFolder.length());
                }
                this.mContent.put(lKey.toLowerCase(), lEntry);
                this.sCategoryArchiveAccess.infoT(this.sLocation, "$Archive.scan()", "added to archive content: " + lKey);
            }
            try {
                lJar.close();
            }
            catch (IOException ex) {
                this.sCategoryArchiveAccess.errorT(this.sLocation, "$Archive.scan()", "error closing archive " + this.mPath + ": " + ex.getMessage());
            }
        }

        public String getUri(String entryName) {
            JarEntry lEntry = (JarEntry)this.mContent.get(entryName.toLowerCase());
            if (lEntry == null) {
                return null;
            }
            return "jar:file:///" + this.mPath + "!/" + lEntry.getName();
        }

        public JarEntry getJarEntry(String entryName) {
            return (JarEntry)this.mContent.get(entryName.toLowerCase());
        }

        public ArrayList getRootMDOPaths(String mdoPackage, RootMDOEnum rootMDOType) {
            ArrayList<String> lResult = new ArrayList<String>();
            String lStartPattern = this.mRootFolder;
            if (mdoPackage.length() > 0) {
                lStartPattern = lStartPattern + (mdoPackage.replace('.', '/') + "/").toLowerCase();
            }
            String lEndPattern = ("." + rootMDOType.getFileExtension()).toLowerCase();
            Iterator it = this.mContent.keySet().iterator();
            while (it.hasNext()) {
                String lEntryName = (String)it.next();
                if (!lEntryName.startsWith(lStartPattern) || !lEntryName.endsWith(lEndPattern) || lEntryName.lastIndexOf(47) != lStartPattern.length() - 1) continue;
                lResult.add(this.getUri(lEntryName));
            }
            return lResult;
        }

        public ArrayList getRootMDOLocations(RootMDOEnum rootMDOType) {
            ArrayList<MDOLocation> lResult = new ArrayList<MDOLocation>();
            String lEndPattern = ("." + rootMDOType.getFileExtension()).toLowerCase();
            Iterator it = this.mContent.keySet().iterator();
            while (it.hasNext()) {
                String lEntryName = (String)it.next();
                if (!lEntryName.startsWith(this.mRootFolder) || !lEntryName.endsWith(lEndPattern)) continue;
                String lPackage = "";
                if (lEntryName.lastIndexOf(47) > 0) {
                    lPackage = lEntryName.substring(this.mRootFolder.length(), lEntryName.lastIndexOf(47)).replace('/', '.');
                }
                lResult.add(new MDOLocation(this.getUri(lEntryName), lPackage));
            }
            return lResult;
        }

        public ArrayList getAvailableLanguages(String entryName) {
            ArrayList<String> lResult = new ArrayList<String>();
            String lEndPattern = ".xlf";
            Iterator it = this.mContent.keySet().iterator();
            while (it.hasNext()) {
                String lEntryName = (String)it.next();
                if (!lEntryName.endsWith(lEndPattern)) continue;
                int lPos1 = lEntryName.indexOf(46);
                int lPos2 = lEntryName.indexOf(95, lPos1 + 1);
                if (lPos2 == -1) {
                    if (!lEntryName.substring(0, lEntryName.lastIndexOf(46)).equals(entryName.toLowerCase())) continue;
                    lResult.add("");
                    continue;
                }
                if (!lEntryName.substring(0, lPos2).equals(entryName.toLowerCase())) continue;
                String lLanguageKey = lEntryName.substring(lPos2 + 1, lEntryName.lastIndexOf(46));
                if (lLanguageKey.length() > 2) {
                    lLanguageKey = lLanguageKey.substring(0, 3) + lLanguageKey.substring(3).toUpperCase();
                }
                if (!I18NService.getInstance().isLanguageValid(lLanguageKey)) continue;
                lResult.add(lLanguageKey);
            }
            return lResult;
        }
    }
}

