/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.refactoring;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.refactoring.MDORefactoringTaskImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoringRequestImpl;
import com.sap.ide.metamodel.core.service.FileSystemService;
import com.sap.ide.metamodel.core.service.NamingServiceImpl;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.refactoring.RefactoringTask;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class RefactoringTaskImpl
implements RefactoringTask {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.refactoring.RefactoringTaskImpl");
    private static final Category sCategoryRefactoring = Category.getCategory((String)"/MetamodelCore/Refactoring");
    protected static NamingServiceImpl sNamingService = NamingServiceImpl.getInstance();
    protected static FileSystemService sFileSystemService = FileSystemService.getInstance();
    private RefactoringRequestImpl mRequest;
    protected DevelopmentObjectProxy mObjectToRefactor;
    protected String mNewName;
    protected DevelopmentObjectProxy mNewParent;

    RefactoringTaskImpl(RefactoringRequestImpl request, DevelopmentObjectProxy objectToRefactor) {
        this.mRequest = request;
        this.mObjectToRefactor = objectToRefactor;
        this.mNewName = objectToRefactor.getName();
        this.mNewParent = null;
    }

    public void setNewName(String newName) {
        String method = "setNewName()";
        if (newName != null && this.mNewName.equals(newName)) {
            return;
        }
        boolean lValid = false;
        lValid = this instanceof MDORefactoringTaskImpl ? sNamingService.isValidMainDevelopmentObjectName(newName) : sNamingService.isValidDevelopmentObjectName(newName);
        if (!lValid) {
            String lMessage = "the new name \"" + newName + "\" is empty or contains illegal characters";
            sCategoryRefactoring.errorT(sLocation, "setNewName()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (this instanceof MDORefactoringTaskImpl) {
            SourcePathIdentifier lSourcePathIdentifier;
            MDOEnum lType;
            String lPackage;
            CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)this.mObjectToRefactor);
            MDOLocator lMDOLocator = ((RootImpl)this.mObjectToRefactor.getRoot())._getMDOLocator();
            String lAbsolutePath = sFileSystemService.computeAbsolutePath(lMDOLocator, lPackage = ((MDORefactoringTaskImpl)this).getNewPackage(), newName, lType = (MDOEnum)this.mObjectToRefactor.getDevelopmentObjectEnum(), lSourcePathIdentifier = ((MDORefactoringTaskImpl)this).getNewSourcePathIdentifier());
            if (lAbsolutePath == null) {
                String lMessage = "could not get a valid path for " + lType + " \"" + lPackage + "." + newName + "\" (path too long?)";
                sCategoryRefactoring.errorT(sLocation, "setNewName()", lMessage);
                throw new IllegalArgumentException(this.exceptionMessage(lMessage));
            }
        }
        this.mNewName = newName;
    }

    public String getNewName() {
        return this.mNewName;
    }

    public void setNewParent(DevelopmentObject newParent) {
        String method = "setNewParent()";
        if (newParent == null) {
            this.mNewParent = null;
            return;
        }
        if (newParent == this.mObjectToRefactor.getParent()) {
            return;
        }
        DevelopmentObjectProxy lNewParent = (DevelopmentObjectProxy)newParent;
        if (lNewParent.originatesInArchive()) {
            String lMessage = "the new parent " + lNewParent._getKey() + " originates in an archive";
            sCategoryRefactoring.errorT(sLocation, "setNewParent()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (!lNewParent._isValid()) {
            String lMessage = "the new parent " + lNewParent._getKey() + " is not valid";
            sCategoryRefactoring.errorT(sLocation, "setNewParent()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (lNewParent.getMetamodel() != this.mObjectToRefactor.getMetamodel()) {
            String lMessage = "reparenting between different metamodels is not allowed";
            sCategoryRefactoring.errorT(sLocation, "setNewParent()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (!this.mObjectToRefactor.isMDO() && lNewParent.getMDO() != this.mObjectToRefactor.getMDO()) {
            String lMessage = "the new parent " + lNewParent._getKey() + " belongs to a different MDO (object to reparent: " + this.mObjectToRefactor._getKey() + ")";
            sCategoryRefactoring.errorT(sLocation, "setNewParent()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (!this.isParentCompatible(lNewParent)) {
            String lMessage = "the new parent " + lNewParent._getKey() + " is not compatible";
            sCategoryRefactoring.errorT(sLocation, "setNewParent()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        DevelopmentObjectProxy lProxy = lNewParent;
        while (lProxy != this.mObjectToRefactor && lProxy != null) {
            lProxy = lProxy._getParent();
        }
        if (lProxy != null) {
            String lMessage = "the new parent object " + lNewParent._getKey() + " is a sub-object of " + this.mObjectToRefactor._getKey();
            sCategoryRefactoring.errorT(sLocation, "setNewParent()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        this.mRequest.addMDOToRefactoringScopeNoExpand(lNewParent._getMDO());
        this.mNewParent = lNewParent;
    }

    public DevelopmentObject getNewParent() {
        return this.mNewParent;
    }

    public DevelopmentObject getObjectToRefactor() {
        return this.mObjectToRefactor;
    }

    public boolean isModified() {
        return !this.mNewName.equals(this.mObjectToRefactor.getName()) || this.mNewParent != null;
    }

    public boolean onlyParentHasChanged() {
        return this.mNewName.equals(this.mObjectToRefactor.getName()) && this.mNewParent != null;
    }

    public boolean hasNameChanged() {
        return !this.mNewName.equals(this.mObjectToRefactor.getName());
    }

    public boolean hasParentChanged() {
        return this.mNewParent != null;
    }

    public boolean isConflicting() {
        if (!this.isModified()) {
            return false;
        }
        DevelopmentObjectKey lOriginalKey = this.mObjectToRefactor._getKey();
        String lPath = lOriginalKey.getPath();
        String lLastSegment = lPath.substring(lPath.lastIndexOf(47) + 1);
        ForeignReference lKeyToCheck = null;
        Metamodel lMetamodel = null;
        if (this.mNewParent != null) {
            DevelopmentObjectKey lNewMDOKey = this.mNewParent._getKey();
            if (!(this.mNewParent instanceof CoreMainDevelopmentObject)) {
                lPath = lNewMDOKey.getPath() + "/" + lLastSegment;
                if (lLastSegment.indexOf(58) != -1) {
                    lPath = lPath.substring(0, lPath.lastIndexOf(this.mObjectToRefactor.getName())) + this.mNewName;
                }
            }
            lKeyToCheck = new ForeignReference(lNewMDOKey.getModelName(), lNewMDOKey.getMDOPackage(), lNewMDOKey.getMDOName(), lNewMDOKey.getMDOType(), lPath);
            lMetamodel = this.mNewParent.getMetamodel();
        } else {
            if (lLastSegment.indexOf(58) == -1) {
                return false;
            }
            lPath = lPath.substring(0, lPath.lastIndexOf(this.mObjectToRefactor.getName())) + this.mNewName;
            lKeyToCheck = new ForeignReference(lOriginalKey.getModelName(), lOriginalKey.getMDOPackage(), lOriginalKey.getMDOName(), lOriginalKey.getMDOType(), lPath);
            lMetamodel = this.mObjectToRefactor.getMetamodel();
        }
        if (((ForeignReference)lOriginalKey).toLowerString().equals(lKeyToCheck.toLowerString())) {
            return false;
        }
        return lMetamodel.objectExists(lKeyToCheck);
    }

    Reference getRefactoredReference() {
        DevelopmentObjectKey lOldKey = this.mObjectToRefactor._getKey();
        String lOldPath = lOldKey.getPath();
        String lLastSegment = lOldPath.substring(lOldPath.lastIndexOf(47) + 1);
        if (lLastSegment.indexOf(58) != -1) {
            lLastSegment = lLastSegment.substring(0, lLastSegment.indexOf(58) + 1) + this.mNewName;
        }
        if (this.mNewParent != null) {
            DevelopmentObjectKey lNewParentKey = this.mNewParent._getKey();
            String lPath = null;
            lPath = lNewParentKey.getPath().equals("") ? lLastSegment : lNewParentKey.getPath() + "/" + lLastSegment;
            return new Reference(lNewParentKey.getMDOPackage(), lNewParentKey.getMDOName(), lNewParentKey.getMDOType(), lPath);
        }
        String lPath = lOldPath.substring(0, lOldPath.lastIndexOf(47) + 1) + lLastSegment;
        return new Reference(lOldKey.getMDOPackage(), lOldKey.getMDOName(), lOldKey.getMDOType(), lPath);
    }

    private boolean isParentCompatible(DevelopmentObjectProxy newParent) {
        MetamodelClipboard lClipboard = Metamodel.createInternalClipboard();
        lClipboard.copy(this.mObjectToRefactor);
        return lClipboard.isPasteAllowed(newParent);
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }
}

