/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.marshalling;

import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MetamodelAnnotationImpl;
import com.sap.ide.metamodel.core.marshalling.Marshaller;
import com.sap.ide.metamodel.general.exception.SaveException;
import java.io.OutputStreamWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public abstract class XMLMarshaller
implements Marshaller {
    private static final String[] CH_TO_ENT = new String[256];
    private static final Hashtable ENT_TO_CH = new Hashtable();
    protected static final String ENCODING = "UTF-8";
    private String mIndent = "";

    protected String pushIndent() {
        this.mIndent = this.mIndent + "\t";
        return this.mIndent;
    }

    protected String popIndent() {
        if (this.mIndent.length() > 0) {
            this.mIndent = this.mIndent.substring(1);
        }
        return this.mIndent;
    }

    protected String indent() {
        return this.mIndent;
    }

    protected void resetIndent() {
        this.mIndent = "";
    }

    protected String escapeXML(String s) {
        StringBuffer b = new StringBuffer();
        int ls = s.length();
        int i = 0;
        while (i < ls) {
            char ch = s.charAt(i);
            if (ch < '\u0100') {
                String ent = CH_TO_ENT[ch];
                if (ent == null) {
                    b.append(ch);
                } else {
                    b.append('&').append(ent).append(';');
                }
            } else {
                b.append(ch);
            }
            ++i;
        }
        return b.toString();
    }

    protected void serializeMetamodelAnnotations(DevelopmentObjectState state, StringBuffer buf) {
        ArrayList lAnnotations = state.getMetamodelAnnotations();
        if (lAnnotations.size() > 0) {
            buf.append(this.indent() + "<Core.Annotations>\n");
            this.pushIndent();
            Iterator it = ((AbstractList)lAnnotations).iterator();
            while (it.hasNext()) {
                MetamodelAnnotationImpl lAnnotation = (MetamodelAnnotationImpl)it.next();
                this.serializeMetamodelAnnotation(lAnnotation, buf);
            }
            buf.append(this.popIndent() + "</Core.Annotations>\n");
        }
    }

    private void serializeMetamodelAnnotation(MetamodelAnnotationImpl annotation, StringBuffer buf) {
        String lValue = annotation.getValue();
        lValue = lValue.indexOf("]]>") == -1 ? "<![CDATA[" + lValue + "]]>" : this.escapeXML(lValue);
        buf.append(this.indent() + "<Core.Annotation key=\"").append(this.escapeXML(annotation.getKey()));
        buf.append("\" timestamp=\"").append(annotation.getTimeStampAsLong());
        buf.append("\">").append(lValue).append("</Core.Annotation>\n");
    }

    public abstract void marshal(DevelopmentObjectState var1, OutputStreamWriter var2) throws SaveException;

    public abstract void marshal(DevelopmentObjectState var1, String var2) throws SaveException;

    static {
        XMLMarshaller.CH_TO_ENT[38] = "amp";
        XMLMarshaller.CH_TO_ENT[39] = "apos";
        XMLMarshaller.CH_TO_ENT[34] = "quot";
        XMLMarshaller.CH_TO_ENT[60] = "lt";
        XMLMarshaller.CH_TO_ENT[62] = "gt";
        char[] temp = new char[1];
        int i = 0;
        while (i < CH_TO_ENT.length) {
            if (CH_TO_ENT[i] != null) {
                temp[0] = (char)i;
                ENT_TO_CH.put(CH_TO_ENT[i], new String(temp));
            }
            ++i;
        }
    }
}

