/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.i18n;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DataState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.i18n.I18NProblemImpl;
import com.sap.ide.metamodel.core.i18n.I18NTextProblemImpl;
import com.sap.ide.metamodel.core.i18n.LanguageState;
import com.sap.ide.metamodel.core.i18n.S2XLanguageMarshaller;
import com.sap.ide.metamodel.core.i18n.S2XLanguageUnmarshaller;
import com.sap.ide.metamodel.core.i18n.TextData;
import com.sap.ide.metamodel.core.i18n.TranslatableTextProxy;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.core.service.FileSystemService;
import com.sap.ide.metamodel.core.service.LoggingService;
import com.sap.ide.metamodel.core.service.ObjectCacheManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelDocument;
import com.sap.ide.metamodel.general.SeverityEnum;
import com.sap.ide.metamodel.general.exception.DataStateCorruptException;
import com.sap.ide.metamodel.general.exception.DataStateDeletedException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.ObjectNotModifiableException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.general.i18n.I18NProblem;
import com.sap.ide.metamodel.general.i18n.I18NService;
import com.sap.ide.metamodel.general.i18n.I18NTextProblem;
import com.sap.ide.metamodel.general.i18n.MasterLanguageAccessMode;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.s2x.validation.SourceValidator;
import com.sap.s2x.validation.Validator;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FilenameFilter;
import java.io.OutputStreamWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class TextPoolProxy
implements TextPool {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.i18n.TextPoolProxy");
    private static final Category sCategoryTexts = Category.getCategory((String)"/MetamodelCore/TranslatableTexts");
    private static final Category sCategoryObjectAccess = Category.getCategory((String)"/MetamodelCore/ObjectAccess");
    private static I18NService sI18NService = I18NService.getInstance();
    private static SourceValidator sSourceValidator = null;
    private CoreMainDevelopmentObject mOwner;
    private String mMasterLanguage;
    private String mOriginalLanguage;
    private HashMap mLanguageStates = new HashMap();
    private HashMap mLanguageDataStates = new HashMap();
    private HashMap mTextObjects = new HashMap();
    private boolean mDirty = false;
    private Validator mValidator = null;
    private static FileSystemService sFileSystemService;
    private static S2XLanguageMarshaller sLanguageMarshaller;
    private static S2XLanguageUnmarshaller sLanguageUnmarshaller;
    public static final String TEXT_FILE_EXTENSION = "xlf";

    private TextPoolProxy() {
    }

    public TextPoolProxy(CoreMainDevelopmentObject owner, String masterLanguage, boolean searchFilesystem) {
        this.mOwner = owner;
        this.mMasterLanguage = masterLanguage;
        this.mOriginalLanguage = "";
        if (searchFilesystem) {
            String[] lAvailableLanguages = this.getAvailableLanguages(owner);
            int i = 0;
            while (i < lAvailableLanguages.length) {
                this.setLanguageDataState(lAvailableLanguages[i], DataState.HOLLOW);
                ++i;
            }
            if (lAvailableLanguages.length > 0 && !this.hasRawLanguageVersion()) {
                this.mOriginalLanguage = masterLanguage;
            }
        }
    }

    public TextPoolProxy(CoreMainDevelopmentObject owner, LanguageState languageState) {
        this.mOwner = owner;
        this.mMasterLanguage = languageState.getMasterLanguage();
        this.mOriginalLanguage = "";
        this.mLanguageStates.put(this.mOriginalLanguage, languageState);
        this.injectState();
        this.setLanguageDataState(this.mOriginalLanguage, DataState.NEW);
    }

    public void addTextsOnClipboardPaste(LanguageState languageState) {
        if (!this.hasRawLanguageVersion()) {
            this.createLanguageState("");
        } else {
            this.prepareLanguageForRead("");
        }
        ((LanguageState)this.mLanguageStates.get(this.mOriginalLanguage)).addTexts(languageState);
        this.injectState();
        this.setLanguageDataState(this.mOriginalLanguage, DataState.MODIFIED);
    }

    public void _dropState() {
        this._dropLanguageStates();
        Iterator it = this.mTextObjects.values().iterator();
        while (it.hasNext()) {
            ((TranslatableTextProxy)it.next())._invalidate();
        }
        this.mDirty = false;
    }

    private void _dropLanguageStates() {
        this.mLanguageStates.clear();
        this.mLanguageDataStates.clear();
        this.mOriginalLanguage = "";
        String[] lAvailableLanguages = this.getAvailableLanguages(this.mOwner);
        int i = 0;
        while (i < lAvailableLanguages.length) {
            this.setLanguageDataState(lAvailableLanguages[i], DataState.HOLLOW);
            ++i;
        }
        if (lAvailableLanguages.length > 0 && !this.hasRawLanguageVersion()) {
            this.mOriginalLanguage = this.mMasterLanguage;
        }
    }

    private String[] getAvailableLanguages(CoreMainDevelopmentObject mdo) {
        String lFullPath = mdo.getAbsolutePath();
        if (lFullPath.startsWith("jar:")) {
            return ((RootImpl)mdo.getRoot())._getArchiveManager().getAvailableLanguages(lFullPath);
        }
        final String lFileName = new File(lFullPath).getName();
        String lPath = new File(mdo.getAbsolutePath()).getParent();
        if (lPath == null || lPath.equals("")) {
            return new String[0];
        }
        File[] lFiles = new File(lPath).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equals(lFileName + "." + TextPoolProxy.TEXT_FILE_EXTENSION) || name.startsWith(lFileName + "_") && name.endsWith(".xlf");
            }
        });
        ArrayList<String> lResult = new ArrayList<String>();
        if (lFiles != null) {
            int i = 0;
            while (i < lFiles.length) {
                int lPos1;
                String lLanguageKey = lFiles[i].getName();
                int lPos2 = lLanguageKey.indexOf(95, (lPos1 = lLanguageKey.indexOf(46)) + 1);
                lLanguageKey = lPos2 == -1 ? "" : lLanguageKey.substring(lPos2 + 1, lLanguageKey.lastIndexOf(46));
                if (this.isLanguageKeyValid(lLanguageKey)) {
                    lResult.add(lLanguageKey);
                }
                ++i;
            }
        }
        return lResult.toArray(new String[0]);
    }

    public String getAbsolutePath(String language) {
        if (!this.isLanguageKeyValid(language)) {
            return null;
        }
        if (language.equals("")) {
            return this.mOwner.getAbsolutePath() + "." + TEXT_FILE_EXTENSION;
        }
        return this.mOwner.getAbsolutePath() + "_" + language + "." + TEXT_FILE_EXTENSION;
    }

    public static String getAbsolutePath(String language, String absolutePathOfMDO) {
        if (language.equals("")) {
            return absolutePathOfMDO + "." + TEXT_FILE_EXTENSION;
        }
        return absolutePathOfMDO + "_" + language + "." + TEXT_FILE_EXTENSION;
    }

    public MainDevelopmentObject getOwner() {
        return (MainDevelopmentObject)((Object)this.mOwner);
    }

    public synchronized TranslatableText[] getTexts() {
        if (this.mLanguageDataStates.containsKey(this.mOriginalLanguage)) {
            this.prepareLanguageForRead(this.mOriginalLanguage);
        }
        return this.mTextObjects.values().toArray(new TranslatableText[0]);
    }

    public synchronized boolean isEmpty() {
        if (!this.mLanguageDataStates.containsKey(this.mOriginalLanguage)) {
            return true;
        }
        this.prepareLanguageForRead(this.mOriginalLanguage);
        return ((LanguageState)this.mLanguageStates.get(this.mOriginalLanguage)).isEmpty();
    }

    public synchronized TranslatableText getText(String key) {
        if (this.mLanguageDataStates.containsKey(this.mOriginalLanguage)) {
            this.prepareLanguageForRead(this.mOriginalLanguage);
        }
        return (TranslatableText)this.mTextObjects.get(key);
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public String getOriginalLanguage() {
        return this.mOriginalLanguage;
    }

    public String getRawLanguage() {
        return "";
    }

    public synchronized String[] getAvailableLanguages() {
        return this.getValidLanguages().toArray(new String[0]);
    }

    public TextData getTextData(String key) {
        String method = "getTextData()";
        Metamodel lMetamodel = this.mOwner.getMetamodel();
        if (this.mMasterLanguage.equals(lMetamodel.getLanguage())) {
            if (lMetamodel.getMasterLanguageAccessMode() == MasterLanguageAccessMode.REVISED) {
                if (this.isLanguageStateValid(this.mMasterLanguage)) {
                    return this.getTextData(key, this.mMasterLanguage);
                }
                sCategoryTexts.warningT(sLocation, "getTextData()", "no revised text found for " + key + ", falling back to raw language");
                return this.getTextData(key, "");
            }
            if (this.hasRawLanguageVersion()) {
                return this.getTextData(key, "");
            }
            return this.getTextData(key, this.mMasterLanguage);
        }
        return this.getTextData(key, lMetamodel.getLanguage());
    }

    public TextData getTextData(String key, String language) {
        if (!this.mLanguageDataStates.containsKey(language)) {
            return null;
        }
        this.prepareLanguageForRead(language);
        LanguageState lLanguageState = (LanguageState)this.mLanguageStates.get(language);
        return lLanguageState.getLanguageText(key);
    }

    private void removeTextData(String key, String language) {
        String method = "removeTextData()";
        if (!this.mLanguageDataStates.containsKey(language)) {
            return;
        }
        this.prepareLanguageForModify(language);
        LanguageState lLanguageState = (LanguageState)this.mLanguageStates.get(language);
        if (!lLanguageState.containsKey(key)) {
            return;
        }
        if (language.equals(this.mOriginalLanguage)) {
            try {
                ((TranslatableTextProxy)this.mTextObjects.get(key)).delete();
            }
            catch (DeleteException ex) {
                String lMessage = "deletion of text " + key + " for MDO " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey() + " failed: " + ex.getMessage();
                sCategoryTexts.errorT(sLocation, "removeTextData()", lMessage);
            }
        } else {
            lLanguageState.removeLanguageText(key);
            if (lLanguageState.isEmpty()) {
                this.setLanguageDataState(language, DataState.DELETED);
            } else {
                this.setLanguageDataState(language, DataState.MODIFIED);
            }
        }
    }

    public void setTextData(String key, String text, String type, String maxLength) {
        Metamodel lMetamodel = this.mOwner.getMetamodel();
        if (this.mMasterLanguage.equals(lMetamodel.getLanguage()) && lMetamodel.getMasterLanguageAccessMode() == MasterLanguageAccessMode.RAW) {
            this.setTextData(key, "", text, type, maxLength);
        } else {
            this.setTextData(key, lMetamodel.getLanguage(), text, type, maxLength);
        }
    }

    public void setTextData(String key, String language, String text, String type, String maxLength) {
        String method = "setTextData()";
        if (!this.isLanguageKeyValid(language)) {
            sCategoryTexts.errorT(sLocation, "setTextData()", "invalid language key: \"" + language + "\"");
            return;
        }
        if (text == null || text.trim().equals("")) {
            this.removeTextData(key, language);
            return;
        }
        if (!this.hasRawLanguageVersion()) {
            this.createLanguageState("");
        } else if (!this.isLanguageStateValid("")) {
            if (this.mLanguageDataStates.get("") == DataState.DELETED) {
                this.setLanguageDataState("", DataState.MODIFIED);
            } else {
                this.setLanguageDataState("", DataState.NEW);
            }
        } else {
            this.prepareLanguageForRead("");
        }
        if (!this.mLanguageDataStates.containsKey(language)) {
            this.createLanguageState(language);
        } else {
            this.prepareLanguageForModify(language);
        }
        String lS2XId = null;
        if (!language.equals(this.mOriginalLanguage)) {
            LanguageState lOriginalLanguageState = (LanguageState)this.mLanguageStates.get(this.mOriginalLanguage);
            if (lOriginalLanguageState.getLanguageText(key) == null) {
                this.prepareLanguageForModify(this.mOriginalLanguage);
                sCategoryTexts.warningT(sLocation, "setTextData()", "creating text " + key + " in language \"" + language + "\" instead of raw language");
                TextData lNewData = new TextData("<created in [" + language + "]>", type, maxLength);
                lOriginalLanguageState.addLanguageText(key, lNewData);
                this.setLanguageDataState(this.mOriginalLanguage, DataState.MODIFIED);
            } else {
                lS2XId = lOriginalLanguageState.getLanguageText(key).getId();
            }
        }
        if (!this.mTextObjects.containsKey(key)) {
            this.mTextObjects.put(key, new TranslatableTextProxy(key, this));
        }
        LanguageState lLanguageState = (LanguageState)this.mLanguageStates.get(language);
        lLanguageState.addLanguageText(key, new TextData(lS2XId, text, type, maxLength));
        this.setLanguageDataState(language, DataState.MODIFIED);
    }

    public void saveLanguage(String language) throws SaveException {
        sLanguageMarshaller.marshal(this.mOwner, this.getAbsolutePath(language), (LanguageState)this.mLanguageStates.get(language));
        this.setLanguageDataState(language, DataState.SYNCED);
    }

    public synchronized void clear() {
        Iterator it = this.mLanguageDataStates.keySet().iterator();
        while (it.hasNext()) {
            String lLanguage = (String)it.next();
            if (this.getLanguageDataState(lLanguage) == DataState.DELETED || this.getLanguageDataState(lLanguage) == DataState.CANCELLED) continue;
            this.prepareLanguageForDelete(lLanguage);
            ((LanguageState)this.mLanguageStates.get(lLanguage)).clear();
            this.setLanguageDataState(lLanguage, DataState.DELETED);
        }
        Iterator it2 = this.mTextObjects.values().iterator();
        while (it2.hasNext()) {
            ((TranslatableTextProxy)it2.next()).setDeleted(true);
            it2.remove();
        }
    }

    public void removeLanguageDataState(String language) {
        this.mLanguageDataStates.remove(language);
        this.mLanguageStates.remove(language);
    }

    private boolean isLanguageStateValid(String language) {
        DataState lDataState = this.getLanguageDataState(language);
        return lDataState != null && lDataState != DataState.CANCELLED && lDataState != DataState.DELETED && lDataState != DataState.CORRUPT && lDataState != DataState.INVALID;
    }

    private boolean isLanguageKeyValid(String language) {
        return language.equals("") || sI18NService.isLanguageValid(language);
    }

    public synchronized void deleteLanguage(String language) throws DeleteException {
        String method = "deleteLanguage()";
        if (!this.isLanguageKeyValid(language)) {
            sCategoryTexts.errorT(sLocation, "deleteLanguage()", "invalid language key: \"" + language + "\"");
            throw new DeleteException("Invalid language key: \"" + language + "\"");
        }
        if (!this.mLanguageDataStates.containsKey(language) || !this.isLanguageStateValid(language)) {
            return;
        }
        if (language.equals(this.mOriginalLanguage) && this.getValidLanguages().size() > 1) {
            String lMessage = null;
            lMessage = this.mOriginalLanguage.equals("") ? "deletion of raw language is not allowed because texts in other languages exist (MDO: " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey() + ")" : "deletion of original language \"" + this.mOriginalLanguage + "\" is not allowed because texts in other languages exist (MDO: " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey() + ")";
            sCategoryTexts.errorT(sLocation, "deleteLanguage()", lMessage);
            throw new DeleteException(lMessage);
        }
        this.prepareLanguageForDelete(language);
        ((LanguageState)this.mLanguageStates.get(language)).clear();
        if (language.equals(this.mOriginalLanguage)) {
            Iterator it = this.mTextObjects.values().iterator();
            while (it.hasNext()) {
                ((TranslatableTextProxy)it.next()).setDeleted(true);
                it.remove();
            }
        }
        this.setLanguageDataState(language, DataState.DELETED);
    }

    public synchronized void reload() throws LoadException {
        String method = "reload()";
        this._dropLanguageStates();
        if (this.mLanguageDataStates.isEmpty()) {
            return;
        }
        if (!this.mLanguageDataStates.containsKey(this.mOriginalLanguage)) {
            String lMessage = "error reloading text pool (missing master language file for MDO " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey() + ")";
            sCategoryTexts.infoT(sLocation, "reload()", lMessage);
            throw new LoadException(lMessage);
        }
        this.loadLanguageState(this.mOriginalLanguage);
        if (this.getLanguageDataState(this.mOriginalLanguage) == DataState.CORRUPT) {
            throw new LoadException("Corrupt language file [" + this.mOriginalLanguage + "]");
        }
        this.mDirty = false;
    }

    public Vector getNewLanguages() {
        return this.getLanguagesByDataState(DataState.NEW);
    }

    public Vector getModifiedLanguages() {
        return this.getLanguagesByDataState(DataState.MODIFIED);
    }

    public Vector getDeletedLanguages() {
        return this.getLanguagesByDataState(DataState.DELETED);
    }

    public Vector getCancelledLanguages() {
        return this.getLanguagesByDataState(DataState.CANCELLED);
    }

    private Vector getLanguagesByDataState(DataState dataState) {
        Vector<String> lResult = new Vector<String>();
        Iterator it = this.mLanguageDataStates.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            DataState lDataState = (DataState)this.mLanguageDataStates.get(lKey);
            if (lDataState != dataState) continue;
            lResult.add(lKey);
        }
        return lResult;
    }

    void deleteText(String textKey) throws DeleteException {
        try {
            Iterator it = this.mLanguageDataStates.keySet().iterator();
            while (it.hasNext()) {
                String lLanguage = (String)it.next();
                this.prepareLanguageForModify(lLanguage);
                LanguageState lLanguageState = (LanguageState)this.mLanguageStates.get(lLanguage);
                if (!lLanguageState.containsKey(textKey)) continue;
                lLanguageState.removeLanguageText(textKey);
                if (lLanguageState.isEmpty()) {
                    this.setLanguageDataState(lLanguage, DataState.DELETED);
                    continue;
                }
                this.setLanguageDataState(lLanguage, DataState.MODIFIED);
            }
            this.mTextObjects.remove(textKey);
        }
        catch (Exception ex) {
            throw new DeleteException(ex);
        }
    }

    String[] getLanguages(String textKey) {
        Vector<String> lVector = new Vector<String>();
        Iterator it = this.mLanguageDataStates.keySet().iterator();
        while (it.hasNext()) {
            String lLanguage = (String)it.next();
            this.prepareLanguageForRead(lLanguage);
            LanguageState lLanguageState = (LanguageState)this.mLanguageStates.get(lLanguage);
            if (!lLanguageState.containsKey(textKey)) continue;
            lVector.add(lLanguage);
        }
        return lVector.toArray(new String[0]);
    }

    public void refactorTextKeys(RefactoringService refactoringService) {
        if (this.mLanguageDataStates.isEmpty()) {
            return;
        }
        if (!this.isLanguageStateValid(this.mOriginalLanguage)) {
            return;
        }
        if (!this.hasRawLanguageVersion()) {
            this.createLanguageState("");
        } else {
            this.prepareLanguageForRead("");
        }
        LanguageState lOriginalLanguageState = (LanguageState)this.mLanguageStates.get(this.mOriginalLanguage);
        Reference lReference = (Reference)((Object)((DevelopmentObjectProxy)((Object)this.mOwner))._getKey());
        if (!lOriginalLanguageState.hasKeysToRefactor(lReference, refactoringService)) {
            if (!refactoringService.refactor(lReference).equals(lReference)) {
                Iterator it = ((AbstractList)this.getValidLanguages()).iterator();
                while (it.hasNext()) {
                    String lLanguage = (String)it.next();
                    this.prepareLanguageForModify(lLanguage);
                    this.setLanguageDataState(lLanguage, DataState.MODIFIED);
                }
            }
            return;
        }
        Iterator it = this.mLanguageDataStates.keySet().iterator();
        while (it.hasNext()) {
            String lLanguage = (String)it.next();
            this.prepareLanguageForRead(lLanguage);
            LanguageState lLanguageState = (LanguageState)this.mLanguageStates.get(lLanguage);
            if (!lLanguageState.hasKeysToRefactor(lReference, refactoringService)) continue;
            this.prepareLanguageForModify(lLanguage);
            HashMap lUpdatedKeys = lLanguageState.refactorTextKeys(lReference, refactoringService);
            Iterator lIterator2 = lUpdatedKeys.keySet().iterator();
            while (lIterator2.hasNext()) {
                String lOldKey = (String)lIterator2.next();
                String lNewKey = (String)lUpdatedKeys.get(lOldKey);
                this.mTextObjects.remove(lOldKey);
                this.mTextObjects.put(lNewKey, new TranslatableTextProxy(lNewKey, this));
            }
            this.setLanguageDataState(lLanguage, DataState.MODIFIED);
        }
    }

    public synchronized boolean isReadOnly(String language) {
        if (!this.isLanguageKeyValid(language)) {
            return true;
        }
        if (this.mOwner.getMetamodel().isTransientModeEnabled() || this.getLanguageDataState(language) == DataState.NEW || this.getLanguageDataState(language) == DataState.CANCELLED) {
            return false;
        }
        return sFileSystemService.isReadOnly(this.getAbsolutePath(language));
    }

    public ArrayList getReadOnlyLanguages() {
        ArrayList<String> lResult = new ArrayList<String>();
        Iterator it = this.mLanguageDataStates.keySet().iterator();
        while (it.hasNext()) {
            String lLanguage = (String)it.next();
            if (!this.isReadOnly(lLanguage)) continue;
            lResult.add(lLanguage);
        }
        return lResult;
    }

    private void prepareLanguageForRead(String language) {
        String method = "prepareLanguageForRead()";
        DataState lDataState = this.getLanguageDataState(language);
        if (lDataState == DataState.HOLLOW) {
            this.loadLanguageState(language);
        }
        if (lDataState == DataState.SYNCED || lDataState == DataState.MODIFIED || lDataState == DataState.DELETED) {
            return;
        }
        if (lDataState == DataState.CORRUPT) {
            sCategoryObjectAccess.errorT(sLocation, "prepareLanguageForRead()", "attempt to access " + lDataState + " language of MDO " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey());
            throw new DataStateCorruptException((DevelopmentObject)((Object)this.mOwner), "_mTextPool.prepareLanguageForRead()");
        }
    }

    private void prepareLanguageForModify(String language) throws ObjectNotModifiableException, DataStateDeletedException, DataStateCorruptException {
        String method = "prepareLanguageForModify()";
        DataState lDataState = this.getLanguageDataState(language);
        if (lDataState == DataState.HOLLOW) {
            this.loadLanguageState(language);
        }
        if (this.isReadOnly(language)) {
            sCategoryObjectAccess.errorT(sLocation, "prepareLanguageForModify()", "attempt to modify read-only language \"" + language + "\" of MDO " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey());
            throw new ObjectNotModifiableException((DevelopmentObject)((Object)this.mOwner), "_mTextPool.prepareLanguageForModify(): language \"" + language + "\" of MDO " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey() + " is read-only");
        }
        if (lDataState == DataState.SYNCED || lDataState == DataState.MODIFIED || lDataState == DataState.DELETED) {
            return;
        }
        if (lDataState == DataState.CORRUPT) {
            sCategoryObjectAccess.errorT(sLocation, "prepareLanguageForModify()", "attempt to modify " + lDataState + " language of MDO " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey());
            throw new DataStateCorruptException((DevelopmentObject)((Object)this.mOwner), "_mTextPool.prepareLanguageForModify()");
        }
    }

    private void prepareLanguageForDelete(String language) throws ObjectNotModifiableException, DataStateDeletedException, DataStateCorruptException {
        String method = "prepareLanguageForDelete()";
        DataState lDataState = this.getLanguageDataState(language);
        if (lDataState == DataState.HOLLOW) {
            this.loadLanguageState(language);
        }
        if (this.isReadOnly(language)) {
            sCategoryObjectAccess.errorT(sLocation, "prepareLanguageForDelete()", "attempt to delete read-only language \"" + language + "\" of MDO " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey());
            throw new ObjectNotModifiableException((DevelopmentObject)((Object)this.mOwner), "_mTextPool.prepareLanguageForModify(): language \"" + language + "\" of MDO " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey() + " is read-only");
        }
        if (lDataState == DataState.CORRUPT) {
            sCategoryObjectAccess.errorT(sLocation, "prepareLanguageForDelete()", "attempt to delete " + lDataState + " language of MDO " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey());
            throw new DataStateCorruptException((DevelopmentObject)((Object)this.mOwner), "_mTextPool.prepareLanguageForDelete()");
        }
        if (lDataState == DataState.DELETED) {
            sCategoryObjectAccess.errorT(sLocation, "prepareLanguageForDelete()", "attempt to delete " + lDataState + " language of MDO " + ((DevelopmentObjectProxy)((Object)this.mOwner))._getKey());
            throw new DataStateDeletedException((DevelopmentObject)((Object)this.mOwner), "_mTextPool.prepareLanguageForDelete()");
        }
    }

    private void loadLanguageState(String language) {
        LanguageState lState = null;
        try {
            lState = sLanguageUnmarshaller.unmarshal(this.mOwner, language);
        }
        catch (LoadException ex) {
            ex.printStackTrace();
            this.setLanguageDataState(language, DataState.CORRUPT);
            return;
        }
        this.mLanguageStates.put(language, lState);
        if (language.equals(this.mOriginalLanguage)) {
            this.injectState();
        }
        this.setLanguageDataState(language, DataState.SYNCED);
    }

    public void createLanguageState(String language) {
        LanguageState lNewState = new LanguageState(language, this.mMasterLanguage);
        if (language.equals("") && this.isLanguageStateValid(this.mMasterLanguage)) {
            this.prepareLanguageForRead(this.mMasterLanguage);
            lNewState.addTexts((LanguageState)this.mLanguageStates.get(this.mMasterLanguage));
            this.mOriginalLanguage = "";
        }
        this.mLanguageStates.put(language, lNewState);
        this.setLanguageDataState(language, DataState.NEW);
    }

    private void injectState() {
        HashMap lPreviousTextObjects = (HashMap)this.mTextObjects.clone();
        LanguageState lOriginalLanguageState = (LanguageState)this.mLanguageStates.get(this.mOriginalLanguage);
        Iterator it = lOriginalLanguageState.keyIterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            if (!lPreviousTextObjects.containsKey(lKey)) {
                this.mTextObjects.put(lKey, new TranslatableTextProxy(lKey, this));
            } else {
                lPreviousTextObjects.remove(lKey);
            }
            TranslatableTextProxy lTextObject = (TranslatableTextProxy)this.mTextObjects.get(lKey);
            if (lOriginalLanguageState.getLanguageText(lKey).getTranslate()) continue;
            lTextObject.setDoNotTranslate(true);
        }
        Iterator it2 = lPreviousTextObjects.values().iterator();
        while (it2.hasNext()) {
            TranslatableTextProxy lTranslatableText = (TranslatableTextProxy)it2.next();
            this.mTextObjects.remove(lTranslatableText.getKey());
            lTranslatableText.setDeleted(true);
        }
    }

    public DataState getLanguageDataState(String language) {
        return (DataState)this.mLanguageDataStates.get(language);
    }

    public void setLanguageDataState(String language, DataState newDataState) {
        DataState lOldDataState = (DataState)this.mLanguageDataStates.get(language);
        if (lOldDataState == newDataState) {
            return;
        }
        if (lOldDataState == DataState.NEW && newDataState == DataState.DELETED) {
            this.mLanguageDataStates.put(language, DataState.CANCELLED);
        } else if (lOldDataState != DataState.NEW || newDataState != DataState.MODIFIED) {
            this.mLanguageDataStates.put(language, newDataState);
        }
        if (newDataState == DataState.MODIFIED || newDataState == DataState.DELETED || newDataState == DataState.NEW) {
            if (!(this.mOwner instanceof MetamodelDocument)) {
                ObjectCacheManager lObjectCacheManager = ((RootImpl)this.mOwner.getRoot())._getObjectCacheManager();
                lObjectCacheManager.addTextPoolToWriteSet(this);
                lObjectCacheManager.setDirty(true);
            }
            this.mDirty = true;
        }
    }

    public boolean isModified() {
        return this.mDirty;
    }

    public void setDirty(boolean dirty) {
        this.mDirty = dirty;
    }

    public LanguageState cloneOriginalLanguage() {
        if (this.isEmpty()) {
            return null;
        }
        try {
            return (LanguageState)((LanguageState)this.mLanguageStates.get(this.mOriginalLanguage)).clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public void changeMaxLength(String key, String value) {
        String[] lLanguages = this.getLanguages(key);
        int i = 0;
        while (i < lLanguages.length) {
            TextData lTextdata = ((LanguageState)this.mLanguageStates.get(lLanguages[i])).getLanguageText(key);
            if (lTextdata != null) {
                this.prepareLanguageForModify(lLanguages[i]);
                lTextdata.setMaxLength(value);
            }
            this.setLanguageDataState(lLanguages[i], DataState.MODIFIED);
            ++i;
        }
    }

    public void changeTextType(String key, String value) {
        String[] lLanguages = this.getLanguages(key);
        int i = 0;
        while (i < lLanguages.length) {
            TextData lTextdata = ((LanguageState)this.mLanguageStates.get(lLanguages[i])).getLanguageText(key);
            if (lTextdata != null) {
                this.prepareLanguageForModify(lLanguages[i]);
                lTextdata.setType(value);
            }
            this.setLanguageDataState(lLanguages[i], DataState.MODIFIED);
            ++i;
        }
    }

    public void _invalidate() {
        Iterator it = this.mLanguageDataStates.keySet().iterator();
        while (it.hasNext()) {
            String lLanguage = (String)it.next();
            this.setLanguageDataState(lLanguage, DataState.INVALID);
        }
        Iterator it2 = this.mTextObjects.values().iterator();
        while (it2.hasNext()) {
            ((TranslatableTextProxy)it2.next())._invalidate();
        }
    }

    public void exportToFilesystem(String absolutePathOfMDO) throws SaveException {
        Iterator it = ((AbstractList)this.getValidLanguages()).iterator();
        while (it.hasNext()) {
            String lLanguage = (String)it.next();
            this.prepareLanguageForRead(lLanguage);
            sLanguageMarshaller.marshal(this.mOwner, TextPoolProxy.getAbsolutePath(lLanguage, absolutePathOfMDO), (LanguageState)this.mLanguageStates.get(lLanguage));
        }
    }

    public void exportToFilesystem(String language, String absolutePathOfMDO) throws SaveException {
        this.prepareLanguageForRead(language);
        sLanguageMarshaller.marshal(this.mOwner, TextPoolProxy.getAbsolutePath(language, absolutePathOfMDO), (LanguageState)this.mLanguageStates.get(language));
    }

    public void exportToWriter(String language, OutputStreamWriter writer) throws SaveException {
        String method = "exportToWriter()";
        String lMessage = null;
        if (!this.isLanguageStateValid(language)) {
            lMessage = "the language \"" + language + "\" cannot be exported (not valid)";
        } else if (writer == null) {
            lMessage = "OutputStreamWriter is null";
        } else if (!writer.getEncoding().equals("UTF8")) {
            lMessage = "exportToWriter() requires an OutputStreamWriter with encoding \"UTF-8\"";
        }
        if (lMessage != null) {
            sCategoryTexts.errorT(sLocation, "exportToWriter()", lMessage);
            throw new SaveException(this.exceptionMessage(lMessage));
        }
        this.prepareLanguageForRead(language);
        sLanguageMarshaller.marshal(this.mOwner, (LanguageState)this.mLanguageStates.get(language), writer);
    }

    String getAttributeNameFromTextKey(String textKey) {
        return textKey.substring(textKey.lastIndexOf(64) + 1);
    }

    private boolean hasRawLanguageVersion() {
        return this.mLanguageDataStates.containsKey("");
    }

    public synchronized I18NTextProblem[] validateTexts() {
        if (this.isEmpty()) {
            return new I18NTextProblem[0];
        }
        this.createS2XValidator();
        if (this.mValidator == null) {
            return new I18NTextProblem[0];
        }
        ArrayList lProblems = new ArrayList();
        Iterator it = this.mLanguageDataStates.keySet().iterator();
        while (it.hasNext()) {
            String lLanguage = (String)it.next();
            Iterator it2 = this.mTextObjects.keySet().iterator();
            while (it2.hasNext()) {
                lProblems.addAll(this.checkTextData((String)it2.next(), lLanguage));
            }
        }
        return lProblems.toArray(new I18NTextProblem[0]);
    }

    private void createS2XValidator() {
        if (this.mValidator == null) {
            try {
                this.mValidator = Validator.getInstance((boolean)true);
                this.mValidator.setUseCodePageCheck(true);
            }
            catch (Throwable t) {
                LoggingService.getInstance().logException(t, sLocation, sCategoryTexts, "createS2XValidator()", "could not get S2X Validator: ");
            }
        }
    }

    public synchronized I18NTextProblem[] validateTexts(String language) {
        if (this.isEmpty()) {
            return new I18NTextProblem[0];
        }
        this.createS2XValidator();
        if (this.mValidator == null) {
            return new I18NTextProblem[0];
        }
        ArrayList lProblems = new ArrayList();
        Iterator it = this.mTextObjects.keySet().iterator();
        while (it.hasNext()) {
            lProblems.addAll(this.checkTextData((String)it.next(), language));
        }
        return lProblems.toArray(new I18NTextProblem[0]);
    }

    public synchronized I18NProblem[] validateLanguages() {
        ArrayList<I18NProblemImpl> lProblems = new ArrayList<I18NProblemImpl>();
        if (!(this.mLanguageDataStates.isEmpty() || this.mLanguageDataStates.keySet().contains("") || this.mLanguageDataStates.keySet().contains(this.mMasterLanguage))) {
            lProblems.add(new I18NProblemImpl((MainDevelopmentObject)((Object)this.mOwner), "Original language is missing although translations were found", SeverityEnum.FATAL));
        }
        return lProblems.toArray(new I18NProblem[0]);
    }

    public synchronized void repair() throws DeleteException {
        if (this.isEmpty()) {
            return;
        }
        HashMap lTextObjects = (HashMap)this.mTextObjects.clone();
        Iterator it = lTextObjects.values().iterator();
        while (it.hasNext()) {
            TranslatableTextProxy lTextObject = (TranslatableTextProxy)it.next();
            if (lTextObject.getDevelopmentObject() != null) continue;
            lTextObject.delete();
        }
    }

    ArrayList checkTextData(String key, String language) {
        String method = "checkTextData()";
        ArrayList<I18NTextProblemImpl> lResult = new ArrayList<I18NTextProblemImpl>();
        TranslatableText lTextObject = this.getText(key);
        if (lTextObject.getDevelopmentObject() == null) {
            String lMessage = "Found orphaned translatable text \"" + lTextObject.getText(language) + "\" not belonging to any development object";
            lResult.add(new I18NTextProblemImpl(lTextObject, language, lMessage, SeverityEnum.WARNING));
            return lResult;
        }
        if (lTextObject.getDoNotTranslate()) {
            return lResult;
        }
        TextData lTextData = this.getTextData(key, language);
        if (lTextData == null) {
            return lResult;
        }
        String lText = lTextData.getText();
        try {
            String lMessage = this.mValidator.checkTextLength(lText, lTextData.getType(), Integer.parseInt(lTextData.getMaxLength()));
            if (!lMessage.equals("")) {
                lResult.add(new I18NTextProblemImpl(lTextObject, language, lMessage, SeverityEnum.ERROR));
            }
            if (sI18NService.isCodepageValidationEnabled()) {
                lMessage = language.equals("") ? this.mValidator.checkAgainstCodepage(lText, this.mMasterLanguage) : this.mValidator.checkAgainstCodepage(lText, language);
            }
            if (!lMessage.equals("")) {
                lResult.add(new I18NTextProblemImpl(lTextObject, language, lMessage, SeverityEnum.WARNING));
            }
            if (!sSourceValidator.isValid(lText)) {
                ArrayList lWarnings = sSourceValidator.getWarnings();
                Iterator it = ((AbstractList)lWarnings).iterator();
                while (it.hasNext()) {
                    String lWarning = (String)it.next();
                    lResult.add(new I18NTextProblemImpl(lTextObject, language, lWarning, SeverityEnum.WARNING));
                }
            }
        }
        catch (Throwable t) {
            LoggingService.getInstance().logException(t, sLocation, sCategoryTexts, "checkTextData()", "error validating translatable texts: ");
        }
        return lResult;
    }

    void setDoNotTranslate(String key, boolean doNotTranslate) {
        this.prepareLanguageForRead(this.mOriginalLanguage);
        LanguageState lState = (LanguageState)this.mLanguageStates.get(this.mOriginalLanguage);
        lState.getLanguageText(key).setTranslate(!doNotTranslate);
    }

    private ArrayList getValidLanguages() {
        ArrayList<String> lResult = new ArrayList<String>();
        Iterator it = this.mLanguageDataStates.keySet().iterator();
        while (it.hasNext()) {
            String lLanguage = (String)it.next();
            if (!this.isLanguageStateValid(lLanguage)) continue;
            lResult.add(lLanguage);
        }
        return lResult;
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }

    static {
        try {
            sSourceValidator = new SourceValidator();
        }
        catch (Throwable t) {
            LoggingService.getInstance().logException(t, sLocation, sCategoryTexts, "TextPoolProxy.<clinit>", "could not get S2X SourceValidator: ");
        }
        sFileSystemService = FileSystemService.getInstance();
        sLanguageMarshaller = new S2XLanguageMarshaller();
        sLanguageUnmarshaller = new S2XLanguageUnmarshaller();
    }
}

