/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.i18n;

import com.sap.ide.metamodel.core.i18n.I18NProblemImpl;
import com.sap.ide.metamodel.general.SeverityEnum;
import com.sap.ide.metamodel.general.i18n.I18NTextProblem;
import com.sap.ide.metamodel.general.i18n.TranslatableText;

public class I18NTextProblemImpl
extends I18NProblemImpl
implements I18NTextProblem {
    private TranslatableText mText;
    private String mLanguage;

    private I18NTextProblemImpl() {
    }

    I18NTextProblemImpl(TranslatableText text, String language, String message, SeverityEnum severity) {
        super(text.getTextPool().getOwner(), message, severity);
        this.mText = text;
        this.mLanguage = language;
    }

    public TranslatableText getText() {
        return this.mText;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public String toString() {
        StringBuffer lResult = new StringBuffer();
        String lLineSeparator = System.getProperty("line.separator");
        lResult.append("Development object " + this.mText.getDevelopmentObject().getKey() + ":" + lLineSeparator);
        lResult.append("    attribute: " + this.mText.getAttributeName() + lLineSeparator);
        lResult.append("    full text: " + this.mText.getText() + lLineSeparator);
        lResult.append("    message:   " + this.mMessage + lLineSeparator);
        lResult.append("    severity:  " + this.mSeverity.toString().toUpperCase());
        return lResult.toString();
    }
}

