/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.compare;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.compare.MetamodelDeltaImpl;
import com.sap.ide.metamodel.general.compare.PropertyDelta;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.exception.ReflectionException;
import com.sap.ide.metamodel.general.metainfo.Property;

public class PropertyDeltaImpl
extends MetamodelDeltaImpl
implements PropertyDelta {
    private Property mProperty;
    private Object mOldValue;
    private Object mNewValue;

    public PropertyDeltaImpl(DevelopmentObjectProxy sourceObject, String propertyName, Object newValue) {
        super(sourceObject);
        this.mProperty = this.mSourceObject.getMetaClass().getProperty(propertyName);
        try {
            this.mOldValue = this.mSourceObject.getProperty(this.mProperty);
        }
        catch (ReflectionException ex) {
            this.mOldValue = null;
        }
        this.mNewValue = newValue;
    }

    protected void _apply() throws MetamodelException {
        this.mSourceObject.setProperty(this.mProperty, this.mNewValue);
    }

    protected void _revert() throws MetamodelException {
        this.mSourceObject.setProperty(this.mProperty, this.mOldValue);
    }

    public Object getNewValue() {
        return this.mNewValue;
    }

    public Object getOldValue() {
        return this.mOldValue;
    }

    public Property getProperty() {
        return this.mProperty;
    }

    public String toString() {
        return "PropertyDelta(" + this.mSourceObject._getKey() + ", " + this.mProperty.getName() + ": " + (this.mOldValue == null ? "null" : "\"" + this.mOldValue.toString() + "\"") + " -> " + (this.mNewValue == null ? "null" : "\"" + this.mNewValue.toString() + "\"") + ")";
    }
}

