/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.compare;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.compare.AggregationDeltaImpl;
import com.sap.ide.metamodel.core.compare.AggregationNegativeDeltaImpl;
import com.sap.ide.metamodel.core.compare.AggregationPositiveDeltaImpl;
import com.sap.ide.metamodel.core.compare.AssociationDeltaImpl;
import com.sap.ide.metamodel.core.compare.AssociationNegativeDeltaImpl;
import com.sap.ide.metamodel.core.compare.AssociationPositiveDeltaImpl;
import com.sap.ide.metamodel.core.compare.CompareResultImpl;
import com.sap.ide.metamodel.core.compare.PropertyDeltaImpl;
import com.sap.ide.metamodel.core.compare.RelationOrderingDeltaImpl;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.compare.CompareResult;
import java.util.ArrayList;

public class CompareContext {
    private DevelopmentObjectProxy mObject1;
    private DevelopmentObjectProxy mObject2;
    private boolean mIncludeChildren;
    private boolean mIncludeAssociations;
    private boolean mIncludeDanglingReferences;
    private ArrayList mInnerObjects1;
    private ArrayList mInnerObjects2;
    private CompareResultImpl mCompareResult;

    public CompareContext(DevelopmentObjectProxy object1, DevelopmentObjectProxy object2, boolean includeChildren, boolean includeAssociations) {
        this.mObject1 = object1;
        this.mObject2 = object2;
        this.mIncludeChildren = includeChildren;
        this.mIncludeAssociations = includeAssociations;
        this.mInnerObjects1 = null;
        this.mInnerObjects2 = null;
    }

    public CompareContext(DevelopmentObjectProxy object1, DevelopmentObjectProxy object2, boolean includeChildren, boolean includeAssociations, boolean includeDanglingReferences) {
        this(object1, object2, includeChildren, includeAssociations);
        this.mIncludeDanglingReferences = includeDanglingReferences;
        this.mCompareResult = new CompareResultImpl();
    }

    public boolean getIncludeAssociations() {
        return this.mIncludeAssociations;
    }

    public boolean getIncludeChildren() {
        return this.mIncludeChildren;
    }

    public boolean getIncludeDanglingReferences() {
        return this.mIncludeDanglingReferences;
    }

    public CompareResult getResult() {
        if (this.mCompareResult == null) {
            return new CompareResultImpl();
        }
        return this.mCompareResult;
    }

    public boolean isInnerObject1(DevelopmentObject object) {
        this.computeInnerObjects();
        return this.mInnerObjects1.contains(object);
    }

    public boolean isInnerObject2(DevelopmentObject object) {
        this.computeInnerObjects();
        return this.mInnerObjects2.contains(object);
    }

    public boolean associateSameInnerObject(DevelopmentObject associatedObject1, DevelopmentObject associatedObject2) {
        if (associatedObject1 == null && associatedObject2 == null) {
            return true;
        }
        if (associatedObject1 != null ^ associatedObject2 != null) {
            return false;
        }
        String lRootPath1 = this.mObject1._getKey().getPath();
        String lAssociatedObjectPath1 = ((DevelopmentObjectProxy)associatedObject1)._getKey().getPath();
        String lRootPath2 = this.mObject2._getKey().getPath();
        String lAssociatedObjectPath2 = ((DevelopmentObjectProxy)associatedObject2)._getKey().getPath();
        String lRelativePath1 = lAssociatedObjectPath1;
        if (lRootPath1.length() > 0) {
            lRelativePath1 = lAssociatedObjectPath1.substring(lRootPath1.length() + 1);
        }
        String lRelativePath2 = lAssociatedObjectPath2;
        if (lRootPath2.length() > 0) {
            lRelativePath2 = lAssociatedObjectPath2.substring(lRootPath2.length() + 1);
        }
        return lRelativePath1.equals(lRelativePath2);
    }

    public boolean sameNumberOfChildren() {
        this.computeInnerObjects();
        return this.mInnerObjects1.size() == this.mInnerObjects2.size();
    }

    public void addPropertyDelta(DevelopmentObjectProxy sourceObject, String propertyName, Object newValue) {
        this.mCompareResult.addDelta(new PropertyDeltaImpl(sourceObject, propertyName, newValue));
    }

    public void addAggregationDelta(DevelopmentObjectProxy sourceObject, String aggregationName, DevelopmentObjectProxy objectToDelete, DevelopmentObjectProxy objectToCreate) {
        this.mCompareResult.addDelta(new AggregationDeltaImpl(sourceObject, aggregationName, objectToDelete, objectToCreate));
    }

    public void addAggregationPositiveDelta(DevelopmentObjectProxy sourceObject, String aggregationName, DevelopmentObjectProxy objectToCreate) {
        this.mCompareResult.addDelta(new AggregationPositiveDeltaImpl(sourceObject, aggregationName, objectToCreate));
    }

    public void addAggregationNegativeDelta(DevelopmentObjectProxy sourceObject, String aggregationName, DevelopmentObjectProxy objectToDelete) {
        this.mCompareResult.addDelta(new AggregationNegativeDeltaImpl(sourceObject, aggregationName, objectToDelete));
    }

    public void addAssociationDelta(DevelopmentObjectProxy sourceObject, String associationName, DevelopmentObjectProxy objectToRemove, DevelopmentObjectProxy objectToReference) {
        this.mCompareResult.addDelta(new AssociationDeltaImpl(sourceObject, associationName, objectToRemove, objectToReference, this.isInnerObject2(objectToReference)));
    }

    public void addAssociationPositiveDelta(DevelopmentObjectProxy sourceObject, String associationName, DevelopmentObjectProxy objectToReference) {
        this.mCompareResult.addDelta(new AssociationPositiveDeltaImpl(sourceObject, associationName, objectToReference, this.isInnerObject2(objectToReference)));
    }

    public void addAssociationNegativeDelta(DevelopmentObjectProxy sourceObject, String associationName, DevelopmentObjectProxy objectToRemove) {
        this.mCompareResult.addDelta(new AssociationNegativeDeltaImpl(sourceObject, associationName, objectToRemove));
    }

    public void addRelationOrderingDelta(DevelopmentObjectProxy sourceObject, String relationName, String[] ordering) {
        this.mCompareResult.addDelta(new RelationOrderingDeltaImpl(sourceObject, relationName, ordering));
    }

    private void computeInnerObjects() {
        if (this.mInnerObjects1 != null) {
            return;
        }
        this.mInnerObjects1 = new ArrayList();
        MetamodelIterator it = this.mObject1.iterator();
        while (it.hasNext()) {
            this.mInnerObjects1.add(it.next());
        }
        this.mInnerObjects2 = new ArrayList();
        MetamodelIterator it2 = this.mObject2.iterator();
        while (it2.hasNext()) {
            this.mInnerObjects2.add(it2.next());
        }
    }
}

