/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.compare;

import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.compare.MetamodelDeltaImpl;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.compare.AssociationPositiveDelta;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.metainfo.Association;

public class AssociationPositiveDeltaImpl
extends MetamodelDeltaImpl
implements AssociationPositiveDelta {
    private Association mAssociation;
    private DevelopmentObjectProxy mObjectToReference;
    private DevelopmentObjectProxy mObjectReferenced;
    private boolean mObjectToReferenceIsInnerObject;

    public AssociationPositiveDeltaImpl(DevelopmentObjectProxy sourceObject, String associationName, DevelopmentObjectProxy objectToReference, boolean objectToReferenceIsInnerObject) {
        super(sourceObject);
        this.mAssociation = this.mSourceObject.getMetaClass().getAssociation(associationName);
        this.mObjectToReference = objectToReference;
        this.mObjectToReferenceIsInnerObject = objectToReferenceIsInnerObject;
    }

    public void _apply() throws MetamodelException {
        DevelopmentObjectKey lKey = this.mObjectToReference._getKey();
        DevelopmentObjectProxy lObjectToReference = (DevelopmentObjectProxy)this.mSourceObject.getMetamodel().getObjectFromKey(lKey);
        if (lObjectToReference == null) {
            throw new MetamodelException("The object " + lKey + " to reference could not be found!");
        }
        this.mSourceObject.addToAssociation(this.mAssociation, lObjectToReference);
        this.mObjectReferenced = lObjectToReference;
    }

    public void _revert() throws MetamodelException {
        this.mSourceObject.removeFromAssociation(this.mAssociation, this.mObjectReferenced);
    }

    public Association getAssociation() {
        return this.mAssociation;
    }

    public DevelopmentObject getObjectToReference() {
        return this.mObjectToReference;
    }

    public String toString() {
        String lKey = this.mObjectToReference.getName();
        if (this.mObjectToReference.isMDO()) {
            lKey = ((CoreMainDevelopmentObject)((Object)this.mObjectToReference)).getPackage() + "." + lKey;
        }
        return "AssociationPositiveDelta(" + this.mSourceObject._getKey() + ", " + this.mAssociation.getName() + ": " + lKey + ")";
    }
}

