/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core.clipboard;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.clipboard.ClipboardObjectImpl;
import com.sap.ide.metamodel.core.metainfo.AggregationImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.core.service.FileSystemService;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.IncompleteRefactoringInfoException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ClipboardService {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.clipboard.ClipboardService");
    private static final Category sCategoryClipboard = Category.getCategory((String)"/MetamodelCore/Clipboard");
    private static FileSystemService sFileSystemService = FileSystemService.getInstance();
    private HashMap mClipboardObjects;
    private ArrayList mRootObjects = new ArrayList();
    private RefactoringService mRefactoringService;

    ClipboardService() {
        this.mClipboardObjects = new HashMap();
        this.mRefactoringService = new RefactoringService();
    }

    public boolean isEverythingExcluded() {
        Iterator it = this.mClipboardObjects.values().iterator();
        while (it.hasNext()) {
            ClipboardObjectImpl lObject = (ClipboardObjectImpl)it.next();
            if (lObject.isExcluded()) continue;
            return false;
        }
        return true;
    }

    public ClipboardObject[] getObjectsToRefactor() {
        ArrayList<ClipboardObjectImpl> lResult = new ArrayList<ClipboardObjectImpl>();
        Iterator it = this.mClipboardObjects.values().iterator();
        while (it.hasNext()) {
            ClipboardObjectImpl lObject = (ClipboardObjectImpl)it.next();
            if (!lObject.requiresRefactoring()) continue;
            lResult.add(lObject);
        }
        return lResult.toArray(new ClipboardObject[0]);
    }

    public ClipboardObject[] getClipboardContent() {
        return this.mRootObjects.toArray(new ClipboardObject[0]);
    }

    public void setRefactoringRequired(DevelopmentObjectKey key) {
        ClipboardObjectImpl lItem = (ClipboardObjectImpl)this.mClipboardObjects.get(((ForeignReference)key).toReferenceString());
        if (lItem != null) {
            lItem.setRequiresRefactoring(true);
        }
    }

    public void add(DevelopmentObjectProxy object) {
        ClipboardObjectImpl lItem = new ClipboardObjectImpl(object);
        this.mClipboardObjects.put(((ForeignReference)object._getKey()).toReferenceString(), lItem);
        DevelopmentObjectProxy lParent = object._getParent();
        if (lParent != null) {
            ClipboardObjectImpl lParentObject = (ClipboardObjectImpl)this.mClipboardObjects.get(((Reference)((Object)lParent._getKey())).toReferenceString());
            if (lParentObject != null) {
                lItem.setParent(lParentObject);
            } else {
                this.mRootObjects.add(lItem);
            }
        } else {
            this.mRootObjects.add(lItem);
        }
    }

    public DevelopmentObjectKey[] getRootObjectKeys() {
        ArrayList<DevelopmentObjectKey> lResult = new ArrayList<DevelopmentObjectKey>(this.mRootObjects.size());
        int i = 0;
        while (i < this.mRootObjects.size()) {
            lResult.add(((ClipboardObjectImpl)this.mRootObjects.get(i)).getOriginalKey());
            ++i;
        }
        return lResult.toArray(new DevelopmentObjectKey[0]);
    }

    public boolean isExcluded(Reference reference) {
        ClipboardObjectImpl lObject = (ClipboardObjectImpl)this.mClipboardObjects.get(reference);
        if (lObject == null) {
            lObject = (ClipboardObjectImpl)this.mClipboardObjects.get(reference.toReferenceString());
        }
        return lObject != null && lObject.isExcluded();
    }

    public void clear() {
        this.mRootObjects.clear();
        this.mClipboardObjects.clear();
    }

    public boolean isEmpty() {
        return this.mClipboardObjects.isEmpty();
    }

    public String getNewName(ForeignReference proxyRef) {
        ClipboardObjectImpl lItem = (ClipboardObjectImpl)this.mClipboardObjects.get(proxyRef.toReferenceString());
        if (lItem != null) {
            return lItem.getNewName();
        }
        return null;
    }

    public String getNewPackage(ForeignReference proxyRef) {
        ClipboardObjectImpl lItem = (ClipboardObjectImpl)this.mClipboardObjects.get(proxyRef.toReferenceString());
        if (lItem != null) {
            return lItem.getNewPackage();
        }
        return null;
    }

    public Reference refactor(Reference reference) {
        return this.mRefactoringService.refactor(reference);
    }

    void refactorKeys(MetamodelObject newParent, AggregationImpl aggregation) {
        Iterator it = this.mClipboardObjects.values().iterator();
        while (it.hasNext()) {
            ClipboardObjectImpl lItem = (ClipboardObjectImpl)it.next();
            if (!lItem.isModified() && lItem.getParent() != null) continue;
            DevelopmentObjectKey lOldKey = lItem.getOriginalKey();
            DevelopmentObjectKey lNewKey = null;
            lNewKey = lItem.getParent() == null ? lItem.getRefactoredKey(newParent, aggregation) : lItem.getRefactoredKey(newParent, null);
            if (lOldKey.equals(lNewKey)) continue;
            this.mRefactoringService.add((Reference)((Object)lOldKey), (Reference)((Object)lNewKey));
        }
    }

    void checkAllKeysRefactored() throws IncompleteRefactoringInfoException {
        String method = "checkAllKeysRefactored()";
        ArrayList<ClipboardObjectImpl> lResult = new ArrayList<ClipboardObjectImpl>();
        Iterator it = this.mClipboardObjects.values().iterator();
        while (it.hasNext()) {
            ClipboardObjectImpl lItem = (ClipboardObjectImpl)it.next();
            if (!lItem.requiresRefactoring() || lItem.isExcluded() || lItem.isModified()) continue;
            lResult.add(lItem);
        }
        if (!lResult.isEmpty()) {
            StringBuffer lBuf = new StringBuffer("The following " + lResult.size() + " objects still need to be refactored:");
            int i = 0;
            while (i < lResult.size()) {
                lBuf.append("\n" + ((ClipboardObjectImpl)lResult.get(i)).toString());
                ++i;
            }
            sCategoryClipboard.errorT(sLocation, "checkAllKeysRefactored()", "incomplete refactoring info: " + lResult.size() + " keys still need to be refactored");
            throw new IncompleteRefactoringInfoException(lBuf.toString());
        }
    }

    void checkMDOPathLengths(MDOLocator mdoLocator, SourcePathIdentifier sourcePathIdentifier) throws CreateException {
        String method = "checkMDOPathLengths()";
        Iterator it = this.mClipboardObjects.values().iterator();
        while (it.hasNext()) {
            ClipboardObjectImpl lItem = (ClipboardObjectImpl)it.next();
            if (!lItem.isMDO() || sFileSystemService.computeAbsolutePath(mdoLocator, lItem.getNewPackage(), lItem.getNewName(), (MDOEnum)lItem.getType(), sourcePathIdentifier) != null) continue;
            String lMessage = "could not get a valid path for " + lItem.getType() + " \"" + lItem.getNewPackage() + "." + lItem.getNewName() + "\" (path too long?)";
            sCategoryClipboard.errorT(sLocation, "checkMDOPathLengths()", lMessage);
            throw new CreateException(this.exceptionMessage(lMessage));
        }
    }

    void reset() {
        Iterator it = this.mClipboardObjects.values().iterator();
        while (it.hasNext()) {
            ((ClipboardObjectImpl)it.next()).reset();
        }
        this.mRefactoringService.clear();
    }

    RefactoringService getRefactoringService() {
        return this.mRefactoringService;
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }
}

