/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.core;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.CoreMainDevelopmentObject;
import com.sap.ide.metamodel.core.DataState;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.MetamodelAnnotationImpl;
import com.sap.ide.metamodel.core.MetamodelObjectImpl;
import com.sap.ide.metamodel.core.PostOrderIterator;
import com.sap.ide.metamodel.core.PreOrderIterator;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.i18n.TextPoolProxy;
import com.sap.ide.metamodel.core.metainfo.AggregationImpl;
import com.sap.ide.metamodel.core.metainfo.MetaClassImpl;
import com.sap.ide.metamodel.core.metainfo.PropertyImpl;
import com.sap.ide.metamodel.core.refactoring.MDORefactoringHistoryEntryImpl;
import com.sap.ide.metamodel.core.refactoring.MDORefactoringTaskImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoredMDOImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoredObjectImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoringHistoryEntryImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.core.refactoring.RefactoringTaskImpl;
import com.sap.ide.metamodel.core.service.MDOAccessProblemImpl;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MDOAccessProblem;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelAnnotation;
import com.sap.ide.metamodel.general.MetamodelDocument;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.MetamodelVisitor;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.TraverseModeEnum;
import com.sap.ide.metamodel.general.compare.CompareResult;
import com.sap.ide.metamodel.general.event.AllReferencedObjectsRemovedEvent;
import com.sap.ide.metamodel.general.event.MDODiscardedEvent;
import com.sap.ide.metamodel.general.event.MDOReloadedEvent;
import com.sap.ide.metamodel.general.event.MetamodelUserEvent;
import com.sap.ide.metamodel.general.event.ObjectCreatedEvent;
import com.sap.ide.metamodel.general.event.ObjectDeletedEvent;
import com.sap.ide.metamodel.general.event.ObjectRefactoredEvent;
import com.sap.ide.metamodel.general.event.PropertyChangedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectAddedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectChangedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectMovedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectRefactoredEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectRemovedEvent;
import com.sap.ide.metamodel.general.event.SubObjectCreatedEvent;
import com.sap.ide.metamodel.general.event.SubObjectDeletedEvent;
import com.sap.ide.metamodel.general.event.SubObjectMovedEvent;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DataStateCorruptException;
import com.sap.ide.metamodel.general.exception.DataStateDeletedException;
import com.sap.ide.metamodel.general.exception.DataStateException;
import com.sap.ide.metamodel.general.exception.DataStateInvalidException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.IllegalObjectException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.ObjectNotModifiableException;
import com.sap.ide.metamodel.general.exception.RefactoringException;
import com.sap.ide.metamodel.general.exception.ReflectionException;
import com.sap.ide.metamodel.general.exception.ValidationException;
import com.sap.ide.metamodel.general.metainfo.Aggregation;
import com.sap.ide.metamodel.general.metainfo.Association;
import com.sap.ide.metamodel.general.metainfo.CardinalityEnum;
import com.sap.ide.metamodel.general.metainfo.DeclarationTypeEnum;
import com.sap.ide.metamodel.general.metainfo.MetaClass;
import com.sap.ide.metamodel.general.metainfo.Property;
import com.sap.ide.metamodel.general.metainfo.Relation;
import com.sap.ide.metamodel.general.refactoring.RefactoringHistoryEntry;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class DevelopmentObjectProxy
extends MetamodelObjectImpl
implements DevelopmentObject {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.core.DevelopmentObjectProxy");
    private DataState mDataState = DataState.HOLLOW;
    private CoreMainDevelopmentObject mMDO;
    private ArrayList mRefactoringHistory = null;
    protected RootImpl _mRoot = null;
    protected DevelopmentObjectState _mState;
    protected DevelopmentObjectProxy _mParent = null;
    protected String _mAggregationKey;
    protected ForeignReference mKey = null;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$DevelopmentObjectProxy;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sap$ide$metamodel$general$SourcePathIdentifier;
    static /* synthetic */ Class class$com$sap$ide$metamodel$general$DevelopmentObject;

    protected abstract DevelopmentObjectState _createState();

    protected abstract void _injectState(DevelopmentObjectState var1);

    protected abstract void _injectStateFromClipboard(DevelopmentObjectState var1, HashMap var2, HashMap var3, SourcePathIdentifier var4) throws CreateException;

    protected abstract void _dropReferences();

    public abstract String _getClassName();

    public abstract String _toString();

    public abstract Vector _validate();

    public abstract void _delete() throws DeleteException;

    public abstract ArrayList _clipboardPaste(AggregationImpl var1, HashMap var2, ArrayList var3, HashMap var4, HashMap var5, SourcePathIdentifier var6) throws CreateException;

    public abstract void _childObjectRefactored(String var1, DevelopmentObjectProxy var2);

    public abstract void _removeChildObject(DevelopmentObjectProxy var1, String var2);

    public abstract void _addChildObject(DevelopmentObjectProxy var1, String var2);

    public abstract void _invalidateAssociations();

    public abstract Vector _getAllChildren(boolean var1);

    public Root getRoot() {
        return this._mRoot;
    }

    protected void _initialize(RootImpl root) {
        this._mRoot = root;
        super._initialize(root);
    }

    public MetamodelIterator iterator(TraverseModeEnum traverseMode) {
        return this.iterator(true, true, traverseMode == TraverseModeEnum.PREORDER);
    }

    public MetamodelIterator iterator(boolean loadAllFiles, boolean includeMDOs, boolean preOrder) {
        String method = "iterator(boolean, boolean, boolean)";
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            if (loadAllFiles) {
                try {
                    this._prepareForRead();
                }
                catch (DataStateException ex) {
                    String lMessage = "the object " + this._getKey() + " is " + this.mDataState;
                    MetamodelObjectImpl.sCategoryIntegrity.errorT(sLocation, "iterator(boolean, boolean, boolean)", lMessage);
                    throw new ConcurrentModificationException(this.exceptionMessage(lMessage));
                }
            }
            if (preOrder) {
                PreOrderIterator preOrderIterator = new PreOrderIterator(this, loadAllFiles, includeMDOs);
                return preOrderIterator;
            }
            PostOrderIterator postOrderIterator = new PostOrderIterator(this, loadAllFiles, includeMDOs);
            return postOrderIterator;
        }
    }

    public void traverse(MetamodelVisitor visitor, TraverseModeEnum traverseMode) {
        MetamodelIterator it = this.iterator(traverseMode);
        while (it.hasNext()) {
            it.next().accept(visitor);
        }
    }

    public boolean isEqualTo(DevelopmentObject object) {
        return this.isEqualTo(object, true, true);
    }

    public boolean isEqualTo(DevelopmentObject object, boolean includeChildren, boolean includeAssociations) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        CompareContext lCompareContext = new CompareContext(this, (DevelopmentObjectProxy)object, includeChildren, includeAssociations);
        if (includeChildren && !lCompareContext.sameNumberOfChildren()) {
            return false;
        }
        return this._isEqualTo(object, lCompareContext, true);
    }

    public boolean _isEqualTo(DevelopmentObject object, CompareContext compareContext, boolean isRootObject) {
        this._prepareForRead();
        ((DevelopmentObjectProxy)object)._prepareForRead();
        return true;
    }

    public CompareResult compareTo(DevelopmentObject object) {
        return this.compareTo(object, true, true, false);
    }

    public CompareResult compareTo(DevelopmentObject object, boolean includeChildren, boolean includeAssociations, boolean includeDanglingReferences) {
        String method = "compareTo()";
        CompareContext lCompareContext = new CompareContext(this, (DevelopmentObjectProxy)object, includeChildren, includeAssociations, includeDanglingReferences);
        if (object == this) {
            return lCompareContext.getResult();
        }
        if (object == null) {
            String lMessage = "the object to compare to is null";
            MetamodelObjectImpl.sCategoryCompare.errorT(sLocation, "compareTo()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        if (object.getClass() != this.getClass()) {
            String lMessage = "the object to compare to is of a different class";
            MetamodelObjectImpl.sCategoryCompare.errorT(sLocation, "compareTo()", lMessage);
            throw new IllegalArgumentException(this.exceptionMessage(lMessage));
        }
        this._compareTo((DevelopmentObjectProxy)object, lCompareContext, true);
        return lCompareContext.getResult();
    }

    public void _compareTo(DevelopmentObjectProxy object, CompareContext compareContext, boolean isRootObject) {
        this._prepareForRead();
        object._prepareForRead();
    }

    public DevelopmentObjectProxy _getParent() {
        return this._mParent;
    }

    public String _getAggregationKey() {
        return this._mAggregationKey;
    }

    public DevelopmentObject getParent() {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            this._prepareForRead();
            DevelopmentObjectProxy developmentObjectProxy = this._mParent;
            return developmentObjectProxy;
        }
    }

    public void _setDataState(DataState newDataState) {
        if (this.mDataState != newDataState) {
            if (this.mDataState == DataState.NEW && newDataState == DataState.DELETED) {
                this.mDataState = DataState.CANCELLED;
            } else {
                if (this.mDataState != DataState.NEW || newDataState != DataState.MODIFIED) {
                    this.mDataState = newDataState;
                }
                if (newDataState == DataState.MODIFIED || newDataState == DataState.DELETED || newDataState == DataState.NEW) {
                    if (this instanceof CoreMainDevelopmentObject) {
                        if (!(this instanceof MetamodelDocument)) {
                            this._mObjectCacheManager.addMDOToWriteSet((CoreMainDevelopmentObject)((Object)this));
                            this._mObjectCacheManager.setDirty(true);
                        }
                    } else {
                        DevelopmentObjectProxy lParent = this._getParent();
                        if (lParent != null && lParent instanceof DevelopmentObjectProxy) {
                            lParent._setDataState(DataState.MODIFIED);
                        }
                    }
                }
            }
        }
    }

    public boolean isReadOnly() {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            if (this._mMetamodel.isTransientModeEnabled() || this.mDataState == DataState.NEW || this.mDataState == DataState.CANCELLED) {
                boolean bl = false;
                return bl;
            }
            boolean bl = MetamodelObjectImpl.sFileSystemService.isReadOnly(this.getMDO().getAbsolutePath());
            return bl;
        }
    }

    public DataState _getDataState() {
        return this.mDataState;
    }

    public boolean isNew() {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            boolean bl = this.mDataState == DataState.NEW;
            return bl;
        }
    }

    public boolean isModified() {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            boolean bl = this.mDataState == DataState.MODIFIED;
            return bl;
        }
    }

    public boolean isDeleted() {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            boolean bl = this.mDataState == DataState.DELETED || this.mDataState == DataState.CANCELLED;
            return bl;
        }
    }

    public MainDevelopmentObject getMDO() {
        return (MainDevelopmentObject)((Object)this._getMDO());
    }

    public boolean isValid() {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            boolean bl = this._isValid();
            return bl;
        }
    }

    public boolean _isValid() {
        return this.mDataState != DataState.INVALID && this.mDataState != DataState.CORRUPT && this.mDataState != DataState.DELETED && this.mDataState != DataState.CANCELLED;
    }

    protected void _prepareForRead() throws DataStateDeletedException, DataStateCorruptException {
        String method = "_prepareForRead()";
        if (this.mDataState == DataState.HOLLOW) {
            this.loadState();
        } else {
            if (this.mDataState == DataState.DELETED || this.mDataState == DataState.CANCELLED) {
                String lMessage = "attempt to access " + this.mDataState + " object: " + this._getKey();
                MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForRead()", lMessage);
                throw new DataStateDeletedException(this, this.exceptionMessage(lMessage));
            }
            if (this.mDataState == DataState.CORRUPT) {
                String lMessage = "attempt to access " + this.mDataState + " object: " + this._getKey();
                MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForRead()", lMessage);
                throw new DataStateCorruptException(this, this.exceptionMessage(lMessage));
            }
            if (this.mDataState == DataState.INVALID) {
                String lMessage = "attempt to access " + this.mDataState + " object: " + this._getKey();
                MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForRead()", lMessage);
                throw new DataStateInvalidException(this, this.exceptionMessage(lMessage));
            }
        }
    }

    protected void _prepareForModify() throws ObjectNotModifiableException, DataStateDeletedException, DataStateCorruptException {
        String method = "_prepareForModify()";
        if (this.mDataState == DataState.HOLLOW) {
            this.loadState();
        }
        if (this.isReadOnly()) {
            String lMessage = "attempt to modify read-only object: " + this._getKey();
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForModify()", lMessage);
            throw new ObjectNotModifiableException(this, this.exceptionMessage(lMessage));
        }
        if (this.mDataState == DataState.DELETED || this.mDataState == DataState.CANCELLED) {
            String lMessage = "attempt to modify " + this.mDataState + " object: " + this._getKey();
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForModify()", lMessage);
            throw new DataStateDeletedException(this, this.exceptionMessage(lMessage));
        }
        if (this.mDataState == DataState.CORRUPT) {
            String lMessage = "attempt to modify " + this.mDataState + " object: " + this._getKey();
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForModify()", lMessage);
            throw new DataStateCorruptException(this, this.exceptionMessage(lMessage));
        }
        if (this.mDataState == DataState.INVALID) {
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForModify()", "attempt to access " + this.mDataState + " object: " + this._getKey());
            throw new DataStateInvalidException(this, "Attempt to access " + this.mDataState + " object: " + this._getKey());
        }
    }

    protected void _prepareForDelete() throws ObjectNotModifiableException, DataStateDeletedException, DataStateCorruptException {
        String method = "_prepareForDelete()";
        if (this.mDataState == DataState.HOLLOW) {
            this.loadState();
        }
        if (this.isReadOnly()) {
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForDelete()", "attempt to delete read-only object: " + this._getKey());
            throw new ObjectNotModifiableException(this, "Attempt to delete read-only object: " + this._getKey());
        }
        if (this instanceof CoreMainDevelopmentObject && this._mParent != null && this._mParent.isReadOnly()) {
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForDelete()", "attempt to delete MDO with read-only parent: " + this._getKey() + " (parent: " + this._mParent._getKey() + ")");
            throw new ObjectNotModifiableException(this, "Attempt to delete MDO with read-only parent: " + this._getKey() + " (parent: " + this._mParent._getKey() + ")");
        }
        MetamodelIterator it = this.iterator(true, true, false);
        while (it.hasNext()) {
            DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)it.next();
            if (!(lProxy instanceof CoreMainDevelopmentObject)) continue;
            if (lProxy.isReadOnly()) {
                MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForDelete()", "attempt to delete object with read-only sub-MDO: " + this._getKey() + " (sub-MDO: " + ((DevelopmentObjectProxy)((Object)lProxy._getMDO()))._getKey() + ")");
                throw new ObjectNotModifiableException(this, "Attempt to delete object with read-only sub-MDO: " + this._getKey() + " (sub-MDO: " + ((DevelopmentObjectProxy)((Object)lProxy._getMDO()))._getKey() + ")");
            }
            if (((TextPoolProxy)lProxy._getMDO().getTextPool()).getReadOnlyLanguages().isEmpty()) continue;
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForDelete()", "attempt to delete sub-object with read-only language text files: " + lProxy._getKey());
            throw new ObjectNotModifiableException(this, "Attempt to delete object with read-only language text files: " + lProxy._getKey());
        }
        if (this.mDataState == DataState.DELETED || this.mDataState == DataState.CANCELLED) {
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForDelete()", "attempt to delete " + this.mDataState + " object: " + this._getKey());
            throw new DataStateDeletedException(this, "Attempt to delete " + this.mDataState + " object: " + this._getKey());
        }
        if (this.mDataState == DataState.CORRUPT) {
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForDelete()", "attempt to delete " + this.mDataState + " object: " + this._getKey());
            throw new DataStateCorruptException(this, "Attempt to delete " + this.mDataState + " object: " + this._getKey());
        }
        if (this.mDataState == DataState.INVALID) {
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForDelete()", "attempt to access " + this.mDataState + " object: " + this._getKey());
            throw new DataStateInvalidException(this, "Attempt to access " + this.mDataState + " object: " + this._getKey());
        }
    }

    protected void _prepareForSave() throws ObjectNotModifiableException, DataStateDeletedException, DataStateCorruptException {
        String method = "_prepareForSave()";
        if (this.mDataState == DataState.HOLLOW) {
            this.loadState();
        }
        if (this.isReadOnly()) {
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForSave()", "attempt to save read-only object: " + this._getKey());
            throw new ObjectNotModifiableException(this, "object is read-only: " + this._getKey());
        }
        if (this.mDataState == DataState.DELETED || this.mDataState == DataState.CANCELLED) {
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForSave()", "attempt to save " + this.mDataState + " object: " + this._getKey());
            throw new DataStateDeletedException(this, "datastate " + this.mDataState + ": " + this._getKey());
        }
        if (this.mDataState == DataState.CORRUPT) {
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForSave()", "attempt to save " + this.mDataState + " object: " + this._getKey());
            throw new DataStateCorruptException(this, "datastate " + this.mDataState + ": " + this._getKey());
        }
        if (this.mDataState == DataState.INVALID) {
            MetamodelObjectImpl.sCategoryObjectAccess.errorT(sLocation, "_prepareForSave()", "attempt to access " + this.mDataState + " object: " + this._getKey());
            throw new DataStateInvalidException(this, "Attempt to access " + this.mDataState + " object: " + this._getKey());
        }
    }

    protected void _checkForeignObject(DevelopmentObjectProxy object, String[][] allowedClasses) {
        String method = "_checkForeignObject()";
        Metamodel lMyMetamodel = this._mMetamodel;
        Metamodel lForeignMetamodel = object.getMetamodel();
        if (lMyMetamodel != lForeignMetamodel) {
            String lMessage = "foreign object " + object._getKey() + " belongs to different address space: " + lForeignMetamodel.getName();
            MetamodelObjectImpl.sCategoryIntegrity.errorT(sLocation, "_checkForeignObject()", lMessage);
            throw new IllegalObjectException(lMessage);
        }
        Class<?> lClass = object.getClass();
        while (lClass != (class$com$sap$ide$metamodel$core$DevelopmentObjectProxy == null ? DevelopmentObjectProxy.class$("com.sap.ide.metamodel.core.DevelopmentObjectProxy") : class$com$sap$ide$metamodel$core$DevelopmentObjectProxy)) {
            Class<?>[] lInterfaces = lClass.getInterfaces();
            int i = 0;
            while (i < lInterfaces.length) {
                int j = 0;
                while (j < allowedClasses.length) {
                    if (object._getForeignReference().getModelName().equals(allowedClasses[j][0]) && lInterfaces[i].getName().endsWith("." + allowedClasses[j][1])) {
                        return;
                    }
                    ++j;
                }
                ++i;
            }
            lClass = lClass.getSuperclass();
        }
        MetamodelObjectImpl.sCategoryIntegrity.errorT(sLocation, "_checkForeignObject()", "foreign object " + object._getKey() + " has wrong type");
        throw new IllegalObjectException(allowedClasses);
    }

    protected DevelopmentObjectProxy _retrieveForeignObject(ForeignReference reference) {
        String method = "_retrieveForeignObject()";
        DevelopmentObjectProxy lResult = null;
        RootImpl lForeignRoot = (RootImpl)this._mMetamodel.getRoot(reference.getModelName());
        if (lForeignRoot != null) {
            lResult = (DevelopmentObjectProxy)lForeignRoot.getObjectFromKey(reference);
            if (lResult == null) {
                MetamodelObjectImpl.sCategoryIntegrity.warningT(sLocation, "_retrieveForeignObject()", "could not resolve foreign reference: " + reference);
            }
        } else {
            MetamodelObjectImpl.sCategoryIntegrity.warningT(sLocation, "_retrieveForeignObject()", "could not access foreign metamodel \"" + reference.getModelName() + "\" (root not instantiated)");
        }
        return lResult;
    }

    public CoreMainDevelopmentObject _getMDO() {
        if (this.mMDO != null) {
            return this.mMDO;
        }
        if (this instanceof CoreMainDevelopmentObject) {
            this.mMDO = (CoreMainDevelopmentObject)((Object)this);
            return this.mMDO;
        }
        DevelopmentObjectProxy lParent = this._getParent();
        while (!(lParent instanceof CoreMainDevelopmentObject)) {
            lParent = lParent._getParent();
        }
        this.mMDO = (CoreMainDevelopmentObject)((Object)lParent);
        return this.mMDO;
    }

    public boolean isMDO() {
        return this instanceof CoreMainDevelopmentObject;
    }

    public DevelopmentObjectState _getState() {
        return this._mState;
    }

    private void loadState() {
        try {
            this._getMDO()._load();
        }
        catch (LoadException ex) {
            ex.printStackTrace();
            this.mDataState = DataState.CORRUPT;
        }
    }

    public Reference _getReference() {
        CoreMainDevelopmentObject lMDO = this._getMDO();
        Reference lReference = new Reference(lMDO.getPackage(), lMDO.getName(), lMDO._getType(), MetamodelObjectImpl.sObjectPathResolver.getPathFromObject(this));
        return lReference;
    }

    public ForeignReference _getForeignReference() {
        CoreMainDevelopmentObject lMDO = this._getMDO();
        return new ForeignReference(this._mRoot.getName(), lMDO.getPackage(), lMDO.getName(), lMDO._getType(), MetamodelObjectImpl.sObjectPathResolver.getPathFromObject(this));
    }

    public void attachObserver(DevelopmentObjectObserver observer) {
        this._mNotificationService.registerObserver(this, observer, 65535);
    }

    public void attachObserver(DevelopmentObjectObserver observer, int eventMask) {
        this._mNotificationService.registerObserver(this, observer, eventMask);
    }

    public void detachObserver(DevelopmentObjectObserver observer) {
        this._mNotificationService.unregisterObserver(this, observer);
    }

    public void detachAllObservers() {
        this._mNotificationService.unregisterAllObservers(this);
    }

    public void fireUserEvent(MetamodelUserEvent event) {
        if (event != null && this.getRoot().isEventingEnabled()) {
            event.setModifiedObject(this);
            this._mNotificationService.notifyObservers(event);
        }
    }

    public void _notifyPropertyChanged(String propertyName, String oldValue, String newValue) {
        this._mNotificationService.notifyObservers(new PropertyChangedEvent(this, propertyName, oldValue, newValue));
    }

    public void _notifyObjectCreated() {
        this._mNotificationService.notifyObservers(new ObjectCreatedEvent(this));
    }

    public void _notifyObjectDeleted() {
        this._mNotificationService.notifyObservers(new ObjectDeletedEvent(this));
    }

    public void _notifyObjectRefactored(RefactoredObjectImpl refactoredObject) {
        this._mNotificationService.notifyObservers(new ObjectRefactoredEvent(this, refactoredObject));
    }

    public void _notifySubObjectCreated(String role, DevelopmentObjectProxy object) {
        this._mNotificationService.notifyObservers(new SubObjectCreatedEvent(role, this, object));
    }

    public void _notifyMDOReloaded() {
        this._mNotificationService.notifyObservers(new MDOReloadedEvent(this));
    }

    public void _notifyMDODiscarded() {
        this._mNotificationService.notifyObservers(new MDODiscardedEvent(this));
    }

    public void _notifySubObjectDeleted(String role, DevelopmentObjectProxy object) {
        this._mNotificationService.notifyObservers(new SubObjectDeletedEvent(role, this, object));
    }

    public void _notifySubObjectMoved(String role, DevelopmentObjectProxy object, int fromPosition, int toPosition) {
        this._mNotificationService.notifyObservers(new SubObjectMovedEvent(role, this, object, fromPosition, toPosition));
    }

    public void _notifyReferencedObjectChanged(String role, DevelopmentObjectKey oldKey, DevelopmentObjectProxy object) {
        this._mNotificationService.notifyObservers(new ReferencedObjectChangedEvent(role, this, oldKey, object));
    }

    public void _notifyReferencedObjectAdded(String role, DevelopmentObjectProxy object) {
        this._mNotificationService.notifyObservers(new ReferencedObjectAddedEvent(role, this, object));
    }

    public void _notifyReferencedObjectRemoved(String role, DevelopmentObjectProxy object) {
        this._mNotificationService.notifyObservers(new ReferencedObjectRemovedEvent(role, this, object));
    }

    public void _notifyReferencedObjectMoved(String role, DevelopmentObjectProxy object, int fromPosition, int toPosition) {
        this._mNotificationService.notifyObservers(new ReferencedObjectMovedEvent(role, this, object, fromPosition, toPosition));
    }

    public void _notifyReferencedObjectRefactored() {
        this._mNotificationService.notifyObservers(new ReferencedObjectRefactoredEvent(this));
    }

    public void _notifyAllReferencedObjectsRemoved(String role) {
        this._mNotificationService.notifyObservers(new AllReferencedObjectsRemovedEvent(role, this));
    }

    public String toString() {
        StringBuffer lText = new StringBuffer();
        MetamodelIterator it = this.iterator(false, true, true);
        while (it.hasNext()) {
            lText.append(((DevelopmentObjectProxy)it.next())._toString());
        }
        return lText.toString();
    }

    public void validate() throws ValidationException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetamodelIterator it = this.iterator(true, true, true);
            while (it.hasNext()) {
                Vector lErrors = ((DevelopmentObjectProxy)it.next())._validate();
                if (lErrors.size() <= 0) continue;
                throw (ValidationException)lErrors.get(0);
            }
        }
    }

    public ValidationException[] validateAll() {
        Vector lResult = new Vector();
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetamodelIterator it = this.iterator(true, true, true);
            while (it.hasNext()) {
                lResult.addAll(((DevelopmentObjectProxy)it.next())._validate());
            }
        }
        return lResult.toArray(new ValidationException[0]);
    }

    public boolean canDelete() {
        if (this.isReadOnly()) {
            return false;
        }
        if (this instanceof CoreMainDevelopmentObject && this.getParent() != null && this._mParent.isReadOnly()) {
            return false;
        }
        MetamodelIterator it = this.iterator(true, true, false);
        while (it.hasNext()) {
            DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)it.next();
            if (!(lProxy instanceof CoreMainDevelopmentObject) || !lProxy.isReadOnly() && ((TextPoolProxy)lProxy._getMDO().getTextPool()).getReadOnlyLanguages().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public MDOAccessProblem[] checkForDelete() {
        String lPath;
        String method = "checkForDelete()";
        ArrayList<MDOAccessProblemImpl> lMDOAccessProblems = new ArrayList<MDOAccessProblemImpl>();
        if (!(this instanceof CoreMainDevelopmentObject) && this.isReadOnly()) {
            lPath = this._getMDO().getAbsolutePath();
            lMDOAccessProblems.add(new MDOAccessProblemImpl(this._getMDO(), lPath, 3));
            MetamodelObjectImpl.sCategoryObjectAccess.infoT(sLocation, "checkForDelete()", "cannot delete read-only MDO: \"" + lPath + "\"");
        }
        if (this instanceof CoreMainDevelopmentObject && this._mParent != null && this._mParent.isReadOnly()) {
            lPath = this._mParent._getMDO().getAbsolutePath();
            lMDOAccessProblems.add(new MDOAccessProblemImpl(this._mParent._getMDO(), lPath, 4));
            MetamodelObjectImpl.sCategoryObjectAccess.infoT(sLocation, "checkForDelete()", "cannot modify read-only MDO: \"" + lPath + "\"");
        }
        MetamodelIterator it = this.iterator(true, true, false);
        while (it.hasNext()) {
            DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)it.next();
            if (!(lProxy instanceof CoreMainDevelopmentObject)) continue;
            CoreMainDevelopmentObject lMDO = (CoreMainDevelopmentObject)((Object)lProxy);
            if (lProxy.isReadOnly()) {
                String lPath2 = lMDO.getAbsolutePath();
                lMDOAccessProblems.add(new MDOAccessProblemImpl(lMDO, lPath2, 3));
                MetamodelObjectImpl.sCategoryObjectAccess.infoT(sLocation, "checkForDelete()", "cannot delete read-only MDO: \"" + lPath2 + "\"");
                continue;
            }
            ArrayList lReadOnlyLanguages = ((TextPoolProxy)lMDO.getTextPool()).getReadOnlyLanguages();
            Iterator it2 = ((AbstractList)lReadOnlyLanguages).iterator();
            while (it2.hasNext()) {
                String lLanguage = (String)it2.next();
                String lLanguagePath = lMDO.getTextPool().getAbsolutePath(lLanguage);
                lMDOAccessProblems.add(new MDOAccessProblemImpl(lMDO, lLanguage, lLanguagePath, 7));
                MetamodelObjectImpl.sCategoryObjectAccess.infoT(sLocation, "checkForDelete()", "cannot delete read-only language file: \"" + lLanguagePath + "\"");
            }
        }
        return lMDOAccessProblems.toArray(new MDOAccessProblem[0]);
    }

    private void _doDelete() throws DeleteException {
        String method = "_doDelete()";
        Vector<DevelopmentObjectProxy> lObjects = new Vector<DevelopmentObjectProxy>();
        try {
            MetamodelIterator it = this.iterator(true, true, false);
            while (it.hasNext()) {
                DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)it.next();
                ForeignReference lKey = (ForeignReference)lProxy._getKey();
                lObjects.add(lProxy);
                lProxy._delete();
                if (this.getRoot().isEventingEnabled()) {
                    lProxy._notifyObjectDeleted();
                }
                if (!this._mObjectCacheManager.getKeyCachingEnabled() || lProxy.isMDO()) continue;
                this._mObjectCacheManager.unregisterKeyedNonMDO(lKey);
            }
            Iterator it2 = ((AbstractList)lObjects).iterator();
            while (it2.hasNext()) {
                DevelopmentObjectProxy lProxy = (DevelopmentObjectProxy)it2.next();
                if (lProxy instanceof CoreMainDevelopmentObject) {
                    ((TextPoolProxy)((CoreMainDevelopmentObject)((Object)lProxy)).getTextPool()).clear();
                }
                lProxy._setDataState(DataState.DELETED);
            }
        }
        catch (DataStateException ex) {
            MetamodelObjectImpl.sCategoryIntegrity.fatalT(sLocation, "_doDelete()", "error deleting " + this._getKey() + " => object corrupt");
            ((DevelopmentObjectProxy)ex.getErrorObject())._setDataState(DataState.CORRUPT);
            throw new DeleteException(ex);
        }
    }

    public void delete() throws DeleteException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            this._prepareForDelete();
            this._doDelete();
        }
    }

    public void _deleteInternal() {
        boolean lEventingEnabled = this.getRoot().isEventingEnabled();
        this.getRoot().disableEventing();
        try {
            this._doDelete();
        }
        catch (DeleteException deleteException) {
            // empty catch block
        }
        if (lEventingEnabled) {
            this.getRoot().enableEventing();
        }
    }

    public void _invalidate() {
        MetamodelIterator it = this.iterator(false, true, true);
        while (it.hasNext()) {
            ((DevelopmentObjectProxy)it.next()).mDataState = DataState.INVALID;
        }
    }

    public void _dropState() {
        String method = "_dropState()";
        MetamodelObjectImpl.sCategoryMisc.infoT(sLocation, "_dropState()", "dropping state of " + this._getKey());
        MetamodelIterator it = this.iterator(false, false, false);
        while (it.hasNext()) {
            DevelopmentObjectProxy lObject = (DevelopmentObjectProxy)it.next();
            lObject._dropReferences();
            lObject._mState = null;
            lObject._mParent = null;
            lObject.mDataState = DataState.INVALID;
        }
        this.mDataState = DataState.HOLLOW;
    }

    public boolean originatesInArchive() {
        return this._getMDO().getAbsolutePath().startsWith("jar:");
    }

    public String getArchivePath() {
        String lMDOPath = this._getMDO().getAbsolutePath();
        if (lMDOPath.startsWith("jar:")) {
            return lMDOPath.substring(12, lMDOPath.indexOf(33));
        }
        return "";
    }

    public DevelopmentObjectKey _getKey() {
        if (this.mKey == null) {
            this.mKey = this._getForeignReference();
        }
        return this.mKey;
    }

    public DevelopmentObjectKey getKey() {
        this._getKey();
        if (!(this instanceof CoreMainDevelopmentObject) && this.mKey != null && this._mObjectCacheManager.getKeyCachingEnabled()) {
            this._mObjectCacheManager.registerKeyedNonMDO(this.mKey, this);
        }
        return this.mKey;
    }

    public void _clearKey() {
        this.mKey = null;
    }

    public void _refactor(RefactoringTaskImpl task, RefactoringService refactoringService) throws RefactoringException {
        String method = "_refactor()";
        this._prepareForModify();
        String lPreviousName = null;
        String lPreviousPackage = null;
        String lPreviousAbsolutePath = null;
        DevelopmentObjectProxy lPreviousParent = null;
        ForeignReference lPreviousKey = (ForeignReference)this._getKey();
        String lAggregatedViaRole = null;
        if (task != null) {
            if (this.mRefactoringHistory == null) {
                this.initializeRefactoringHistory();
            }
            String lOldAggregationKey = this._getAggregationKey();
            lPreviousName = this._mName;
            if (this.isMDO()) {
                lPreviousPackage = ((CoreMainDevelopmentObject)((Object)this)).getPackage();
                lPreviousAbsolutePath = ((CoreMainDevelopmentObject)((Object)this)).getAbsolutePath();
            }
            lPreviousParent = this._mParent;
            if (task.hasParentChanged()) {
                lAggregatedViaRole = this._mParent._getAggregatedViaRole(this);
                this._mParent._removeChildObject(this, lAggregatedViaRole);
            }
            this._mName = task.getNewName();
            this._mState.setName(this._mName);
            MetamodelIterator it = this.iterator(true, false, true);
            while (it.hasNext()) {
                ((DevelopmentObjectProxy)it.next()).mKey = null;
            }
            if (this.isMDO()) {
                String lPackage = ((MDORefactoringTaskImpl)task).getNewPackage();
                ((CoreMainDevelopmentObject)((Object)this)).setPackage(lPackage);
                this._mAggregationKey = (lPackage + "." + this._mName).toLowerCase();
                MDOEnum lType = (MDOEnum)this.getDevelopmentObjectEnum();
                SourcePathIdentifier lSourcePathIdentifier = ((MDORefactoringTaskImpl)task).getNewSourcePathIdentifier();
                String lAbsolutePath = MetamodelObjectImpl.sFileSystemService.computeAbsolutePath(((RootImpl)this.getRoot())._getMDOLocator(), lPackage, this._mName, lType, lSourcePathIdentifier);
                if (lAbsolutePath == null) {
                    String lMessage = "could not get a valid path for " + lType + " \"" + lPackage + "." + this._mName + "\" (path too long?)";
                    MetamodelObjectImpl.sCategoryMisc.errorT(sLocation, "_refactor()", lMessage);
                    throw new RefactoringException(this.exceptionMessage(lMessage));
                }
                ((CoreMainDevelopmentObject)((Object)this)).setAbsolutePath(lAbsolutePath);
                ((CoreMainDevelopmentObject)((Object)this)).setSourcePathIdentifier(lSourcePathIdentifier);
            } else {
                this._mAggregationKey = this._mName.toLowerCase();
                this._mObjectCacheManager.clearKeyCache();
            }
            if (task.hasParentChanged()) {
                DevelopmentObjectProxy lNewParent = (DevelopmentObjectProxy)task.getNewParent();
                lNewParent._addChildObject(this, lAggregatedViaRole);
                this._mParent = lNewParent;
                if (this.isMDO()) {
                    ((MainDevelopmentObjectState)((Object)this._mState)).setParent(this._mParent._getReference());
                }
            } else if (this._mParent == null) {
                ((RootImpl)this.getRoot())._childObjectRefactored(lOldAggregationKey, this);
            } else {
                this._mParent._childObjectRefactored(lOldAggregationKey, this);
            }
        }
        if (this.getRoot().isEventingEnabled()) {
            Iterator it = refactoringService.keySet().iterator();
            while (it.hasNext()) {
                if (!this._mState._hasReferencesToRefactor((Reference)it.next())) continue;
                this._notifyReferencedObjectRefactored();
                break;
            }
        }
        this._mState.refactorReferences(refactoringService);
        this._setDataState(DataState.MODIFIED);
        if (task != null) {
            RefactoringHistoryEntryImpl lHistoryEntry = null;
            lHistoryEntry = this.isMDO() ? new MDORefactoringHistoryEntryImpl((CoreMainDevelopmentObject)((Object)this), this._mName, this._getKey(), ((CoreMainDevelopmentObject)((Object)this)).getPackage(), ((CoreMainDevelopmentObject)((Object)this)).getAbsolutePath(), this._mParent) : new RefactoringHistoryEntryImpl(this, this._mName, this._getKey(), this._mParent);
            this.mRefactoringHistory.add(lHistoryEntry);
            this._mObjectCacheManager.objectRefactored((RefactoringHistoryEntryImpl)this.mRefactoringHistory.get(this.mRefactoringHistory.size() - 2));
            if (this.getRoot().isEventingEnabled()) {
                RefactoringHistoryEntryImpl lOriginal;
                RefactoredObjectImpl lRefactoredObject = null;
                if (this.isMDO()) {
                    lOriginal = (MDORefactoringHistoryEntryImpl)this.mRefactoringHistory.get(0);
                    lRefactoredObject = new RefactoredMDOImpl((CoreMainDevelopmentObject)((Object)this), lOriginal.getName(), ((MDORefactoringHistoryEntryImpl)lOriginal).getPackage(), ((MDORefactoringHistoryEntryImpl)lOriginal).getAbsolutePath(), (DevelopmentObjectProxy)lOriginal.getParent(), lOriginal.getKey());
                } else {
                    lOriginal = (RefactoringHistoryEntryImpl)this.mRefactoringHistory.get(0);
                    lRefactoredObject = new RefactoredObjectImpl(this, lOriginal.getName(), (DevelopmentObjectProxy)lOriginal.getParent(), lOriginal.getKey());
                }
                this._notifyObjectRefactored(lRefactoredObject);
            }
        }
    }

    public void initializeRefactoringHistory() {
        this.mRefactoringHistory = new ArrayList();
        RefactoringHistoryEntryImpl lHistoryEntry = null;
        lHistoryEntry = this instanceof CoreMainDevelopmentObject ? new MDORefactoringHistoryEntryImpl((CoreMainDevelopmentObject)((Object)this), this._mName, this._getKey(), ((CoreMainDevelopmentObject)((Object)this)).getPackage(), ((CoreMainDevelopmentObject)((Object)this)).getAbsolutePath(), this._mParent) : new RefactoringHistoryEntryImpl(this, this._mName, this._getKey(), this._mParent);
        lHistoryEntry.setIsOriginal();
        this.mRefactoringHistory.add(lHistoryEntry);
    }

    public RefactoringHistoryEntry[] getRefactoringHistory() {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            if (this.mRefactoringHistory == null) {
                this.initializeRefactoringHistory();
            }
            RefactoringHistoryEntry[] refactoringHistoryEntryArray = this.mRefactoringHistory.toArray(new RefactoringHistoryEntry[0]);
            return refactoringHistoryEntryArray;
        }
    }

    protected String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }

    public Object getProperty(Property property) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (property == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllProperties().contains(property)) {
                throw new ReflectionException("illegal argument: given property does not exist in: " + lMyMetaClass.getName());
            }
            try {
                Class<?> lInterface = Class.forName(property.getParent().getName(), true, this.getClass().getClassLoader());
                if (property.getIsNullable()) {
                    Method lMethod = lInterface.getMethod("has" + this._capitalizeFirstChar(property.getName()), null);
                    if (!((Boolean)lMethod.invoke((Object)this, null)).booleanValue()) {
                        // empty if block
                    }
                    Object var6_8 = null;
                    return var6_8;
                }
                Method lMethod = lInterface.getMethod("get" + this._capitalizeFirstChar(property.getName()), null);
                Object object = lMethod.invoke((Object)this, null);
                return object;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public void setProperty(Property property, Object value) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (property == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (value == null && !property.getIsNullable() && !property.getJavaType().equals("String")) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllProperties().contains(property)) {
                throw new ReflectionException("illegal argument: given property does not exist in: " + lMyMetaClass.getName());
            }
            Class lPropertyType = ((PropertyImpl)property).getJavaClass();
            if (value != null && lPropertyType != value.getClass()) {
                throw new ReflectionException("illegal argument: wrong type");
            }
            try {
                Class<?> lInterface = Class.forName(property.getParent().getName(), true, this.getClass().getClassLoader());
                if (value == null && property.getIsNullable()) {
                    Method lMethod = lInterface.getMethod("unset" + this._capitalizeFirstChar(property.getName()), null);
                    lMethod.invoke((Object)this, null);
                } else {
                    Method lMethod = null;
                    lMethod = ((PropertyImpl)property).isTypePrimitive() ? lInterface.getMethod("set" + this._capitalizeFirstChar(property.getName()), ((PropertyImpl)property).getJavaClassForPrimitiveType()) : lInterface.getMethod("set" + this._capitalizeFirstChar(property.getName()), lPropertyType);
                    lMethod.invoke((Object)this, value);
                }
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public DevelopmentObject getAggregatedObject(Aggregation aggregation) throws ReflectionException {
        return this.getObject(aggregation);
    }

    public DevelopmentObject getAggregatedObject(Aggregation aggregation, String name) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (aggregation == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAggregations().contains(aggregation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            if (aggregation.getCardinality() == CardinalityEnum.SINGLE) {
                throw new ReflectionException("illegal argument: method not applicable for to-1-relations");
            }
            try {
                Class<?> lInterface = Class.forName(aggregation.getParent().getName(), true, this.getClass().getClassLoader());
                Method lMethod = lInterface.getMethod("get" + aggregation.getSingularName(), class$java$lang$String == null ? (class$java$lang$String = DevelopmentObjectProxy.class$("java.lang.String")) : class$java$lang$String);
                DevelopmentObject developmentObject = (DevelopmentObject)lMethod.invoke((Object)this, name);
                return developmentObject;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public DevelopmentObject createAggregatedObject(Aggregation aggregation, MetaClass type) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (aggregation == null || type == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAggregations().contains(aggregation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            if (aggregation.getCardinality() == CardinalityEnum.MULTIPLE) {
                throw new ReflectionException("illegal argument: method not applicable for to-n-relations");
            }
            MetaClassImpl lTargetClass = (MetaClassImpl)aggregation.getTargetClass();
            if (lTargetClass.getIsDerivedMDO()) {
                throw new ReflectionException("illegal argument: method not applicable for MDO-aggregations");
            }
            if (type.getIsAbstract() || type != lTargetClass && !lTargetClass._getAllSubClasses().contains(type)) {
                throw new ReflectionException("illegal argument: wrong type");
            }
            try {
                Class<?> lInterface = Class.forName(aggregation.getParent().getName(), true, this.getClass().getClassLoader());
                String lMethodName = "create" + aggregation.getName();
                if (!lTargetClass._getSubClasses().isEmpty()) {
                    lMethodName = lMethodName + "As" + type.getName().substring(type.getName().lastIndexOf(46) + 1);
                }
                Method lMethod = lInterface.getMethod(lMethodName, null);
                DevelopmentObject developmentObject = (DevelopmentObject)lMethod.invoke((Object)this, null);
                return developmentObject;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public DevelopmentObject createAggregatedObject(Aggregation aggregation, MetaClass type, String name) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (aggregation == null || type == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAggregations().contains(aggregation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            MetaClassImpl lTargetClass = (MetaClassImpl)aggregation.getTargetClass();
            if (type.getIsAbstract() || type != lTargetClass && !lTargetClass._getAllSubClasses().contains(type)) {
                throw new ReflectionException("illegal argument: wrong type");
            }
            try {
                Class<?> lInterface = Class.forName(aggregation.getParent().getName(), true, this.getClass().getClassLoader());
                String lMethodName = "create";
                lMethodName = aggregation.getCardinality() == CardinalityEnum.MULTIPLE ? lMethodName + aggregation.getSingularName() : lMethodName + aggregation.getName();
                if (!lTargetClass._getSubClasses().isEmpty()) {
                    lMethodName = lMethodName + "As" + type.getName().substring(type.getName().lastIndexOf(46) + 1);
                }
                Method lMethod = lInterface.getMethod(lMethodName, class$java$lang$String == null ? (class$java$lang$String = DevelopmentObjectProxy.class$("java.lang.String")) : class$java$lang$String);
                DevelopmentObject developmentObject = (DevelopmentObject)lMethod.invoke((Object)this, name);
                return developmentObject;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public DevelopmentObject createAggregatedObject(Aggregation aggregation, MetaClass type, String name, SourcePathIdentifier sourcePathIdentifier) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (aggregation == null || type == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAggregations().contains(aggregation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            MetaClassImpl lTargetClass = (MetaClassImpl)aggregation.getTargetClass();
            if (!lTargetClass.getIsDerivedMDO()) {
                throw new ReflectionException("illegal argument: method not applicable for non-MDO-aggregations");
            }
            if (type.getIsAbstract() || type != lTargetClass && !lTargetClass._getAllSubClasses().contains(type)) {
                throw new ReflectionException("illegal argument: wrong type");
            }
            try {
                Class<?> lInterface = Class.forName(aggregation.getParent().getName(), true, this.getClass().getClassLoader());
                String lMethodName = "create";
                lMethodName = aggregation.getCardinality() == CardinalityEnum.MULTIPLE ? lMethodName + aggregation.getSingularName() : lMethodName + aggregation.getName();
                if (!lTargetClass._getSubClasses().isEmpty()) {
                    lMethodName = lMethodName + "As" + type.getName().substring(type.getName().lastIndexOf(46) + 1);
                }
                Method lMethod = lInterface.getMethod(lMethodName, class$java$lang$String == null ? (class$java$lang$String = DevelopmentObjectProxy.class$("java.lang.String")) : class$java$lang$String, class$com$sap$ide$metamodel$general$SourcePathIdentifier == null ? (class$com$sap$ide$metamodel$general$SourcePathIdentifier = DevelopmentObjectProxy.class$("com.sap.ide.metamodel.general.SourcePathIdentifier")) : class$com$sap$ide$metamodel$general$SourcePathIdentifier);
                DevelopmentObject developmentObject = (DevelopmentObject)lMethod.invoke((Object)this, name, sourcePathIdentifier);
                return developmentObject;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public DevelopmentObject createAggregatedObject(Aggregation aggregation, MetaClass type, String name, int position) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (aggregation == null || type == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAggregations().contains(aggregation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            MetaClassImpl lTargetClass = (MetaClassImpl)aggregation.getTargetClass();
            if (type.getIsAbstract() || type != lTargetClass && !lTargetClass._getAllSubClasses().contains(type)) {
                throw new ReflectionException("illegal argument: wrong type");
            }
            if (aggregation.getCardinality() == CardinalityEnum.SINGLE) {
                throw new ReflectionException("illegal argument: method not applicable for to-1-relations");
            }
            if (!aggregation.getIsOrdered()) {
                throw new ReflectionException("illegal argument: relation must be odered");
            }
            try {
                Class<?> lInterface = Class.forName(aggregation.getParent().getName(), true, this.getClass().getClassLoader());
                String lMethodName = "create" + aggregation.getSingularName();
                if (!lTargetClass._getSubClasses().isEmpty()) {
                    lMethodName = lMethodName + "As" + type.getName().substring(type.getName().lastIndexOf(46) + 1);
                }
                Method lMethod = lInterface.getMethod(lMethodName, class$java$lang$String == null ? (class$java$lang$String = DevelopmentObjectProxy.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                DevelopmentObject developmentObject = (DevelopmentObject)lMethod.invoke((Object)this, name, new Integer(position));
                return developmentObject;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public DevelopmentObject getAssociatedObject(Association association) throws ReflectionException {
        return this.getObject(association);
    }

    public DevelopmentObject[] getAssociatedObjects(Association association) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            DevelopmentObject[] developmentObjectArray = this._getObjects(association);
            return developmentObjectArray;
        }
    }

    public void addToAssociation(Association association, DevelopmentObject object) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (association == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAssociations().contains(association)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            Class<?> lTargetClass = null;
            if (!association.getIsForeign()) {
                try {
                    lTargetClass = Class.forName(association.getTargetClass().getName(), true, this.getClass().getClassLoader());
                }
                catch (Exception ex) {
                    throw new ReflectionException(ex);
                }
                if (!lTargetClass.isAssignableFrom(object.getClass())) {
                    throw new ReflectionException("illegal argument: wrong type");
                }
            }
            try {
                Class<?> lInterface = Class.forName(association.getParent().getName(), true, this.getClass().getClassLoader());
                String lMethodName = association.getCardinality() == CardinalityEnum.SINGLE ? "set" + association.getName() : "add" + association.getSingularName();
                Method lMethod = null;
                lMethod = association.getIsForeign() ? lInterface.getMethod(lMethodName, class$com$sap$ide$metamodel$general$DevelopmentObject == null ? (class$com$sap$ide$metamodel$general$DevelopmentObject = DevelopmentObjectProxy.class$("com.sap.ide.metamodel.general.DevelopmentObject")) : class$com$sap$ide$metamodel$general$DevelopmentObject) : lInterface.getMethod(lMethodName, lTargetClass);
                lMethod.invoke((Object)this, object);
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public void addToAssociation(Association association, DevelopmentObject object, int position) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (association == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAssociations().contains(association)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            if (association.getCardinality() == CardinalityEnum.SINGLE) {
                throw new ReflectionException("illegal argument: method not applicable for to-1-relations");
            }
            if (!association.getIsOrdered()) {
                throw new ReflectionException("illegal argument: relation must be odered");
            }
            Class<?> lTargetClass = null;
            if (!association.getIsForeign()) {
                try {
                    lTargetClass = Class.forName(association.getTargetClass().getName(), true, this.getClass().getClassLoader());
                }
                catch (Exception ex) {
                    throw new ReflectionException(ex);
                }
                if (!this.getAllInterfaces(object.getClass()).contains(lTargetClass)) {
                    throw new ReflectionException("illegal argument: wrong type");
                }
            }
            try {
                Class<?> lInterface = Class.forName(association.getParent().getName(), true, this.getClass().getClassLoader());
                Method lMethod = null;
                lMethod = association.getIsForeign() ? lInterface.getMethod("add" + association.getSingularName(), class$com$sap$ide$metamodel$general$DevelopmentObject == null ? (class$com$sap$ide$metamodel$general$DevelopmentObject = DevelopmentObjectProxy.class$("com.sap.ide.metamodel.general.DevelopmentObject")) : class$com$sap$ide$metamodel$general$DevelopmentObject, Integer.TYPE) : lInterface.getMethod("add" + association.getSingularName(), lTargetClass, Integer.TYPE);
                lMethod.invoke((Object)this, object, new Integer(position));
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public void removeFromAssociation(Association association, DevelopmentObject object) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (association == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAssociations().contains(association)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            Class<?> lTargetClass = null;
            if (!association.getIsForeign()) {
                try {
                    lTargetClass = Class.forName(association.getTargetClass().getName(), true, this.getClass().getClassLoader());
                }
                catch (Exception ex) {
                    throw new ReflectionException(ex);
                }
                if (!lTargetClass.isAssignableFrom(object.getClass())) {
                    throw new ReflectionException("illegal argument: wrong type");
                }
            }
            try {
                Class<?> lInterface = Class.forName(association.getParent().getName(), true, this.getClass().getClassLoader());
                if (association.getCardinality() == CardinalityEnum.SINGLE) {
                    String lMethodName = "get" + association.getName();
                    Method lMethod = lInterface.getMethod(lMethodName, null);
                    if (lMethod.invoke((Object)this, null) != null) {
                        lMethodName = "set" + association.getName();
                        lMethod = association.getIsForeign() ? lInterface.getMethod(lMethodName, class$com$sap$ide$metamodel$general$DevelopmentObject == null ? (class$com$sap$ide$metamodel$general$DevelopmentObject = DevelopmentObjectProxy.class$("com.sap.ide.metamodel.general.DevelopmentObject")) : class$com$sap$ide$metamodel$general$DevelopmentObject) : lInterface.getMethod(lMethodName, lTargetClass);
                        lMethod.invoke((Object)this, new Object[]{null});
                    }
                } else {
                    String lMethodName = "remove" + association.getSingularName();
                    Method lMethod = null;
                    lMethod = association.getIsForeign() ? lInterface.getMethod(lMethodName, class$com$sap$ide$metamodel$general$DevelopmentObject == null ? (class$com$sap$ide$metamodel$general$DevelopmentObject = DevelopmentObjectProxy.class$("com.sap.ide.metamodel.general.DevelopmentObject")) : class$com$sap$ide$metamodel$general$DevelopmentObject) : lInterface.getMethod(lMethodName, lTargetClass);
                    lMethod.invoke((Object)this, object);
                }
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public void removeFromAssociation(Association association, int position) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (association == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAssociations().contains(association)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            if (association.getCardinality() == CardinalityEnum.SINGLE) {
                throw new ReflectionException("illegal argument: method not applicable for to-1-relations");
            }
            if (!association.getIsOrdered()) {
                throw new ReflectionException("illegal argument: relation must be odered");
            }
            try {
                Class<?> lInterface = Class.forName(association.getParent().getName(), true, this.getClass().getClassLoader());
                Method lMethod = lInterface.getMethod("remove" + association.getSingularName(), Integer.TYPE);
                lMethod.invoke((Object)this, new Integer(position));
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public void clearAssociation(Association association) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (association == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllAssociations().contains(association)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            try {
                Class<?> lInterface = Class.forName(association.getParent().getName(), true, this.getClass().getClassLoader());
                if (association.getCardinality() == CardinalityEnum.SINGLE) {
                    String lMethodName = "set" + association.getName();
                    Method lMethod = null;
                    lMethod = association.getIsForeign() ? lInterface.getMethod(lMethodName, class$com$sap$ide$metamodel$general$DevelopmentObject == null ? (class$com$sap$ide$metamodel$general$DevelopmentObject = DevelopmentObjectProxy.class$("com.sap.ide.metamodel.general.DevelopmentObject")) : class$com$sap$ide$metamodel$general$DevelopmentObject) : lInterface.getMethod(lMethodName, Class.forName(association.getTargetClass().getName(), true, this.getClass().getClassLoader()));
                    lMethod.invoke((Object)this, new Object[]{null});
                } else {
                    String lMethodName = "removeAll" + association.getName();
                    Method lMethod = lInterface.getMethod(lMethodName, null);
                    lMethod.invoke((Object)this, null);
                }
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public DevelopmentObject getObject(Relation relation) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (relation == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllRelations().contains(relation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            if (relation.getCardinality() == CardinalityEnum.MULTIPLE) {
                throw new ReflectionException("illegal argument: method not applicable for to-n-relations");
            }
            try {
                Class<?> lInterface = Class.forName(relation.getParent().getName(), true, this.getClass().getClassLoader());
                Method lMethod = lInterface.getMethod("get" + relation.getName(), null);
                DevelopmentObject developmentObject = (DevelopmentObject)lMethod.invoke((Object)this, null);
                return developmentObject;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public DevelopmentObject[] getObjects(Relation relation) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            DevelopmentObject[] developmentObjectArray = this._getObjects(relation);
            return developmentObjectArray;
        }
    }

    public DevelopmentObject getObject(Relation relation, int position) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (relation == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllRelations().contains(relation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            if (relation.getCardinality() == CardinalityEnum.SINGLE) {
                throw new ReflectionException("illegal argument: method not applicable for to-1-relations");
            }
            if (!relation.getIsOrdered()) {
                throw new ReflectionException("illegal argument: relation must be odered");
            }
            try {
                Class<?> lInterface = Class.forName(relation.getParent().getName(), true, this.getClass().getClassLoader());
                Method lMethod = lInterface.getMethod("get" + relation.getSingularName(), Integer.TYPE);
                DevelopmentObject developmentObject = (DevelopmentObject)lMethod.invoke((Object)this, new Integer(position));
                return developmentObject;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public DevelopmentObject moveObject(Relation relation, int fromPosition, int toPosition) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (relation == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllRelations().contains(relation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            if (relation.getCardinality() == CardinalityEnum.SINGLE) {
                throw new ReflectionException("illegal argument: method not applicable for to-1-relations");
            }
            if (!relation.getIsOrdered()) {
                throw new ReflectionException("illegal argument: relation must be odered");
            }
            try {
                Class<?> lInterface = Class.forName(relation.getParent().getName(), true, this.getClass().getClassLoader());
                Method lMethod = lInterface.getMethod("move" + relation.getSingularName(), Integer.TYPE, Integer.TYPE);
                DevelopmentObject developmentObject = (DevelopmentObject)lMethod.invoke((Object)this, new Integer(fromPosition), new Integer(toPosition));
                return developmentObject;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    private ArrayList getAllInterfaces(Class clazz) {
        ArrayList lResult = new ArrayList();
        Class lClass = clazz;
        while (lClass != null) {
            Class<?>[] lInterfaces = lClass.getInterfaces();
            int i = 0;
            while (i < lInterfaces.length) {
                lResult.add(lInterfaces[i]);
                ++i;
            }
            lClass = lClass.getSuperclass();
        }
        return lResult;
    }

    public int getObjectPosition(Relation relation, DevelopmentObject object) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (relation == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllRelations().contains(relation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            if (relation.getCardinality() == CardinalityEnum.SINGLE) {
                throw new ReflectionException("illegal argument: method not applicable for to-1-relations");
            }
            if (!relation.getIsOrdered()) {
                throw new ReflectionException("illegal argument: relation must be odered");
            }
            Class<?> lTargetClass = null;
            try {
                lTargetClass = Class.forName(relation.getTargetClass().getName(), true, this.getClass().getClassLoader());
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
            if (!this.getAllInterfaces(object.getClass()).contains(lTargetClass)) {
                throw new ReflectionException("illegal argument: wrong type");
            }
            try {
                Class<?> lInterface = Class.forName(relation.getParent().getName(), true, this.getClass().getClassLoader());
                Method lMethod = null;
                if (relation instanceof Association && ((Association)relation).getIsForeign()) {
                    lMethod = lInterface.getMethod("get" + relation.getSingularName() + "Position", class$com$sap$ide$metamodel$general$DevelopmentObject == null ? (class$com$sap$ide$metamodel$general$DevelopmentObject = DevelopmentObjectProxy.class$("com.sap.ide.metamodel.general.DevelopmentObject")) : class$com$sap$ide$metamodel$general$DevelopmentObject);
                } else if (relation.getDeclarationType() == DeclarationTypeEnum.IMPLEMENTATION) {
                    ArrayList lAllAggregations = ((MetaClassImpl)this.getMetaClass())._getAllAggregations();
                    Iterator it = ((AbstractList)lAllAggregations).iterator();
                    while (it.hasNext()) {
                        Aggregation lAggregation = (Aggregation)it.next();
                        if (lAggregation.getDeclarationType() != DeclarationTypeEnum.ABSTRACT || !lAggregation.getName().equals(relation.getName())) continue;
                        Class<?> lTargetSuperClass = null;
                        try {
                            lTargetSuperClass = Class.forName(lAggregation.getTargetClass().getName(), true, this.getClass().getClassLoader());
                        }
                        catch (Exception ex) {
                            throw new ReflectionException(ex);
                        }
                        try {
                            lMethod = lInterface.getMethod("get" + relation.getSingularName() + "Position", lTargetSuperClass);
                        }
                        catch (Exception ex) {
                            throw new ReflectionException(ex);
                        }
                    }
                } else {
                    try {
                        lMethod = lInterface.getMethod("get" + relation.getSingularName() + "Position", lTargetClass);
                    }
                    catch (Exception ex) {
                        throw new ReflectionException(ex);
                    }
                }
                int n = (Integer)lMethod.invoke((Object)this, object);
                return n;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public int getObjectCount(Relation relation) throws ReflectionException {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            MetaClassImpl lMyMetaClass = (MetaClassImpl)this.getMetaClass();
            if (relation == null) {
                throw new ReflectionException("illegal argument: null");
            }
            if (!lMyMetaClass._getAllRelations().contains(relation)) {
                throw new ReflectionException("illegal argument: given relation does not exist in: " + lMyMetaClass.getName());
            }
            if (relation.getCardinality() == CardinalityEnum.SINGLE) {
                throw new ReflectionException("illegal argument: method not applicable for to-1-relations");
            }
            if (!relation.getIsOrdered()) {
                throw new ReflectionException("illegal argument: relation must be odered");
            }
            try {
                Class<?> lInterface = Class.forName(relation.getParent().getName(), true, this.getClass().getClassLoader());
                Method lMethod = lInterface.getMethod("get" + relation.getSingularName() + "Count", null);
                int n = (Integer)lMethod.invoke((Object)this, null);
                return n;
            }
            catch (Exception ex) {
                throw new ReflectionException(ex);
            }
        }
    }

    public void reorderObjects(String relationName, String[] ordering) {
    }

    private String _capitalizeFirstChar(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public void addAnnotation(String key, String value) {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            this._prepareForModify();
            this._mState.addMetamodelAnnotation(new MetamodelAnnotationImpl(key, value));
            this._setDataState(DataState.MODIFIED);
        }
    }

    public MetamodelAnnotation getAnnotation(String key) {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            this._prepareForRead();
            MetamodelAnnotationImpl metamodelAnnotationImpl = this._mState.getMetamodelAnnotation(key);
            return metamodelAnnotationImpl;
        }
    }

    public MetamodelAnnotation[] getAnnotations() {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            this._prepareForRead();
            MetamodelAnnotation[] metamodelAnnotationArray = this._mState.getMetamodelAnnotations().toArray(new MetamodelAnnotation[0]);
            return metamodelAnnotationArray;
        }
    }

    public void removeAnnotation(String key) {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            this._prepareForModify();
            this._mState.removeMetamodelAnnotation(key);
            this._setDataState(DataState.MODIFIED);
        }
    }

    public Aggregation getContainingAggregation() {
        Metamodel metamodel = this._mMetamodel;
        synchronized (metamodel) {
            this._prepareForRead();
            String lRole = null;
            Aggregation[] lAggregations = null;
            if (this._mParent != null) {
                lRole = this._mParent._getAggregatedViaRole(this);
                lAggregations = this._mParent.getMetaClass().getAllAggregations();
            } else {
                lRole = this._mRoot._getAggregatedViaRole(this);
                lAggregations = this._mRoot.getMetaClass().getAllAggregations();
            }
            int lPos = lRole.indexOf(123);
            if (lPos != -1) {
                lRole = lRole.substring(0, lPos);
            }
            int j = 0;
            while (j < lAggregations.length) {
                if (lAggregations[j].getSingularName().equals(lRole)) {
                    Aggregation aggregation = lAggregations[j];
                    return aggregation;
                }
                ++j;
            }
            Aggregation aggregation = null;
            return aggregation;
        }
    }

    public abstract DevelopmentObjectEnum getDevelopmentObjectEnum();

    public abstract void accept(MetamodelVisitor var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

