/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel;

import com.sap.ide.metamodel.MetamodelObserver;
import com.sap.ide.metamodel.MetamodelTicket;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.PostOrderIterator;
import com.sap.ide.metamodel.core.PreOrderIterator;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.clipboard.MetamodelClipboardImpl;
import com.sap.ide.metamodel.core.compare.CompareResultImpl;
import com.sap.ide.metamodel.core.refactoring.RefactoringRequestImpl;
import com.sap.ide.metamodel.core.service.ArchiveManager;
import com.sap.ide.metamodel.core.service.FileSystemService;
import com.sap.ide.metamodel.core.service.LoggingService;
import com.sap.ide.metamodel.core.service.MetamodelNotificationService;
import com.sap.ide.metamodel.core.service.MultipleRootPathMDOLocator;
import com.sap.ide.metamodel.core.service.NamingServiceImpl;
import com.sap.ide.metamodel.core.service.ObjectCacheManager;
import com.sap.ide.metamodel.core.service.SingleRootPathMDOLocator;
import com.sap.ide.metamodel.core.service.XMLParsingService;
import com.sap.ide.metamodel.general.CommitResult;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.MDOLocator;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.RollbackResult;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.TraverseModeEnum;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.compare.CompareResult;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.I18NException;
import com.sap.ide.metamodel.general.exception.InvalidKeyException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.exception.ObjectInvalidException;
import com.sap.ide.metamodel.general.exception.SaveException;
import com.sap.ide.metamodel.general.i18n.I18NService;
import com.sap.ide.metamodel.general.i18n.MasterLanguageAccessMode;
import com.sap.ide.metamodel.general.metainfo.MetaClass;
import com.sap.ide.metamodel.general.refactoring.RefactoringRequest;
import com.sap.ide.metamodel.general.service.NamingService;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.TraceFormatter;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class Metamodel {
    private static final Location sLocation = Location.getLocation((String)"com.sap.ide.metamodel.Metamodel");
    private static final Category sCategoryInitialization = Category.getCategory((String)"/MetamodelCore/Initialization");
    private static final Category sCategoryFinalization = Category.getCategory((String)"/MetamodelCore/Finalization");
    private static final Category sCategoryCaching = Category.getCategory((String)"/MetamodelCore/Caching");
    private static final Category sCategoryClipboard = Category.getCategory((String)"/MetamodelCore/Clipboard");
    private static final Category sCategoryRefactoring = Category.getCategory((String)"/MetamodelCore/Refactoring");
    private static final Category sCategoryMisc = Category.getCategory((String)"/MetamodelCore/Misc");
    private static final Category sCategoryMDOLocating = Category.getCategory((String)"/MetamodelCore/MDOLocating");
    private static final Category sCategoryObjectAccess = Category.getCategory((String)"/MetamodelCore/ObjectAccess");
    private static HashMap sInstances = new HashMap();
    private static boolean sLoggingConfigured = false;
    private static MetamodelClipboard sClipboard = new MetamodelClipboardImpl();
    private static FileSystemService sFileSystemService = FileSystemService.getInstance();
    private static NamingServiceImpl sNamingService = NamingServiceImpl.getInstance();
    private static I18NService sI18NService = I18NService.getInstance();
    private MetamodelNotificationService mMetamodelNotificationService;
    private ObjectCacheManager mObjectCacheManager;
    private ArchiveManager mArchiveManager;
    private XMLParsingService mXMLParsingService;
    private HashMap mRoots;
    private MDOLocator mMDOLocator;
    private MetamodelTicket mMetamodelTicket;
    private boolean mTransientModeEnabled;
    private boolean mIsValid;
    private String mLanguage;
    private String mName;
    private String mUserId;
    private MasterLanguageAccessMode mMasterLanguageAccessMode;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$RootImpl;
    static /* synthetic */ Class class$com$sap$ide$metamodel$Metamodel;
    static /* synthetic */ Class class$com$sap$ide$metamodel$general$MDOLocator;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$service$ObjectCacheManager;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$service$ArchiveManager;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$service$XMLParsingService;
    static /* synthetic */ Class class$com$sap$ide$metamodel$general$Root;

    private Metamodel() {
    }

    public Metamodel(String name, String sourcePath) throws MetamodelException {
        this(name, sourcePath, "en");
    }

    public Metamodel(String name, String sourcePath, String language) throws MetamodelException {
        this(name, new SingleRootPathMDOLocator(sourcePath), language);
    }

    public Metamodel(String name, String defaultSourcePath, String[] additionalSourcePaths) throws MetamodelException {
        this(name, defaultSourcePath, additionalSourcePaths, "en");
    }

    public Metamodel(String name, String defaultSourcePath, String[] additionalSourcePaths, String language) throws MetamodelException {
        this(name, new MultipleRootPathMDOLocator(defaultSourcePath, additionalSourcePaths), language);
    }

    public Metamodel(String name, MDOLocator mdoLocator) throws MetamodelException {
        this(name, mdoLocator, "en");
    }

    public Metamodel(String name, MDOLocator mdoLocator, String language) throws MetamodelException {
        String method = "constructor()";
        if (name == null || name.length() == 0) {
            String lMessage = "metamodel must be named";
            sCategoryInitialization.fatalT(sLocation, "constructor()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        this.mName = name;
        HashMap hashMap = sInstances;
        synchronized (hashMap) {
            if (sInstances.containsKey(name)) {
                String lMessage = "metamodel \"" + name + "\" already exists";
                sCategoryInitialization.fatalT(sLocation, "constructor()", lMessage);
                throw new MetamodelException(this.exceptionMessage(lMessage));
            }
        }
        if (!sI18NService.isLanguageValid(language)) {
            String lMessage = "invalid language key: \"" + language + "\"";
            sCategoryInitialization.fatalT(sLocation, "constructor()", lMessage);
            throw new I18NException(this.exceptionMessage(lMessage));
        }
        this.mLanguage = language;
        if (mdoLocator == null) {
            String lMessage = "invalid MDOLocator (null)";
            sCategoryInitialization.fatalT(sLocation, "constructor()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        this.mMDOLocator = mdoLocator;
        try {
            this.mUserId = System.getProperty("user.name");
        }
        catch (SecurityException ex) {
            sCategoryInitialization.warningT(sLocation, "constructor()", "could not retrieve system property user.name");
            this.mUserId = "unknown";
        }
        HashMap hashMap2 = sInstances;
        synchronized (hashMap2) {
            sInstances.put(name, this);
        }
        sCategoryInitialization.infoT(sLocation, "constructor()", "created Metamodel instance: " + this + ", language key: \"" + this.mLanguage + "\", MDOLocator: " + this.mMDOLocator);
        this.mArchiveManager = new ArchiveManager();
        this.mMetamodelNotificationService = new MetamodelNotificationService();
        this.mObjectCacheManager = new ObjectCacheManager(this.mMetamodelNotificationService);
        this.mXMLParsingService = new XMLParsingService();
        this.mRoots = new HashMap();
        this.mMetamodelTicket = null;
        this.mTransientModeEnabled = false;
        this.mIsValid = true;
        this.mMasterLanguageAccessMode = MasterLanguageAccessMode.RAW;
    }

    private static void configureLogging() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("metamodel_logging.properties");
        if (is != null) {
            Properties lProperties = new Properties();
            try {
                lProperties.load(is);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            PropertiesConfigurator lConfigurator = new PropertiesConfigurator(lProperties);
            lConfigurator.configure();
            sCategoryInitialization.infoT(sLocation, "logging: using configuration file 'metamodel_logging.properties' from CLASSPATH");
        } else {
            Category lCategory = Category.getCategory((String)"/MetamodelCore");
            lCategory.setEffectiveSeverity(400);
            String lLogFile = System.getProperty("java.io.tmpdir") + "metamodel.log";
            lCategory.addLog((Log)new FileLog(lLogFile, (Formatter)new TraceFormatter("%24d[%5s] %-30l [%t]: %m")));
            sCategoryInitialization.infoT(sLocation, "logging: using internal configuration file");
        }
    }

    public static Metamodel getInstance(String name) {
        return (Metamodel)sInstances.get(name);
    }

    public String getName() {
        return this.mName;
    }

    public synchronized boolean isValid() {
        return this.mIsValid;
    }

    public MDOLocator getMDOLocator() {
        this._prepareForAccess();
        return this.mMDOLocator;
    }

    public synchronized String getLanguage() {
        this._prepareForAccess();
        return this.mLanguage;
    }

    public synchronized void setLanguage(String language) throws I18NException {
        this._prepareForAccess();
        String method = "setLanguage()";
        if (!sI18NService.isLanguageValid(language)) {
            String lMessage = "invalid language key: \"" + language + "\"";
            sCategoryInitialization.errorT(sLocation, "setLanguage()", lMessage);
            throw new I18NException(this.exceptionMessage(lMessage));
        }
        this.mLanguage = language;
        sCategoryInitialization.infoT(sLocation, "setLanguage()", "setting language key to \"" + this.mLanguage + "\"");
    }

    public synchronized void setMasterLanguageAccessMode(MasterLanguageAccessMode mode) {
        this._prepareForAccess();
        this.mMasterLanguageAccessMode = mode;
    }

    public synchronized MasterLanguageAccessMode getMasterLanguageAccessMode() {
        this._prepareForAccess();
        return this.mMasterLanguageAccessMode;
    }

    public synchronized void shutDown() throws MetamodelException {
        this._prepareForAccess();
        String method = "shutDown()";
        sCategoryFinalization.infoT(sLocation, "shutDown()", "shutting down Metamodel instance " + this);
        Iterator it = this.mRoots.values().iterator();
        while (it.hasNext()) {
            ((RootImpl)it.next())._invalidate();
        }
        this.mObjectCacheManager.invalidateAllProxies();
        sInstances.remove(this.mName);
        this.mIsValid = false;
    }

    public synchronized void setUserId(String userId) {
        this._prepareForAccess();
        this.mUserId = userId;
    }

    public synchronized String getUserId() {
        this._prepareForAccess();
        return this.mUserId;
    }

    public synchronized Root createRoot(Class rootInterface) throws MetamodelException {
        this._prepareForAccess();
        String method = "createRoot()";
        if (rootInterface == null) {
            String lMessage = "invalid root class (null)";
            sCategoryInitialization.fatalT(sLocation, "createRoot()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        String lModelName = this.getModelName(rootInterface);
        if (this.hasRoot(lModelName)) {
            String lMessage = "metamodel \"" + lModelName + "\" is already initialized";
            sCategoryInitialization.fatalT(sLocation, "createRoot()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        String lClassName = rootInterface.getName();
        lClassName = lClassName.substring(0, lClassName.lastIndexOf(46)) + ".implementation." + lModelName + "RootImpl";
        Class<?> lClass = null;
        try {
            lClass = Class.forName(lClassName, true, rootInterface.getClassLoader());
        }
        catch (Exception ex) {
            String lMessage = "root class " + rootInterface.getName() + " cannot be accessed";
            sCategoryInitialization.fatalT(sLocation, "createRoot()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        Class<?> lSuperClass = lClass.getSuperclass();
        boolean valid = false;
        while (lSuperClass != null) {
            if (lSuperClass == (class$com$sap$ide$metamodel$core$RootImpl == null ? Metamodel.class$("com.sap.ide.metamodel.core.RootImpl") : class$com$sap$ide$metamodel$core$RootImpl)) {
                valid = true;
                break;
            }
            lSuperClass = lSuperClass.getSuperclass();
        }
        if (!valid) {
            String lMessage = rootInterface.getName() + " is not a valid metamodel root class";
            sCategoryInitialization.fatalT(sLocation, "createRoot()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        Root lResult = null;
        try {
            Class[] lParams = new Class[]{class$com$sap$ide$metamodel$Metamodel == null ? (class$com$sap$ide$metamodel$Metamodel = Metamodel.class$("com.sap.ide.metamodel.Metamodel")) : class$com$sap$ide$metamodel$Metamodel, class$com$sap$ide$metamodel$general$MDOLocator == null ? (class$com$sap$ide$metamodel$general$MDOLocator = Metamodel.class$("com.sap.ide.metamodel.general.MDOLocator")) : class$com$sap$ide$metamodel$general$MDOLocator, class$com$sap$ide$metamodel$core$service$ObjectCacheManager == null ? (class$com$sap$ide$metamodel$core$service$ObjectCacheManager = Metamodel.class$("com.sap.ide.metamodel.core.service.ObjectCacheManager")) : class$com$sap$ide$metamodel$core$service$ObjectCacheManager, class$com$sap$ide$metamodel$core$service$ArchiveManager == null ? (class$com$sap$ide$metamodel$core$service$ArchiveManager = Metamodel.class$("com.sap.ide.metamodel.core.service.ArchiveManager")) : class$com$sap$ide$metamodel$core$service$ArchiveManager, class$com$sap$ide$metamodel$core$service$XMLParsingService == null ? (class$com$sap$ide$metamodel$core$service$XMLParsingService = Metamodel.class$("com.sap.ide.metamodel.core.service.XMLParsingService")) : class$com$sap$ide$metamodel$core$service$XMLParsingService};
            Constructor<?> lConstructor = lClass.getConstructor(lParams);
            Object[] lArgs = new Object[]{this, this.mMDOLocator, this.mObjectCacheManager, this.mArchiveManager, this.mXMLParsingService};
            lResult = (Root)lConstructor.newInstance(lArgs);
        }
        catch (Exception ex) {
            String lMessage = rootInterface.getName() + " could not be instantiated";
            sCategoryInitialization.fatalT(sLocation, "createRoot()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        this.mRoots.put(lModelName, lResult);
        sCategoryInitialization.infoT(sLocation, "createRoot()", "instantiated root for model \"" + lModelName + "\": " + lResult);
        this.mArchiveManager.registerRoot(lResult);
        return lResult;
    }

    public synchronized Root getRoot(String modelName) {
        this._prepareForAccess();
        return (Root)this.mRoots.get(modelName);
    }

    public synchronized Root getRoot(Class rootInterface) {
        this._prepareForAccess();
        if (rootInterface == null) {
            return null;
        }
        return this.getRoot(this.getModelName(rootInterface));
    }

    public synchronized Root[] getRoots() {
        this._prepareForAccess();
        return this.mRoots.values().toArray(new Root[0]);
    }

    public synchronized boolean hasRoot(String modelName) {
        this._prepareForAccess();
        return this.getRoot(modelName) != null;
    }

    public synchronized boolean hasRoot(Class rootInterface) {
        this._prepareForAccess();
        if (rootInterface == null) {
            return false;
        }
        return this.hasRoot(this.getModelName(rootInterface));
    }

    public MetaClass getMetaClass(DevelopmentObjectEnum clazz) {
        this._prepareForAccess();
        if (clazz == null) {
            return null;
        }
        RootImpl lRootImpl = (RootImpl)this.mRoots.get(clazz.getModelName());
        if (lRootImpl == null) {
            return null;
        }
        return lRootImpl.getMetaClass(clazz);
    }

    public MetaClass getRootMetaClass(Class rootInterface) throws MetamodelException {
        this._prepareForAccess();
        String method = "getRootMetaClass()";
        if (rootInterface == null) {
            String lMessage = "invalid root class (null)";
            sCategoryMisc.errorT(sLocation, "getRootMetaClass()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        String lClassName = rootInterface.getName();
        lClassName = lClassName.substring(0, lClassName.lastIndexOf(46)) + ".implementation." + this.getModelName(rootInterface) + "RootImpl";
        Class[] lInterfaces = new Class[]{};
        Class<?> lClass = null;
        try {
            lClass = Class.forName(lClassName);
            lInterfaces = rootInterface.getInterfaces();
        }
        catch (Exception ex) {
            String lMessage = rootInterface.getName() + " cannot be accessed";
            sCategoryMisc.errorT(sLocation, "getRootMetaClass()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        boolean valid = false;
        int i = 0;
        while (i < lInterfaces.length) {
            if (lInterfaces[i] == (class$com$sap$ide$metamodel$general$Root == null ? Metamodel.class$("com.sap.ide.metamodel.general.Root") : class$com$sap$ide$metamodel$general$Root)) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            String lMessage = rootInterface.getName() + " is not a valid metamodel root class";
            sCategoryMisc.errorT(sLocation, "getRootMetaClass()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        MetaClass lResult = null;
        try {
            Method lGetMetaClassMethod = lClass.getMethod("_getMetaClass", new Class[0]);
            lResult = (MetaClass)lGetMetaClassMethod.invoke(lClass, new Object[0]);
        }
        catch (Exception ex) {
            String lMessage = "MetaClass access failed";
            sCategoryMisc.errorT(sLocation, "getRootMetaClass()", lMessage);
            throw new MetamodelException(this.exceptionMessage(lMessage));
        }
        return lResult;
    }

    private String getModelName(Class rootInterface) {
        String lModelName = rootInterface.getName();
        lModelName = lModelName.substring(lModelName.lastIndexOf(46) + 1, lModelName.length() - 4);
        return lModelName;
    }

    public synchronized MetamodelTicket enableSecureMode() {
        this._prepareForAccess();
        String method = "enableSecureMode()";
        if (this.mMetamodelTicket != null) {
            String lMessage = "operation not allowed in secure mode";
            sCategoryMisc.errorT(sLocation, "enableSecureMode()", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        this.mMetamodelTicket = new MetamodelTicket(){};
        return this.mMetamodelTicket;
    }

    public synchronized void disableSecureMode(MetamodelTicket ticket) {
        this._prepareForAccess();
        String method = "disableSecureMode()";
        if (this.mMetamodelTicket == null) {
            return;
        }
        if (this.mMetamodelTicket != ticket) {
            String lMessage = "invalid ticket for this operation";
            sCategoryMisc.errorT(sLocation, "disableSecureMode()", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        this.mMetamodelTicket = null;
    }

    public synchronized CommitResult commitChanges() throws SaveException, DeleteException {
        this._prepareForAccess();
        String method = "commitChanges()";
        if (this.mMetamodelTicket != null) {
            String lMessage = "operation not allowed in secure mode";
            sCategoryMisc.errorT(sLocation, "commitChanges()", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        return this.commitChanges(null);
    }

    public synchronized CommitResult commitChanges(MetamodelTicket ticket) throws SaveException, DeleteException {
        this._prepareForAccess();
        String method = "commitChanges(MetamodelTicket)";
        if (this.mMetamodelTicket != ticket) {
            String lMessage = "invalid ticket for this operation";
            sCategoryMisc.errorT(sLocation, "commitChanges(MetamodelTicket)", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        if (this.mTransientModeEnabled) {
            String lMessage = "commit not allowed in transient mode";
            sCategoryCaching.errorT(sLocation, "commitChanges(MetamodelTicket)", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        return this.mObjectCacheManager.commitChanges();
    }

    public synchronized RollbackResult rollbackChanges() throws LoadException {
        this._prepareForAccess();
        String method = "rollbackChanges()";
        if (this.mMetamodelTicket != null) {
            String lMessage = "operation not allowed in secure mode";
            sCategoryMisc.errorT(sLocation, "rollbackChanges()", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        return this.rollbackChanges(null);
    }

    public synchronized RollbackResult rollbackChanges(MetamodelTicket ticket) throws LoadException {
        this._prepareForAccess();
        String method = "rollbackChanges(MetamodelTicket)";
        if (this.mMetamodelTicket != ticket) {
            String lMessage = "invalid ticket for this operation";
            sCategoryMisc.errorT(sLocation, "rollbackChanges(MetamodelTicket)", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        RollbackResult lResult = this.mObjectCacheManager.rollbackChanges();
        Iterator lIterator = this.mRoots.values().iterator();
        while (lIterator.hasNext()) {
            RootImpl lRootImpl = (RootImpl)lIterator.next();
            lRootImpl._reload();
        }
        this.mTransientModeEnabled = false;
        return lResult;
    }

    public synchronized void refresh() throws MetamodelException {
        this._prepareForAccess();
        String method = "refresh()";
        if (this.mMetamodelTicket != null) {
            String lMessage = "operation not allowed in secure mode";
            sCategoryMisc.errorT(sLocation, "refresh()", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        this.refresh(null);
    }

    public synchronized void refresh(MetamodelTicket ticket) throws MetamodelException {
        this._prepareForAccess();
        String method = "refresh(MetamodelTicket)";
        if (this.mMetamodelTicket != ticket) {
            String lMessage = "invalid ticket for this operation";
            sCategoryMisc.errorT(sLocation, "refresh(MetamodelTicket)", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        if (this.mMetamodelNotificationService.isDirty()) {
            String lMessage = "Refresh is not allowed on modified development object cache. Commit or rollback changes first.";
            sCategoryCaching.errorT(sLocation, "refresh(MetamodelTicket)", lMessage);
            throw new MetamodelException(lMessage);
        }
        this.mObjectCacheManager.refresh();
        Iterator it = this.mRoots.values().iterator();
        while (it.hasNext()) {
            RootImpl lRoot = (RootImpl)it.next();
            lRoot._reload();
        }
    }

    public synchronized void clear() throws MetamodelException {
        this._prepareForAccess();
        String method = "clear()";
        if (this.mMetamodelTicket != null) {
            String lMessage = "operation not allowed in secure mode";
            sCategoryMisc.errorT(sLocation, "clear()", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        this.clear(null);
    }

    public synchronized void clear(MetamodelTicket ticket) throws MetamodelException {
        this._prepareForAccess();
        String method = "clear(MetamodelTicket)";
        if (this.mMetamodelTicket != ticket) {
            String lMessage = "invalid ticket for this operation";
            sCategoryMisc.errorT(sLocation, "clear(MetamodelTicket)", lMessage);
            throw new SecurityException(this.exceptionMessage(lMessage));
        }
        this.mObjectCacheManager.clear();
        Iterator it = this.mRoots.values().iterator();
        while (it.hasNext()) {
            ((RootImpl)it.next())._dropState();
        }
        this.rescanArchives();
    }

    public synchronized void enableKeyCaching() {
        this._prepareForAccess();
        this.mObjectCacheManager.setKeyCachingEnabled(true);
    }

    public synchronized void disableKeyCaching() {
        this._prepareForAccess();
        this.mObjectCacheManager.setKeyCachingEnabled(false);
    }

    public synchronized boolean isKeyCachingEnabled() {
        this._prepareForAccess();
        return this.mObjectCacheManager.getKeyCachingEnabled();
    }

    public synchronized DevelopmentObjectKey createDevelopmentObjectKey(String mdoPackage, String mdoName, MDOEnum mdoType, String objectPath) throws InvalidKeyException {
        this._prepareForAccess();
        return this.createDevelopmentObjectKey(mdoPackage, mdoName, mdoType, objectPath, true);
    }

    private DevelopmentObjectKey createDevelopmentObjectKeyNoError(String mdoPackage, String mdoName, MDOEnum mdoType, String objectPath) {
        DevelopmentObjectKey lKey = null;
        try {
            lKey = this.createDevelopmentObjectKey(mdoPackage, mdoName, mdoType, objectPath, false);
        }
        catch (InvalidKeyException ex) {
            // empty catch block
        }
        return lKey;
    }

    private DevelopmentObjectKey createDevelopmentObjectKey(String mdoPackage, String mdoName, MDOEnum mdoType, String objectPath, boolean logError) throws InvalidKeyException {
        String method = "createDevelopmentObjectKey()";
        String lModelName = null;
        if (mdoType != null && this.getRoot(lModelName = mdoType.getModelName()) == null) {
            sCategoryCaching.warningT(sLocation, "createDevelopmentObjectKey()", "root for model \"" + lModelName + "\" not available in current address space");
        }
        ForeignReference lKey = new ForeignReference(lModelName, mdoPackage, mdoName, mdoType, objectPath);
        if (lModelName == null || mdoType == null || !sNamingService.isValidMainDevelopmentObjectName(mdoName) || !sNamingService.isValidMainDevelopmentObjectPackage(mdoPackage)) {
            if (logError) {
                String lMessage = "invalid key: " + lKey.toString();
                sCategoryMisc.errorT(sLocation, "createDevelopmentObjectKey()", lMessage);
                throw new InvalidKeyException(lKey.toString());
            }
            return null;
        }
        return lKey;
    }

    public DevelopmentObjectKey createDevelopmentObjectKey(String mdoPackage, String mdoName, MDOEnum mdoType) throws InvalidKeyException {
        this._prepareForAccess();
        return this.createDevelopmentObjectKey(mdoPackage, mdoName, mdoType, null);
    }

    public synchronized DevelopmentObjectKey createDevelopmentObjectKeyFromString(String key) throws InvalidKeyException {
        this._prepareForAccess();
        String method = "createDevelopmentObjectKeyFromString()";
        if (key == null) {
            throw new InvalidKeyException(key);
        }
        if (key.length() == 0) {
            throw new InvalidKeyException(key);
        }
        try {
            String lMDOName;
            String lkey = key.substring(2);
            String lObjectPath = "";
            int lDelimiterPosition = lkey.indexOf(47);
            String lModelName = lkey.substring(0, lDelimiterPosition);
            RootImpl lRoot = (RootImpl)this.mRoots.get(lModelName);
            if (lRoot == null) {
                throw new InvalidKeyException(key);
            }
            if ((lDelimiterPosition = (lkey = lkey.substring(lDelimiterPosition + 1)).indexOf(47)) != -1) {
                lObjectPath = lkey.substring(lDelimiterPosition + 1);
                lkey = lkey.substring(0, lDelimiterPosition);
            }
            if (!sNamingService.isValidMainDevelopmentObjectName(lMDOName = lkey.substring((lDelimiterPosition = lkey.lastIndexOf(46)) + 1))) {
                throw new InvalidKeyException(key);
            }
            String lMDOPackage = (lkey = lkey.substring(0, lDelimiterPosition)).substring((lDelimiterPosition = lkey.indexOf(58)) + 1);
            if (!sNamingService.isValidMainDevelopmentObjectPackage(lMDOPackage)) {
                throw new InvalidKeyException(key);
            }
            String lMDOType = lkey.substring(0, lDelimiterPosition);
            return new ForeignReference(lModelName, lMDOPackage, lMDOName, lRoot._getMDOEnum(lMDOType), lObjectPath);
        }
        catch (Exception ex) {
            sCategoryCaching.errorT(sLocation, "createDevelopmentObjectKeyFromString()", "invalid development object key: " + key);
            throw new InvalidKeyException(key);
        }
    }

    public boolean objectExists(String key) {
        this._prepareForAccess();
        DevelopmentObjectKey lKey = null;
        try {
            lKey = this.createDevelopmentObjectKeyFromString(key);
        }
        catch (InvalidKeyException ex) {
            return false;
        }
        return this.objectExists(lKey);
    }

    public synchronized boolean objectExists(DevelopmentObjectKey key) {
        this._prepareForAccess();
        String method = "objectExists(DevelopmentObjectKey)";
        if (key == null || key.getModelName() == null || key.getMDOPackage() == null || key.getMDOName() == null || key.getMDOType() == null) {
            return false;
        }
        DevelopmentObjectProxy lMDO = this.mObjectCacheManager.getMDOInstance((ForeignReference)key);
        if (key.refersToMDO()) {
            if (lMDO != null) {
                return lMDO._isValid();
            }
            boolean lFound = false;
            try {
                lFound = this.mMDOLocator.getMDOPath(key.getMDOPackage(), key.getMDOName(), key.getMDOType()) != null;
            }
            catch (Throwable t) {
                LoggingService.getInstance().logException(t, sLocation, sCategoryMDOLocating, "objectExists(DevelopmentObjectKey)", "MDOLocator " + this.mMDOLocator + " threw exception: ");
            }
            if (!lFound) {
                try {
                    lFound = this.mArchiveManager.getMDOPath(key.getMDOPackage(), key.getMDOName(), key.getMDOType()) != null;
                }
                catch (Throwable t) {
                    LoggingService.getInstance().logException(t, sLocation, sCategoryMDOLocating, "objectExists(DevelopmentObjectKey)", "ArchiveManager threw exception: ");
                }
            }
            return lFound && !this.mObjectCacheManager.isMDORefactored(key);
        }
        if (lMDO != null && !lMDO._isValid()) {
            return false;
        }
        return this.getObjectFromKey(key) != null;
    }

    public boolean objectExists(String mdoPackage, String mdoName, MDOEnum mdoType, String objectPath) {
        this._prepareForAccess();
        if (mdoType == null) {
            return false;
        }
        DevelopmentObjectKey lKey = this.createDevelopmentObjectKeyNoError(mdoPackage, mdoName, mdoType, objectPath);
        if (lKey == null) {
            return false;
        }
        return this.objectExists(lKey);
    }

    public boolean objectExists(String mdoPackage, String mdoName, MDOEnum mdoType) {
        this._prepareForAccess();
        return this.objectExists(mdoPackage, mdoName, mdoType, null);
    }

    public synchronized DevelopmentObject getObjectFromKey(DevelopmentObjectKey key) {
        this._prepareForAccess();
        if (key == null) {
            return null;
        }
        RootImpl lRoot = (RootImpl)this.mRoots.get(key.getModelName());
        if (lRoot == null) {
            return null;
        }
        return lRoot.getObjectFromKey((ForeignReference)key);
    }

    public synchronized void enableMetamodelEventing() {
        this._prepareForAccess();
        this.mMetamodelNotificationService.enableMetamodelEventing();
    }

    public synchronized void disableMetamodelEventing() {
        this._prepareForAccess();
        this.mMetamodelNotificationService.disableMetamodelEventing();
    }

    public synchronized void enableAutoNotify() {
        this._prepareForAccess();
        this.mMetamodelNotificationService.setAutoNotify(true);
    }

    public synchronized void disableAutoNotify() {
        this._prepareForAccess();
        this.mMetamodelNotificationService.setAutoNotify(false);
    }

    public synchronized void notifyMetamodelObservers() {
        this._prepareForAccess();
        this.mMetamodelNotificationService.notifyObservers();
    }

    public synchronized boolean isMetamodelEventingEnabled() {
        this._prepareForAccess();
        return this.mMetamodelNotificationService.isMetamodelEventingEnabled();
    }

    public synchronized void attachMetamodelObserver(MetamodelObserver observer) {
        this._prepareForAccess();
        this.mMetamodelNotificationService.attachMetamodelObserver(observer);
    }

    public synchronized void detachMetamodelObserver(MetamodelObserver observer) {
        this._prepareForAccess();
        this.mMetamodelNotificationService.detachMetamodelObserver(observer);
    }

    public synchronized void detachAllMetamodelObservers() {
        this._prepareForAccess();
        this.mMetamodelNotificationService.detachAllMetamodelObservers();
    }

    public synchronized boolean isModified() {
        this._prepareForAccess();
        return this.mMetamodelNotificationService.isDirty();
    }

    public synchronized void addArchive(String path) {
        this._prepareForAccess();
        this.mArchiveManager.addArchive(path);
    }

    public synchronized void addArchive(String path, String rootFolder) {
        this._prepareForAccess();
        this.mArchiveManager.addArchive(path, rootFolder);
    }

    public synchronized void removeArchive(String path) {
        this._prepareForAccess();
        this.mArchiveManager.removeArchive(path);
        this.mObjectCacheManager.archiveRemoved(path);
    }

    public synchronized void removeAllArchives() {
        this._prepareForAccess();
        this.mArchiveManager.removeAllArchives();
        this.mObjectCacheManager.allArchivesRemoved();
    }

    public synchronized void rescanArchive(String path) {
        this._prepareForAccess();
        this.mArchiveManager.rescanArchive(path);
        this.mObjectCacheManager.archiveRemoved(path);
    }

    public synchronized void rescanArchives() {
        this._prepareForAccess();
        this.mArchiveManager.rescanArchives();
        this.mObjectCacheManager.allArchivesRemoved();
    }

    public synchronized String[] getArchives() {
        this._prepareForAccess();
        return this.mArchiveManager.getArchives();
    }

    public synchronized void enableTransientMode() {
        this._prepareForAccess();
        this.mTransientModeEnabled = true;
    }

    public synchronized RollbackResult disableTransientModeAndRollbackChanges() throws LoadException {
        this._prepareForAccess();
        if (this.mTransientModeEnabled) {
            return this.rollbackChanges(this.mMetamodelTicket);
        }
        return null;
    }

    public synchronized void disableTransientModeAndDoFastRollback() {
        this._prepareForAccess();
        if (this.mTransientModeEnabled) {
            this.mObjectCacheManager.fastRollback();
        }
        this.mTransientModeEnabled = false;
    }

    public synchronized boolean isTransientModeEnabled() {
        this._prepareForAccess();
        return this.mTransientModeEnabled;
    }

    public synchronized void disableFileDeletion() {
        this._prepareForAccess();
        this.mObjectCacheManager.setFileDeletionEnabled(false);
    }

    public synchronized void enableFileDeletion() {
        this._prepareForAccess();
        this.mObjectCacheManager.setFileDeletionEnabled(true);
    }

    public boolean isFileDeletionEnabled() {
        this._prepareForAccess();
        return this.mObjectCacheManager.getFileDeletionEnabled();
    }

    public static NamingService getNamingService() {
        return sNamingService;
    }

    public static MetamodelClipboard getClipboard() {
        return sClipboard;
    }

    public static MetamodelClipboard createInternalClipboard() {
        return new MetamodelClipboardImpl();
    }

    public RefactoringRequest createRefactoringRequest() {
        this._prepareForAccess();
        String method = "createRefactoringRequest()";
        sCategoryRefactoring.infoT(sLocation, "createRefactoringRequest()", "created refactoring request for Metamodel instance: " + this);
        return new RefactoringRequestImpl(this);
    }

    private void _prepareForAccess() throws ObjectInvalidException {
        String method = "_prepareForAccess()";
        if (!this.mIsValid) {
            String lMessage = "attempt to access invalid metamodel instance (already shut down): " + this;
            sCategoryObjectAccess.errorT(sLocation, "_prepareForAccess()", lMessage);
            throw new ObjectInvalidException(this.exceptionMessage(lMessage));
        }
    }

    private String exceptionMessage(String message) {
        return message.substring(0, 1).toUpperCase() + message.substring(1) + "!";
    }

    public MetamodelIterator iterator() {
        return this.iterator(TraverseModeEnum.PREORDER);
    }

    public synchronized MetamodelIterator iterator(TraverseModeEnum traverseMode) {
        if (traverseMode == TraverseModeEnum.PREORDER) {
            return new PreOrderIterator(this);
        }
        return new PostOrderIterator(this);
    }

    public CompareResult compareTo(Metamodel metamodel) {
        return this.compareTo(metamodel, true, true, false);
    }

    public CompareResult compareTo(Metamodel metamodel, boolean includeChildren, boolean includeAssociations, boolean includeDanglingReferences) {
        CompareResultImpl lResult = new CompareResultImpl();
        Iterator it = this.mRoots.keySet().iterator();
        while (it.hasNext()) {
            String lModelName = (String)it.next();
            if (!metamodel.mRoots.containsKey(lModelName)) continue;
            Root root1 = (Root)this.mRoots.get(lModelName);
            Root root2 = (Root)metamodel.mRoots.get(lModelName);
            lResult.merge(root1.compareTo(root2, includeChildren, includeAssociations, includeDanglingReferences));
        }
        return lResult;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Metamodel.configureLogging();
    }
}

