/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.util;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.exception.IBaseException;
import com.sap.jms.server.exception.JMSResourceAccessor;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ResourceAccessor {
    private static JMSResourceAccessor resourceAccessor = null;
    public static Category logger = Category.getCategory((String)"/System/Server");
    public static Location tracer = Location.getLocation((String)"com.sap.jms");
    private static final String LOG_COMPONENT = "util.ResourceAccessor";

    public static synchronized String formatString(String patternKey, Object[] args) {
        if (resourceAccessor == null) {
            resourceAccessor = (JMSResourceAccessor)JMSResourceAccessor.getResourceAccessor();
            JMSResourceAccessor.init(logger, tracer);
        }
        String message = null;
        try {
            message = LocalizableTextFormatter.formatString((com.sap.localization.ResourceAccessor)resourceAccessor, (String)patternKey, (Object[])args);
        }
        catch (Exception e) {
            LoggingHelper.traceThrowable(400, tracer, LOG_COMPONENT, e);
            return null;
        }
        return message;
    }

    public static String getStackTrace(Throwable t) {
        String stackTrace;
        if (t instanceof IBaseException) {
            stackTrace = ((IBaseException)t).getNestedStackTraceString();
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            t.printStackTrace(writer);
            stackTrace = sw.toString();
        }
        return stackTrace;
    }
}

