/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.util;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Vector;

public class PrintfWriter
extends Writer {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.util.PrintfWriter");
    private static final Category logger = Category.getCategory((String)"/System/Server");
    private Writer out;
    private boolean m_autoflush = true;
    private boolean m_trouble = false;
    private String m_line_separator;
    private DecimalFormat m_decimal_format = new DecimalFormat();
    static final int ZEROPAD = 1;
    static final int SIGN = 2;
    static final int PLUS = 4;
    static final int SPACE = 8;
    static final int LEFT = 16;
    static final int SPECIAL = 32;
    static final int LARGE = 64;
    static final int EXPONENT = 128;
    static final int VAREXPONENT = 256;
    static final char[] DIGITS_LOWER = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
    static final char[] DIGITS_UPPER = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final char[] NULL_STRING = "<null>".toCharArray();
    static long LONG_MASK = 0L;
    static final char[] HEXCHARS;

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static long log10(double arg) {
        return Math.round(Math.log(arg) / 2.302585092994046);
    }

    private static final char[] toHex(byte[] value) {
        char[] s = new char[value.length * 2];
        int i = 0;
        int k = 0;
        while (i < value.length) {
            s[k++] = HEXCHARS[value[i] >> 4 & 0xF];
            s[k++] = HEXCHARS[value[i] & 0xF];
            ++i;
        }
        return s;
    }

    public static PrintfWriter getInstance() {
        StringWriter out = new StringWriter();
        return new PrintfWriter(out);
    }

    public PrintfWriter(Writer out) {
        this(out, false);
    }

    public PrintfWriter(Writer out, boolean autoflush) {
        super((Object)out);
        this.out = out;
        this.m_autoflush = autoflush;
        this.m_line_separator = System.getProperty("line.separator");
        DecimalFormatSymbols s = this.m_decimal_format.getDecimalFormatSymbols();
        s.setDecimalSeparator('.');
        this.m_decimal_format.setDecimalFormatSymbols(s);
    }

    public PrintfWriter(OutputStream out) {
        this(out, true);
    }

    public PrintfWriter(OutputStream out, boolean autoflush) {
        this(new BufferedWriter(new OutputStreamWriter(out)), autoflush);
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("stream closed in PrintfWriter");
        }
    }

    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.flush();
            }
        }
        catch (IOException x) {
            this.m_trouble = true;
        }
    }

    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    return;
                }
                this.out.flush();
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException x) {
            this.m_trouble = true;
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.m_trouble;
    }

    protected void setError() {
        this.m_trouble = true;
    }

    public void write(int c) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(c);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.m_trouble = true;
        }
    }

    public void write(char[] buf, int offset, int length) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(buf, offset, length);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.m_trouble = true;
        }
    }

    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    public void write(String str, int offset, int length) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(str, offset, length);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.m_trouble = true;
        }
    }

    public void write(String str) {
        this.write(str, 0, str.length());
    }

    protected void newLine() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(this.m_line_separator);
                if (this.m_autoflush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.m_trouble = true;
        }
    }

    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] c) {
        this.write(c);
    }

    public void print(String s) {
        this.write(s != null ? s : "null");
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void printf(String fmt, Arg args) {
        if (fmt == null) {
            this.setError();
            return;
        }
        char[] buffer = new char[10240];
        int len = this.vsprintf(buffer, 0, fmt.toCharArray(), args.getArgs());
        args.args.removeAllElements();
        this.write(buffer, 0, len);
    }

    public void println() {
        Object object = this.lock;
        synchronized (object) {
            this.newLine();
        }
    }

    public void println(boolean b) {
        Object object = this.lock;
        synchronized (object) {
            this.print(b);
            this.newLine();
        }
    }

    public void println(char c) {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.newLine();
        }
    }

    public void println(int i) {
        Object object = this.lock;
        synchronized (object) {
            this.print(i);
            this.newLine();
        }
    }

    public void println(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.newLine();
        }
    }

    public void println(float f) {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.newLine();
        }
    }

    public void println(double x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.newLine();
        }
    }

    public void println(char[] c) {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.newLine();
        }
    }

    public void println(String s) {
        Object object = this.lock;
        synchronized (object) {
            this.print(s);
            this.newLine();
        }
    }

    public void println(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            this.print(obj);
            this.newLine();
        }
    }

    public void printfln(String fmt, Arg args) {
        Object object = this.lock;
        synchronized (object) {
            this.printf(fmt, args);
            this.newLine();
        }
    }

    private long getLong(Object obj) {
        long num = 0L;
        if (obj instanceof Integer) {
            num = ((Integer)obj).intValue();
        } else if (obj instanceof Character) {
            num = ((Character)obj).charValue();
        } else if (obj instanceof Short) {
            num = ((Short)obj).shortValue();
        } else if (obj instanceof Long) {
            num = (Long)obj;
        }
        return num;
    }

    private long getULong(Object obj) {
        long num = 0L;
        if (obj instanceof Integer) {
            num = (long)((Integer)obj).intValue() & LONG_MASK;
        } else if (obj instanceof Character) {
            num = (long)((Character)obj).charValue() & LONG_MASK;
        } else if (obj instanceof Short) {
            num = (long)((Short)obj).shortValue() & LONG_MASK;
        } else if (obj instanceof Long) {
            num = (Long)obj;
        }
        return num;
    }

    /*
     * Unable to fully structure code
     */
    private int formatInt(char[] buffer, int offset, Object obj, long base, int size, int precision, int type) {
        block29: {
            block28: {
                tmp = new char[66];
                digits = PrintfWriter.DIGITS_LOWER;
                if ((type & 64) != 0) {
                    digits = PrintfWriter.DIGITS_UPPER;
                }
                if ((type & 16) != 0) {
                    type &= -2;
                }
                if (base < 2L || base > 36L) {
                    return 0;
                }
                num = 0L;
                num = (type & 2) == 0 ? this.getULong(obj) : this.getLong(obj);
                prefix = 0;
                if ((type & 2) != 0) {
                    if (num < 0L) {
                        prefix = 45;
                        num = -num;
                        --size;
                    } else if ((type & 4) != 0) {
                        prefix = 43;
                        --size;
                    } else if ((type & 8) != 0) {
                        prefix = 32;
                        --size;
                    }
                }
                if ((type & 32) != 0) {
                    if (base == 16L) {
                        size -= 2;
                    } else if (base == 8L) {
                        --size;
                    }
                }
                i = 0;
                if (num != 0L) break block28;
                tmp[i++] = 48;
                break block29;
            }
            if (base == 16L) ** GOTO lbl44
            while (num != 0L) {
                tmp[i++] = digits[(int)(num % base)];
                num /= base;
            }
            break block29;
lbl-1000:
            // 1 sources

            {
                tmp[i++] = digits[(int)(num & 15L)];
                num >>>= 4;
lbl44:
                // 2 sources

                ** while (num != 0L)
            }
        }
        if (i > precision) {
            precision = i;
        }
        size -= precision;
        if ((type & 17) == 0) {
            while (size-- > 0) {
                buffer[offset++] = 32;
            }
        }
        if (prefix != 0) {
            buffer[offset++] = prefix;
        }
        if ((type & 32) != 0) {
            if (base == 8L) {
                buffer[offset++] = 48;
            } else if (base == 16L) {
                buffer[offset++] = 48;
                buffer[offset++] = digits[33];
            }
        }
        if ((type & 16) == 0) {
            pad = (type & 1) != 0 ? 48 : 32;
            while (size-- > 0) {
                buffer[offset++] = pad;
            }
        }
        while (i < precision--) {
            buffer[offset++] = 48;
        }
        while (i-- > 0) {
            buffer[offset++] = tmp[i];
        }
        while (size-- > 0) {
            buffer[offset++] = 32;
        }
        return offset;
    }

    private int formatFlt(char[] buffer, int offset, Object obj, int size, int precision, int type) {
        char[] tmp;
        long exp;
        this.m_decimal_format.setMinimumFractionDigits(precision);
        this.m_decimal_format.setMaximumFractionDigits(precision);
        int prefix = 0;
        double num = 0.0;
        if ((type & 0x10) != 0) {
            type &= 0xFFFFFFFE;
        }
        if (obj instanceof Double) {
            num = (Double)obj;
        } else if (obj instanceof Integer) {
            num = ((Integer)obj).intValue();
        }
        if (num < 0.0) {
            prefix = 45;
            num = -num;
            --size;
        } else if ((type & 4) != 0) {
            prefix = 43;
            --size;
        } else if ((type & 8) != 0) {
            prefix = 32;
            --size;
        }
        if ((type & 0x100) != 0 && ((exp = PrintfWriter.log10(num)) < -4L || exp >= (long)precision)) {
            type |= 0x80;
        }
        if ((type & 0x80) != 0) {
            exp = PrintfWriter.log10(num);
            StringBuffer sb = new StringBuffer(this.m_decimal_format.format(num *= Math.pow(10.0, -exp)));
            sb.append((type & 0x40) != 0 ? (char)'E' : 'e');
            sb.append(exp < 0L ? (char)'-' : '+');
            if (exp < 0L) {
                exp = -exp;
            }
            if (exp < 10L) {
                sb.append(0);
            }
            sb.append(exp < 0L ? -exp : exp);
            tmp = sb.toString().toCharArray();
        } else {
            tmp = this.m_decimal_format.format(num).toCharArray();
        }
        size -= tmp.length;
        if ((type & 0x11) == 0) {
            while (size-- > 0) {
                buffer[offset++] = 32;
            }
        }
        if (prefix != 0) {
            buffer[offset++] = prefix;
        }
        if ((type & 1) != 0) {
            while (size-- > 0) {
                buffer[offset++] = 48;
            }
        }
        int i = 0;
        while (i < tmp.length) {
            buffer[offset++] = tmp[i];
            ++i;
        }
        while (size-- > 0) {
            buffer[offset++] = 32;
        }
        return offset;
    }

    private int formatStr(char[] buffer, int offset, Object obj, int field_width, int precision, int flags) {
        int pad;
        char[] s = null;
        int len = 0;
        if (obj instanceof String) {
            s = ((String)obj).toCharArray();
        } else if (obj instanceof char[]) {
            s = (char[])obj;
        } else if (obj instanceof byte[]) {
            s = PrintfWriter.toHex((byte[])obj);
        } else if (obj != null) {
            s = obj.toString().toCharArray();
        }
        if (s == null) {
            s = NULL_STRING;
        }
        len = precision >= 0 ? (s.length < precision ? s.length : precision) : s.length;
        int n = pad = (flags & 1) != 0 ? 48 : 32;
        if ((flags & 0x10) == 0) {
            while (len < field_width--) {
                buffer[offset++] = pad;
            }
        }
        int imax = field_width > 0 && field_width < len ? field_width : len;
        int i = 0;
        while (i < imax) {
            buffer[offset++] = s[i];
            ++i;
        }
        while (len < field_width--) {
            buffer[offset++] = pad;
        }
        return offset;
    }

    private int vsprintf(char[] buffer, int offset, char[] fmt, Object[] va_arg) {
        int iarg = 0;
        long base = 10L;
        int ifmt = 0;
        while (ifmt < fmt.length) {
            char c = fmt[ifmt];
            if (c == '\n') {
                this.write(buffer, 0, offset);
                this.newLine();
                offset = 0;
            } else if (c != '%') {
                buffer[offset++] = c;
            } else {
                int flags = 0;
                boolean repeat = false;
                do {
                    switch (fmt[++ifmt]) {
                        case '-': {
                            flags |= 0x10;
                            repeat = true;
                            break;
                        }
                        case '+': {
                            flags |= 4;
                            repeat = true;
                            break;
                        }
                        case ' ': {
                            flags |= 8;
                            repeat = true;
                            break;
                        }
                        case '#': {
                            flags |= 0x20;
                            repeat = true;
                            break;
                        }
                        case '0': {
                            flags |= 1;
                            repeat = true;
                            break;
                        }
                        default: {
                            repeat = false;
                        }
                    }
                } while (repeat);
                int field_width = -1;
                if (PrintfWriter.isDigit(fmt[ifmt])) {
                    field_width = 0;
                    while (PrintfWriter.isDigit(fmt[ifmt])) {
                        field_width = field_width * 10 + (fmt[ifmt++] - 48);
                    }
                } else if (fmt[ifmt] == '*') {
                    if ((field_width = (int)this.getLong(va_arg[iarg++])) < 0) {
                        field_width = -field_width;
                        flags |= 0x10;
                    }
                    ++ifmt;
                }
                int precision = -1;
                if (fmt[ifmt] == '.') {
                    if (PrintfWriter.isDigit(fmt[++ifmt])) {
                        precision = 0;
                        while (PrintfWriter.isDigit(fmt[ifmt])) {
                            precision = precision * 10 + (fmt[ifmt++] - 48);
                        }
                    } else if (fmt[ifmt] == '*') {
                        precision = (int)this.getLong(va_arg[iarg++]);
                        ++ifmt;
                    }
                    if (precision < 0) {
                        precision = 0;
                    }
                }
                switch (fmt[ifmt]) {
                    case 's': {
                        offset = this.formatStr(buffer, offset, va_arg[iarg++], field_width, precision, flags);
                        break;
                    }
                    case 'c': {
                        int pad;
                        int n = pad = (flags & 1) != 0 ? 48 : 32;
                        if ((flags & 0x10) == 0) {
                            while (--field_width > 0) {
                                buffer[offset++] = pad;
                            }
                        }
                        buffer[offset++] = (char)(this.getLong(va_arg[iarg++]) & 0xFFFFL);
                        while (--field_width > 0) {
                            buffer[offset++] = pad;
                        }
                        break;
                    }
                    case 'd': 
                    case 'i': {
                        flags |= 2;
                    }
                    case 'u': {
                        offset = this.formatInt(buffer, offset, va_arg[iarg++], base, field_width, precision, flags);
                        break;
                    }
                    case 'o': {
                        base = 8L;
                        offset = this.formatInt(buffer, offset, va_arg[iarg++], base, field_width, precision, flags);
                        break;
                    }
                    case 'X': {
                        flags |= 0x40;
                    }
                    case 'x': {
                        base = 16L;
                        offset = this.formatInt(buffer, offset, va_arg[iarg++], base, field_width, precision, flags);
                        break;
                    }
                    case 'E': {
                        flags |= 0x40;
                    }
                    case 'e': {
                        flags |= 0x80;
                    }
                    case 'f': {
                        flags |= 2;
                        if (precision <= 0) {
                            precision = 6;
                        }
                        offset = this.formatFlt(buffer, offset, va_arg[iarg++], field_width, precision, flags);
                        break;
                    }
                    case 'G': {
                        flags |= 0x40;
                    }
                    case 'g': {
                        flags |= 0x100;
                        flags |= 2;
                        if (precision <= 0) {
                            precision = 6;
                        }
                        offset = this.formatFlt(buffer, offset, va_arg[iarg++], field_width, precision, flags);
                        break;
                    }
                    case '%': {
                        buffer[offset++] = 37;
                        break;
                    }
                    case 'b': {
                        offset = this.formatStr(buffer, offset, Long.toBinaryString(this.getLong(va_arg[iarg++])), field_width, precision, flags);
                        break;
                    }
                    case 'p': {
                        base = 16L;
                        buffer[offset++] = 64;
                        if (field_width <= 0) {
                            field_width = 8;
                            flags |= 1;
                        }
                        offset = this.formatInt(buffer, offset, new Integer(va_arg[iarg++].hashCode()), base, field_width, precision, flags);
                        break;
                    }
                    default: {
                        buffer[offset++] = 37;
                        if (ifmt < fmt.length) {
                            buffer[offset++] = fmt[ifmt];
                            break;
                        }
                        --ifmt;
                    }
                }
            }
            ++ifmt;
        }
        return offset;
    }

    public String toString() {
        return this.out.toString();
    }

    static {
        try {
            LONG_MASK = Long.parseLong("FFFFFFFF", 16);
        }
        catch (NumberFormatException ex) {
            logger.warningT(tracer, "internal", "Exception was thrown " + ex.getMessage());
            LoggingHelper.traceThrowable(400, tracer, "internal", ex);
        }
        HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    public static final class Arg {
        protected Vector args = new Vector();

        protected Object[] getArgs() {
            Object[] obj = new Object[this.args.size()];
            this.args.copyInto(obj);
            return obj;
        }

        public Arg add(String value) {
            this.args.addElement(value);
            return this;
        }

        public Arg add(char[] value) {
            this.args.addElement(value);
            return this;
        }

        public Arg add(char value) {
            this.args.addElement(new Character(value));
            return this;
        }

        public Arg add(int value) {
            this.args.addElement(new Integer(value));
            return this;
        }

        public Arg add(long value) {
            this.args.addElement(new Long(value));
            return this;
        }

        public Arg add(double value) {
            this.args.addElement(new Double(value));
            return this;
        }

        public Arg add(float value) {
            this.args.addElement(new Double(value));
            return this;
        }

        public Arg add(Object value) {
            this.args.addElement(value);
            return this;
        }
    }
}

