/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.util;

public class MessageID {
    static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String HEXSTRING = "0123456789ABCDEFabcdef";

    protected static final String toHexString(byte[] value) {
        char[] s = new char[value.length * 2 + 1];
        int i = 0;
        int k = 0;
        while (i < value.length) {
            s[k++] = HEXCHARS[value[i] >> 4 & 0xF];
            s[k++] = HEXCHARS[value[i] & 0xF];
            if (k == 16) {
                s[k++] = 45;
            }
            ++i;
        }
        return new String(s);
    }

    protected static final byte[] fromHexString(String value) {
        if (value.indexOf("ID:") == 0) {
            value = value.substring(3);
        }
        char[] s = value.toCharArray();
        int l = 0;
        int i = 0;
        while (i < s.length) {
            if (HEXSTRING.indexOf(s[i]) >= 0) {
                s[l++] = s[i];
            }
            ++i;
        }
        byte[] b = new byte[(l + 1) / 2];
        int i2 = 0;
        while (i2 < l) {
            byte d = (byte)Character.digit(s[i2], 16);
            int n = i2 >> 1;
            b[n] = (byte)(b[n] | d << (1 - (i2 & 1) << 2));
            ++i2;
        }
        return b;
    }

    public static final byte[] toBytes(long messageIDBase, long messageIDCounter) {
        byte[] msgid = new byte[14];
        int position = 0;
        msgid[position++] = (byte)(messageIDBase >> 56 & 0xFFL);
        msgid[position++] = (byte)(messageIDBase >> 48 & 0xFFL);
        msgid[position++] = (byte)(messageIDBase >> 40 & 0xFFL);
        msgid[position++] = (byte)(messageIDBase >> 32 & 0xFFL);
        msgid[position++] = (byte)(messageIDBase >> 24 & 0xFFL);
        msgid[position++] = (byte)(messageIDBase >> 16 & 0xFFL);
        msgid[position++] = (byte)(messageIDBase >> 8 & 0xFFL);
        msgid[position++] = (byte)(messageIDBase & 0xFFL);
        msgid[position++] = (byte)(messageIDCounter >> 40 & 0xFFL);
        msgid[position++] = (byte)(messageIDCounter >> 32 & 0xFFL);
        msgid[position++] = (byte)(messageIDCounter >> 24 & 0xFFL);
        msgid[position++] = (byte)(messageIDCounter >> 16 & 0xFFL);
        msgid[position++] = (byte)(messageIDCounter >> 8 & 0xFFL);
        msgid[position++] = (byte)(messageIDCounter & 0xFFL);
        return msgid;
    }

    public static final byte[] toBytes(String messageID) {
        byte[] msgid = MessageID.fromHexString(messageID);
        if (msgid == null || msgid.length != 14) {
            throw new IllegalArgumentException();
        }
        return msgid;
    }

    public static final String toString(long messageIDBase, long messageIDCounter) {
        return MessageID.toHexString(MessageID.toBytes(messageIDBase, messageIDCounter));
    }

    public static final String toString(byte[] messageID) {
        return MessageID.toHexString(messageID);
    }

    private MessageID() {
    }
}

