/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.util;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public final class JNDIHelper {
    private InitialContext initialContext;
    private final Hashtable replicatedEnv = new Hashtable(3);
    private static final JNDIHelper instance = new JNDIHelper();

    private JNDIHelper() {
        this.replicatedEnv.put("Replicate", "true");
        this.replicatedEnv.put("domain", "true");
    }

    public static JNDIHelper getInstance() {
        return instance;
    }

    public synchronized InitialContext getReplicatedInitialContext() throws NamingException {
        if (this.initialContext == null) {
            this.initialContext = new InitialContext(this.replicatedEnv);
        }
        return this.initialContext;
    }

    private Context getContext(String name) throws NamingException {
        Context result = null;
        try {
            result = (Context)this.getReplicatedInitialContext().lookup(name);
        }
        catch (NameNotFoundException e) {
            result = this.getReplicatedInitialContext().createSubcontext(name);
        }
        return result;
    }

    public Context getFactoriesContext() throws NamingException {
        return this.getContext("jmsfactory/");
    }

    public Context getQueuesContext() throws NamingException {
        return this.getContext("jmsqueues/");
    }

    public Context getTopicsContext() throws NamingException {
        return this.getContext("jmstopics/");
    }

    public void bind(String contextName, Object object) throws NamingException {
        InitialContext context = null;
        try {
            context = this.getReplicatedInitialContext();
            context.rebind(contextName, object);
        }
        catch (NameNotFoundException ne) {
            context.bind(contextName, object);
        }
    }

    public void unbind(String contextName) throws NamingException {
        this.getReplicatedInitialContext().unbind(contextName);
    }
}

