/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.util;

import com.sap.jms.util.PriorityQueueItem;

public class FixedPriorityQueue {
    public final int PRIORITY_LEVELS = 10;
    public static final int LOWEST_PRIORITY = 0;
    public final int HIGHEST_PRIORITY;
    protected int count;
    protected int priorityLevels = 10;
    protected PriorityQueueItem first = null;
    protected PriorityQueueItem last = null;
    protected int limit;
    protected PriorityQueueItem[] lastPointers = null;

    public FixedPriorityQueue() {
        this.priorityLevels = 10;
        this.HIGHEST_PRIORITY = this.priorityLevels - 1;
        this.setLimit(0);
        this.lastPointers = new PriorityQueueItem[this.priorityLevels];
    }

    public FixedPriorityQueue(int priorityLevels) {
        this(0, priorityLevels);
    }

    public FixedPriorityQueue(int limit, int priorityLevels) {
        this.priorityLevels = priorityLevels;
        this.HIGHEST_PRIORITY = priorityLevels - 1;
        this.setLimit(limit);
        this.lastPointers = new PriorityQueueItem[priorityLevels];
    }

    public synchronized void enqueueWithPriority(PriorityQueueItem item) {
        int priority = item.getPriority();
        PriorityQueueItem priorityLastItem = this.lastPointers[priority];
        if (priorityLastItem == null) {
            PriorityQueueItem higherPriority = null;
            int i = priority + 1;
            while (i < this.priorityLevels) {
                higherPriority = this.lastPointers[i];
                if (higherPriority != null) break;
                ++i;
            }
            if (higherPriority != null) {
                PriorityQueueItem lowerPriority = higherPriority.getNextPriorityQueueItem();
                if (lowerPriority != null) {
                    item.setNextPriorityQueueItem(lowerPriority);
                } else {
                    item.setNextPriorityQueueItem(null);
                    this.last = item;
                }
                higherPriority.setNextPriorityQueueItem(item);
            } else {
                item.setNextPriorityQueueItem(this.first);
                if (this.first == null) {
                    this.last = item;
                }
                this.first = item;
            }
        } else {
            PriorityQueueItem next = priorityLastItem.getNextPriorityQueueItem();
            priorityLastItem.setNextPriorityQueueItem(item);
            if (next == null) {
                this.last = item;
            }
            item.setNextPriorityQueueItem(next);
        }
        this.lastPointers[priority] = item;
        ++this.count;
    }

    protected PriorityQueueItem getLast() {
        int i = 0;
        while (i < this.priorityLevels) {
            PriorityQueueItem lastItem = this.lastPointers[i];
            if (lastItem != null) {
                return lastItem;
            }
            ++i;
        }
        return null;
    }

    public synchronized PriorityQueueItem dequeue() {
        if (this.count == 0) {
            return null;
        }
        int priority = this.first.getPriority();
        if (this.lastPointers[priority] == this.first) {
            this.lastPointers[priority] = null;
        }
        PriorityQueueItem temp = this.first;
        this.first = this.first.getNextPriorityQueueItem();
        --this.count;
        temp.clearItem();
        return temp;
    }

    public void clear() {
        this.first = null;
        this.count = 0;
        int i = this.priorityLevels - 1;
        while (i >= 0) {
            this.lastPointers[i] = null;
            --i;
        }
    }

    public Object clone() {
        return this.clone_();
    }

    private Object clone_() {
        PriorityQueueItem newFirst;
        FixedPriorityQueue result = null;
        try {
            result = (FixedPriorityQueue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
        if (this.count == 0) {
            return result;
        }
        PriorityQueueItem temp = this.first;
        PriorityQueueItem newItem = newFirst = (PriorityQueueItem)this.first.clone();
        PriorityQueueItem[] newPriorityPointers = new PriorityQueueItem[this.priorityLevels];
        this.setNewPriorityMark(temp, newPriorityPointers, newFirst);
        int i = 1;
        while (i < this.count) {
            temp = temp.getNextPriorityQueueItem();
            PriorityQueueItem tempCloning = (PriorityQueueItem)temp.clone();
            this.setNewPriorityMark(temp, newPriorityPointers, tempCloning);
            newItem.setNextPriorityQueueItem(tempCloning);
            newItem = tempCloning;
            ++i;
        }
        newItem.setNextPriorityQueueItem(null);
        result.first = newFirst;
        result.lastPointers = newPriorityPointers;
        return result;
    }

    private void setNewPriorityMark(PriorityQueueItem item, PriorityQueueItem[] newPriorityPointers, PriorityQueueItem tempCloning) {
        int i = 0;
        while (i < this.priorityLevels) {
            if (item == this.lastPointers[i]) {
                newPriorityPointers[i] = tempCloning;
            }
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FixedPriorityQueue)) {
            return false;
        }
        if (this.count != ((FixedPriorityQueue)obj).count) {
            return false;
        }
        if (this.count == 0) {
            return true;
        }
        PriorityQueueItem currentTemp = this.first;
        PriorityQueueItem checkedTemp = ((FixedPriorityQueue)obj).first;
        int i = 0;
        while (i < this.count) {
            if (!currentTemp.equals(checkedTemp)) {
                return false;
            }
            currentTemp = currentTemp.getNextPriorityQueueItem();
            checkedTemp = checkedTemp.getNextPriorityQueueItem();
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return 1;
    }

    public boolean containsItem(PriorityQueueItem item) {
        PriorityQueueItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return true;
            }
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return false;
    }

    public PriorityQueueItem getItem(PriorityQueueItem item) {
        PriorityQueueItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return temp;
            }
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return null;
    }

    public PriorityQueueItem getItem(int index) {
        if (index >= this.count || index < 0) {
            return null;
        }
        PriorityQueueItem temp = this.first;
        int i = 0;
        while (i < index) {
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return temp;
    }

    public PriorityQueueItem getFirstItem() {
        return this.first;
    }

    public PriorityQueueItem getLastItem() {
        return this.last;
    }

    public int indexOfItem(PriorityQueueItem item) {
        PriorityQueueItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return i;
            }
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return -1;
    }

    public int lastIndexOfItem(PriorityQueueItem item) {
        PriorityQueueItem temp = this.first;
        int lastIndex = -1;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                lastIndex = i;
            }
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return lastIndex;
    }

    public boolean isFull() {
        return this.count >= this.limit;
    }

    public PriorityQueueItem[] toItemArray() {
        PriorityQueueItem[] array = new PriorityQueueItem[this.count];
        PriorityQueueItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            array[i] = temp;
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return array;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append(" [Size = " + this.count + "; First = " + this.first + "; Limit = " + this.limit + "; Priorities = " + this.priorityLevels + "]\n[");
        PriorityQueueItem temp = this.first;
        while (temp != null) {
            s.append(temp + " : " + temp.getPriority() + ", ");
            temp = temp.getNextPriorityQueueItem();
        }
        s.append("]");
        return s.toString();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit <= 0 ? Integer.MAX_VALUE : limit;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }
}

