/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.util;

import com.sap.jms.util.PriorityQueueItem;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class FixedPriorityDoublyLinkedQueue {
    public static final int LOWEST_PRIORITY = 0;
    public final int HIGHEST_PRIORITY;
    protected int count;
    protected int priorityLevels = 1;
    protected PriorityQueueItem first = null;
    protected PriorityQueueItem last = null;
    protected PriorityQueueItem[] lastPointers = null;

    public FixedPriorityDoublyLinkedQueue(int priorityLevels) {
        this.priorityLevels = priorityLevels;
        this.HIGHEST_PRIORITY = priorityLevels - 1;
        this.lastPointers = new PriorityQueueItem[priorityLevels];
    }

    public void enqueueWithPriority(PriorityQueueItem item, int priority) {
        PriorityQueueItem priorityLastItem = this.lastPointers[priority];
        if (priorityLastItem == null) {
            PriorityQueueItem higherPriority = null;
            int i = priority + 1;
            while (i < this.priorityLevels) {
                higherPriority = this.lastPointers[i];
                if (higherPriority != null) break;
                ++i;
            }
            if (higherPriority != null) {
                item.setPreviousPriorityQueueItem(higherPriority);
                PriorityQueueItem next = higherPriority.getNextPriorityQueueItem();
                if (next == null) {
                    this.last = item;
                } else {
                    next.setPreviousPriorityQueueItem(item);
                }
                item.setNextPriorityQueueItem(next);
                higherPriority.setNextPriorityQueueItem(item);
            } else {
                item.setPreviousPriorityQueueItem(null);
                if (this.first == null) {
                    this.last = item;
                } else {
                    this.first.setPreviousPriorityQueueItem(item);
                }
                item.setNextPriorityQueueItem(this.first);
                this.first = item;
            }
        } else {
            item.setPreviousPriorityQueueItem(priorityLastItem);
            PriorityQueueItem next = priorityLastItem.getNextPriorityQueueItem();
            if (next == null) {
                this.last = item;
            } else {
                next.setPreviousPriorityQueueItem(item);
            }
            item.setNextPriorityQueueItem(next);
            priorityLastItem.setNextPriorityQueueItem(item);
        }
        this.lastPointers[priority] = item;
        ++this.count;
    }

    public void insert(PriorityQueueItem item, int priority) {
        PriorityQueueItem next;
        PriorityQueueItem prev;
        block8: {
            prev = null;
            int i = priority + 1;
            while (i < this.priorityLevels) {
                prev = this.lastPointers[i];
                if (prev != null) break;
                ++i;
            }
            if (prev == null) {
                if (this.first == null) {
                    this.first = item;
                    this.last = item;
                    this.lastPointers[priority] = item;
                    ++this.count;
                    return;
                }
                if (this.first.compareTo(item) > 0) {
                    item.setPreviousPriorityQueueItem(null);
                    item.setNextPriorityQueueItem(this.first);
                    this.first.setPreviousPriorityQueueItem(item);
                    this.first = item;
                    if (this.first.getPriority() != priority) {
                        this.lastPointers[priority] = item;
                    }
                    ++this.count;
                    return;
                }
                prev = this.first;
            }
            next = prev.getNextPriorityQueueItem();
            do {
                if (next.compareTo(item) > 0) {
                    prev = next.getPreviousPriorityQueueItem();
                    next.setPreviousPriorityQueueItem(item);
                    break block8;
                }
                prev = next;
            } while ((next = next.getNextPriorityQueueItem()) != null);
            this.last = item;
        }
        item.setPreviousPriorityQueueItem(prev);
        item.setNextPriorityQueueItem(next);
        prev.setNextPriorityQueueItem(item);
        if (next == null || next.getPriority() != priority) {
            this.lastPointers[priority] = item;
        }
        ++this.count;
    }

    public PriorityQueueItem dequeue() {
        if (this.count == 0) {
            return null;
        }
        int priority = this.first.getPriority();
        if (this.lastPointers[priority] == this.first) {
            this.lastPointers[priority] = null;
        }
        PriorityQueueItem temp = this.first;
        this.first = this.first.getNextPriorityQueueItem();
        if (this.first != null) {
            this.first.setPreviousPriorityQueueItem(null);
        }
        --this.count;
        if (this.count == 0) {
            this.last = null;
            this.first = null;
        }
        temp.clearItem();
        return temp;
    }

    public PriorityQueueItem deleteLastItem() {
        if (this.count == 0) {
            return null;
        }
        if (this.count == 1) {
            return this.dequeue();
        }
        int priority = this.last.getPriority();
        PriorityQueueItem temp = this.last;
        PriorityQueueItem beforeLast = this.last.getPreviousPriorityQueueItem();
        this.lastPointers[priority] = beforeLast.getPriority() != priority ? null : beforeLast;
        this.last = beforeLast;
        this.last.setNextPriorityQueueItem(null);
        --this.count;
        temp.clearItem();
        return temp;
    }

    public void deleteItem(PriorityQueueItem messageItem) {
        PriorityQueueItem prev = messageItem.getPreviousPriorityQueueItem();
        PriorityQueueItem next = messageItem.getNextPriorityQueueItem();
        int priority = messageItem.getPriority();
        if (this.lastPointers[priority] == messageItem) {
            PriorityQueueItem previous = messageItem.getPreviousPriorityQueueItem();
            this.lastPointers[priority] = previous != null && previous.getPriority() == priority ? previous : null;
        }
        if (prev == null) {
            this.first = next;
        } else {
            prev.setNextPriorityQueueItem(next);
        }
        if (next == null) {
            this.last = prev;
            if (this.last != null) {
                this.last.setNextPriorityQueueItem(null);
            }
        } else {
            next.setPreviousPriorityQueueItem(prev);
        }
        messageItem.clearItem();
        --this.count;
    }

    public PriorityQueueItem getLastItem() {
        return this.last;
    }

    public PriorityQueueItem getLastItem(int priority) {
        return this.lastPointers[priority];
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.count = 0;
        int i = this.priorityLevels - 1;
        while (i >= 0) {
            this.lastPointers[i] = null;
            --i;
        }
    }

    public Object clone() {
        return this.clone_();
    }

    private Object clone_() {
        PriorityQueueItem newFirst;
        FixedPriorityDoublyLinkedQueue result = null;
        try {
            result = (FixedPriorityDoublyLinkedQueue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
        if (this.count == 0) {
            return result;
        }
        PriorityQueueItem temp = this.first;
        PriorityQueueItem newItem = newFirst = (PriorityQueueItem)this.first.clone();
        PriorityQueueItem[] newPriorityPointers = new PriorityQueueItem[this.priorityLevels];
        this.setClonedPriorityMark(temp, newPriorityPointers, newFirst);
        int i = 1;
        while (i < this.count) {
            temp = temp.getNextPriorityQueueItem();
            PriorityQueueItem tempCloning = (PriorityQueueItem)temp.clone();
            this.setClonedPriorityMark(temp, newPriorityPointers, tempCloning);
            newItem.setNextPriorityQueueItem(tempCloning);
            newItem = tempCloning;
            ++i;
        }
        newItem.setNextPriorityQueueItem(null);
        result.first = newFirst;
        result.lastPointers = newPriorityPointers;
        return result;
    }

    private void setClonedPriorityMark(PriorityQueueItem item, PriorityQueueItem[] newPriorityPointers, PriorityQueueItem tempCloning) {
        int i = 0;
        while (i < this.priorityLevels) {
            if (item == this.lastPointers[i]) {
                newPriorityPointers[i] = tempCloning;
            }
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FixedPriorityDoublyLinkedQueue)) {
            return false;
        }
        if (this.count != ((FixedPriorityDoublyLinkedQueue)obj).count) {
            return false;
        }
        if (this.count == 0) {
            return true;
        }
        PriorityQueueItem currentTemp = this.first;
        PriorityQueueItem checkedTemp = ((FixedPriorityDoublyLinkedQueue)obj).first;
        int i = 0;
        while (i < this.count) {
            if (!currentTemp.equals(checkedTemp)) {
                return false;
            }
            currentTemp = currentTemp.getNextPriorityQueueItem();
            checkedTemp = checkedTemp.getNextPriorityQueueItem();
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return 1;
    }

    public boolean containsItem(PriorityQueueItem item) {
        PriorityQueueItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return true;
            }
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return false;
    }

    public PriorityQueueItem getItem(PriorityQueueItem item) {
        PriorityQueueItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return temp;
            }
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return null;
    }

    public PriorityQueueItem getItem(int index) {
        if (index >= this.count || index < 0) {
            return null;
        }
        PriorityQueueItem temp = this.first;
        int i = 0;
        while (i < index) {
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return temp;
    }

    public PriorityQueueItem getFirstItem() {
        return this.first;
    }

    public PriorityQueueItem getFirstItem(int priority) {
        if (this.lastPointers[priority] == null) {
            return null;
        }
        PriorityQueueItem prev = null;
        int i = priority + 1;
        while (i < this.priorityLevels) {
            prev = this.lastPointers[i];
            if (prev != null) break;
            ++i;
        }
        if (prev != null) {
            return prev.getNextPriorityQueueItem();
        }
        return this.first;
    }

    public int indexOfItem(PriorityQueueItem item) {
        PriorityQueueItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                return i;
            }
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return -1;
    }

    public int lastIndexOfItem(PriorityQueueItem item) {
        PriorityQueueItem temp = this.first;
        int lastIndex = -1;
        int i = 0;
        while (i < this.count) {
            if (temp.equals(item)) {
                lastIndex = i;
            }
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return lastIndex;
    }

    public PriorityQueueItem[] toItemArray() {
        PriorityQueueItem[] array = new PriorityQueueItem[this.count];
        PriorityQueueItem temp = this.first;
        int i = 0;
        while (i < this.count) {
            array[i] = temp;
            temp = temp.getNextPriorityQueueItem();
            ++i;
        }
        return array;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append(" [Size = " + this.count + "; First = " + this.first + "; Priorities = " + this.priorityLevels + "]\n[");
        PriorityQueueItem temp = this.first;
        while (temp != null) {
            s.append(temp + " : " + temp.getPriority() + ", ");
            temp = temp.getNextPriorityQueueItem();
        }
        s.append("]");
        return s.toString();
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration elements() {
        return new QueueEnumeration();
    }

    public Enumeration elements(int priority) {
        return new PriorityEnumeration(priority);
    }

    protected class PriorityEnumeration
    implements Enumeration {
        private PriorityQueueItem next;
        private int priority;

        protected PriorityEnumeration(int priority) {
            this.priority = priority;
            this.next = FixedPriorityDoublyLinkedQueue.this.getFirstItem(priority);
        }

        public boolean hasMoreElements() {
            return this.next != null && this.next.getPriority() == this.priority;
        }

        public Object nextElement() {
            PriorityQueueItem itemToReturn = null;
            if (this.hasMoreElements()) {
                itemToReturn = this.next;
                this.next = this.next.getNextPriorityQueueItem();
                return itemToReturn;
            }
            throw new NoSuchElementException();
        }
    }

    protected class QueueEnumeration
    implements Enumeration {
        private PriorityQueueItem next;
        private int counter;

        protected QueueEnumeration() {
            this.next = FixedPriorityDoublyLinkedQueue.this.first;
            this.counter = 0;
        }

        public boolean hasMoreElements() {
            return this.counter < FixedPriorityDoublyLinkedQueue.this.count;
        }

        public Object nextElement() {
            PriorityQueueItem itemToReturn = null;
            if (this.next != null) {
                itemToReturn = this.next;
                this.next = this.next.getNextPriorityQueueItem();
                ++this.counter;
                return itemToReturn;
            }
            throw new NoSuchElementException();
        }
    }
}

