/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.serialization;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class JMSInputStream
extends ObjectInputStream {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.protocol.serialization.JMSInputStream");
    private static final Category logger = Category.getCategory((String)"/System/Server");
    private ClassLoader appClassLoader = null;

    public JMSInputStream(InputStream inStream, ClassLoader classLoader) throws IOException {
        super(inStream);
        this.appClassLoader = classLoader;
    }

    public Class resolveClass(ObjectStreamClass objClass) throws IOException, ClassNotFoundException {
        try {
            return this.appClassLoader.loadClass(objClass.getName());
        }
        catch (ClassNotFoundException ex) {
            logger.warningT(tracer, "resolveClass", "Exception was thrown " + ex.getMessage() + " when trying to load class, will use objClass.forClass().");
            return objClass.forClass();
        }
    }
}

