/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferOverflowException;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import javax.jms.JMSException;
import javax.transaction.xa.Xid;

public class XARecoverResponse
extends PacketImpl {
    public static final byte TYPE_ID = -120;

    public XARecoverResponse() {
    }

    public XARecoverResponse(Xid[] xids) throws JMSException {
        super((byte)-120, XARecoverResponse.getSize(xids));
        this.setPosition(0);
        this.writeInt(xids.length);
        int i = 0;
        while (i < xids.length) {
            this.writeByteArray(xids[i].getBranchQualifier());
            this.writeByteArray(xids[i].getGlobalTransactionId());
            this.writeInt(xids[i].getFormatId());
            ++i;
        }
    }

    private static int getSize(Xid[] xids) {
        int sum = 4;
        int i = 0;
        while (i < xids.length) {
            sum += xids[i].getBranchQualifier().length + xids[i].getGlobalTransactionId().length;
            ++i;
        }
        return sum + 3 * xids.length * 4;
    }

    public Xid[] getXIDs() throws BufferUnderflowException {
        try {
            this.setPosition(0);
        }
        catch (BufferOverflowException boe) {
            BufferUnderflowException bue = new BufferUnderflowException();
            bue.setLinkedException((Exception)((Object)boe));
            throw bue;
        }
        Xid[] xids = new Xid[this.readInt()];
        int i = 0;
        while (i < xids.length) {
            xids[i] = new XidImpl(this.readByteArray(), this.readByteArray(), this.readInt());
            ++i;
        }
        return xids;
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-120, "XARecoverResponse");
    }

    private class XidImpl
    implements Xid {
        byte[] branchQ = null;
        byte[] globalTrID = null;
        int formatID = 0;

        XidImpl(byte[] branchQ, byte[] globalTrID, int formatID) {
            this.branchQ = branchQ;
            this.globalTrID = globalTrID;
            this.formatID = formatID;
        }

        public byte[] getGlobalTransactionId() {
            return this.globalTrID;
        }

        public byte[] getBranchQualifier() {
            return this.branchQ;
        }

        public int getFormatId() {
            return this.formatID;
        }
    }
}

