/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferOverflowException;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketWithXID;
import javax.jms.JMSException;
import javax.transaction.xa.Xid;

class XABasePacket
extends PacketImpl
implements PacketWithXID {
    protected static final int POS_FLAGS = 0;
    protected static final int POS_XID = 4;

    protected XABasePacket() {
    }

    protected XABasePacket(byte typeID, boolean hasSessionID, Xid xid, int flags) throws JMSException {
        super(typeID, (hasSessionID ? 4 : 0) + 4 + xid.getBranchQualifier().length + xid.getGlobalTransactionId().length + 12);
        if (hasSessionID) {
            this.setInt(4, flags);
            this.setXID(8, xid);
        } else {
            this.setInt(0, flags);
            this.setXID(4, xid);
        }
    }

    protected XABasePacket(byte typeID, Xid xid, int flags) throws JMSException {
        this(typeID, false, xid, flags);
    }

    protected XABasePacket(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    protected void setXID(int pos, Xid xid) throws BufferOverflowException {
        this.setByteArray(pos, xid.getGlobalTransactionId());
        this.setByteArray(pos += 4 + xid.getGlobalTransactionId().length, xid.getBranchQualifier());
        this.setInt(pos += 4 + xid.getBranchQualifier().length, xid.getFormatId());
    }

    public Xid getXID() throws BufferUnderflowException {
        return this.getXID(4);
    }

    public int getFlags() throws BufferUnderflowException {
        return this.getFlags(0);
    }

    protected int getFlags(int pos) throws BufferUnderflowException {
        return this.getInt(pos);
    }

    protected Xid getXID(int pos) throws BufferUnderflowException {
        final byte[] globalTrID = this.getByteArray(pos);
        final byte[] branchQ = this.getByteArray(pos += 4 + globalTrID.length);
        final int flags = this.getInt(pos += 4 + branchQ.length);
        return new Xid(){
            byte[] gTrID;
            byte[] brID;
            int fl;
            {
                this.gTrID = globalTrID;
                this.brID = branchQ;
                this.fl = flags;
            }

            public int getFormatId() {
                return flags;
            }

            public byte[] getGlobalTransactionId() {
                return this.gTrID;
            }

            public byte[] getBranchQualifier() {
                return branchQ;
            }
        };
    }
}

