/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferOverflowException;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithConnectionID;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class SubscriptionRemoveRequest
extends PacketImpl
implements PacketWithConnectionID {
    public static final byte TYPE_ID = -82;
    static final int POS_CONNECTION_ID = 0;
    static final int POS_SUBSCRIPTION_NAME = 8;
    static final int SIZE = 8;

    public SubscriptionRemoveRequest() {
    }

    public SubscriptionRemoveRequest(String subscription_name) throws JMSException {
        super((byte)-82, 8 + PacketImpl.strlenUTF8(subscription_name));
        this.setUTF8(8, subscription_name);
    }

    public SubscriptionRemoveRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public String getSubscriptionName() throws BufferUnderflowException {
        return this.getString(8);
    }

    public void setConnectionID(long connection_id) throws BufferOverflowException {
        this.setLong(0, connection_id);
    }

    public long getConnectionID() throws BufferUnderflowException {
        return this.getLong(0);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        out.println("------------------------------ Subscription Content ----------------------------");
        args.add("SubscriptionName:");
        args.add(this.getSubscriptionName());
        out.printf("%-30s %-s\n", args);
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-82, "SubscriptionRemoveRequest");
    }
}

