/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithConsumerID;
import com.sap.jms.protocol.PacketWithDestinationID;
import javax.jms.JMSException;

public class StartMessageDeliveryRequest
extends PacketImpl
implements PacketWithDestinationID,
PacketWithConsumerID {
    public static final byte TYPE_ID = -103;
    private static final int POS_DESTINATION_ID = 0;
    private static final int POS_CONSUMER_ID = 4;
    private static final int POS_CONSUMER_LIMIT = 12;
    protected static final int SIZE = 16;

    public StartMessageDeliveryRequest() {
    }

    public StartMessageDeliveryRequest(int destinationID, long consumerID, int consumerLimit) throws JMSException {
        super((byte)-103, 16);
        this.setInt(0, destinationID);
        this.setLong(4, consumerID);
        this.setInt(12, consumerLimit);
    }

    public StartMessageDeliveryRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public int getDestinationID() throws BufferUnderflowException {
        return this.getInt(0);
    }

    public long getConsumerID() throws BufferUnderflowException {
        return this.getLong(4);
    }

    public int getConsumerLimit() throws BufferUnderflowException {
        return this.getInt(12);
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-103, "StartMessageDeliveryRequest");
    }
}

