/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithConnectionIDAndSessionIDImpl;
import com.sap.jms.protocol.PacketWithConsumerIDsAndMessageCounts;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class SessionRecoverRequest
extends PacketWithConnectionIDAndSessionIDImpl
implements PacketWithConsumerIDsAndMessageCounts {
    public static final byte TYPE_ID = -25;
    private static final int POS_CONSUMER_IDS = 12;

    public SessionRecoverRequest() {
    }

    public SessionRecoverRequest(long client_id, int session_id, long[] consumer_ids, int[] message_counts, int length) throws JMSException {
        this(-25, client_id, session_id, consumer_ids, message_counts, length);
    }

    protected SessionRecoverRequest(byte TYPE_ID, long client_id, int session_id, long[] consumer_ids, int[] message_counts, int length) throws JMSException {
        super(TYPE_ID, 12 + length * 8 + (length + 2) * 4, client_id, session_id);
        this.setPosition(12);
        this.writeInt(length);
        int i = 0;
        while (i < length) {
            this.writeLong(consumer_ids[i]);
            ++i;
        }
        this.writeInt(length);
        int i2 = 0;
        while (i2 < length) {
            this.writeInt(message_counts[i2]);
            ++i2;
        }
    }

    public SessionRecoverRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public long[] getConsumerIDs() throws JMSException {
        this.setPosition(12);
        long[] consumerIDs = new long[this.readInt()];
        int i = 0;
        while (i < consumerIDs.length) {
            consumerIDs[i] = this.readLong();
            ++i;
        }
        return consumerIDs;
    }

    public int[] getMessageCounts() throws JMSException {
        this.setPosition(12);
        int numConsumerIDs = this.readInt();
        this.setPosition(16 + numConsumerIDs * 8);
        int[] messageCounts = new int[this.readInt()];
        int i = 0;
        while (i < messageCounts.length) {
            messageCounts[i] = this.readInt();
            ++i;
        }
        return messageCounts;
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        out.println("--------------------------------- Recover Content -----------------------------------");
        long[] array = this.getConsumerIDs();
        int[] message_counts = this.getMessageCounts();
        int j = 0;
        while (j < message_counts.length) {
            args.add("MessageCounts(");
            args.add(j + 1);
            args.add("):");
            args.add(message_counts[j]);
            out.printf("%-15s %-4d %-11s %-d\n", args);
            ++j;
        }
        int i = 0;
        while (i < array.length) {
            args.add("ConsumerIDs(");
            args.add(i + 1);
            args.add("):");
            args.add(array[i]);
            out.printf("%-15s  %-4d %-11s %-x\n", args);
            ++i;
        }
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-25, "SessionRecoverRequest");
    }
}

