/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithConnectionIDImpl;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class SessionCreateRequest
extends PacketWithConnectionIDImpl {
    public static final byte TYPE_ID = -17;
    static final int POS_IS_TRANSACTED = 8;
    static final int SIZE = 9;

    public SessionCreateRequest() {
    }

    public SessionCreateRequest(long client_id, byte session_mode, boolean is_xa) throws JMSException {
        super((byte)-17, 9, client_id);
        byte flags = (byte)(session_mode & 0xF | (is_xa ? 16 : 0));
        this.setByte(8, flags);
    }

    public SessionCreateRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public byte getMode() throws BufferUnderflowException {
        return (byte)(this.getByte(8) & 0xF);
    }

    public boolean isTransacted() throws BufferUnderflowException {
        return (this.getByte(8) & 0xF) == 0;
    }

    public boolean isXA() throws BufferUnderflowException {
        return (this.getByte(8) & 0x10) != 0;
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        out.println("------------------------------ Session Content ---------------------------------");
        args.add("IsTransacted:");
        args.add(this.isTransacted() ? "true" : "false");
        out.printf("%-30s %-s\n", args);
        args.add("IsXA:");
        args.add(this.isXA() ? "true" : "false");
        out.printf("%-30s %-s\n", args);
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-17, "SessionCreateRequest");
    }
}

