/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.notification.StackTraceException;
import com.sap.jms.util.PrintfWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ResourceAllocationException;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionRolledBackException;

public class ServerExceptionResponse
extends PacketImpl {
    public static final byte EXCEPTION = 0;
    public static final byte JMS_EXCEPTION = 1;
    public static final byte ILLEGAL_STATE_EXCEPTION = 2;
    public static final byte INVALID_CLIENT_ID_EXCEPTION = 3;
    public static final byte INVALID_DESTINATION_EXCEPTION = 4;
    public static final byte INVALID_SELECTOR_EXCEPTION = 5;
    public static final byte JMS_SECURITY_EXCEPTION = 6;
    public static final byte MESSAGE_EOF_EXCEPTION = 7;
    public static final byte MESSAGE_FORMAT_EXCEPTION = 8;
    public static final byte MESSAGE_NOT_READABLE_EXCEPTION = 9;
    public static final byte MESSAGE_NOT_WRITEABLE_EXCEPTION = 16;
    public static final byte RESOURCE_ALLOCATION_EXCEPTION = 17;
    public static final byte TRANSACTION_IN_PROGRESS_EXCEPTION = 18;
    public static final byte TRANSACTION_ROLLED_BACK_EXCEPTION = 19;
    public static final byte TYPE_ID = -112;
    static final int POS_ERROR_CLASS = 0;
    static final int POS_STRING_ARRAY = 1;
    static final int SIZE = 1;

    public ServerExceptionResponse() {
    }

    public ServerExceptionResponse(Exception ex) throws JMSException {
        int type = 0;
        type = ex instanceof InvalidClientIDException ? 3 : (ex instanceof IllegalStateException ? 2 : (ex instanceof InvalidDestinationException ? 4 : (ex instanceof InvalidSelectorException ? 5 : (ex instanceof JMSSecurityException ? 6 : (ex instanceof MessageEOFException ? 7 : (ex instanceof MessageFormatException ? 8 : (ex instanceof MessageNotReadableException ? 16 : (ex instanceof MessageNotWriteableException ? 16 : (ex instanceof ResourceAllocationException ? 17 : (ex instanceof TransactionInProgressException ? 18 : (ex instanceof TransactionRolledBackException ? 19 : (ex instanceof JMSException ? 1 : 0))))))))))));
        String reason = null;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        if (ex instanceof JMSException) {
            reason = ((JMSException)((Object)ex)).getErrorCode();
            Exception ex2 = ((JMSException)((Object)ex)).getLinkedException();
            if (ex2 != null) {
                ex2.printStackTrace(pw);
            }
        }
        pw.flush();
        this.setException((byte)type, ex.getLocalizedMessage(), reason, sw.toString());
    }

    private void setException(byte error_class, String reason, String error_code, String stacktrace) throws JMSException {
        String[] value = new String[]{reason, error_code, stacktrace};
        this.allocate((byte)-112, 1 + PacketImpl.strlenUTF8(value));
        this.setByte(0, error_class);
        this.setUTF8Array(1, value);
    }

    public ServerExceptionResponse(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public final byte getErrorClass() throws BufferUnderflowException {
        return this.getByte(0);
    }

    public final String getReason() throws BufferUnderflowException {
        String[] value = this.getStringArray(1);
        return value != null && value.length >= 1 ? value[0] : null;
    }

    public final String getErrorCode() throws BufferUnderflowException {
        String[] value = this.getStringArray(1);
        return value != null && value.length >= 2 ? value[1] : null;
    }

    public final String getStackTrace() throws BufferUnderflowException {
        String[] value = this.getStringArray(1);
        return value != null && value.length >= 3 ? value[2] : null;
    }

    public final JMSException getException() throws BufferUnderflowException {
        Throwable ex;
        byte type = this.getByte(0);
        String[] value = this.getStringArray(1);
        String reason = value != null && value.length >= 1 ? value[0] : null;
        String code = value != null && value.length >= 2 ? value[1] : null;
        String trace = value != null && value.length >= 3 ? value[2] : null;
        switch (type) {
            case 2: {
                ex = new IllegalStateException(reason, code);
                break;
            }
            case 3: {
                ex = new InvalidClientIDException(reason, code);
                break;
            }
            case 4: {
                ex = new InvalidDestinationException(reason, code);
                break;
            }
            case 5: {
                ex = new InvalidSelectorException(reason, code);
                break;
            }
            case 6: {
                ex = new JMSSecurityException(reason, code);
                break;
            }
            case 7: {
                ex = new MessageEOFException(reason, code);
                break;
            }
            case 8: {
                ex = new MessageFormatException(reason, code);
                break;
            }
            case 9: {
                ex = new MessageNotReadableException(reason, code);
                break;
            }
            case 16: {
                ex = new MessageNotWriteableException(reason, code);
                break;
            }
            case 17: {
                ex = new ResourceAllocationException(reason, code);
                break;
            }
            case 18: {
                ex = new TransactionInProgressException(reason, code);
                break;
            }
            case 19: {
                ex = new TransactionRolledBackException(reason, code);
                break;
            }
            default: {
                ex = new JMSException(reason, code);
            }
        }
        if (trace != null) {
            StackTraceException ex2 = new StackTraceException((Exception)ex, trace);
            ex.setLinkedException((Exception)ex2);
        }
        return ex;
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        out.println("------------------------------ Exception Content -------------------------------");
        args.add("ErrorClass:");
        args.add(this.getErrorClass());
        args.add("ErrorCode:");
        args.add(this.getErrorCode());
        args.add("Exception:");
        args.add(this.getException().toString());
        args.add("Reason:");
        args.add(this.getReason());
        args.add("Trace:");
        out.printf("%-30s %-d\n%-30s %-s\n%-30s %-s\n%-30s %-s\n%-30s\n", args);
        String trace = this.getStackTrace();
        if (trace != null) {
            out.println(trace);
        }
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-112, "ServerExceptionResponse");
    }
}

