/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferOverflowException;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithDestinationID;
import com.sap.jms.protocol.notification.QueueBrowserBasePacket;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class QueueBrowserCreateRequest
extends QueueBrowserBasePacket
implements PacketWithDestinationID {
    public static final byte TYPE_ID = -42;
    static final int POS_CONSUMER_LIMIT = 16;
    static final int POS_STRING_ARRAY = 20;
    static final int SIZE = 20;

    public QueueBrowserCreateRequest() {
    }

    public QueueBrowserCreateRequest(int session_id, String queue_name, String message_filter, int client_limit) throws JMSException {
        String[] value = new String[]{queue_name, message_filter};
        this.allocate((byte)-42, 20 + PacketImpl.strlenUTF8(value));
        this.setSessionID(session_id);
        this.setInt(16, client_limit);
        this.setUTF8Array(20, value);
    }

    public QueueBrowserCreateRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public final String getDestinationName() throws BufferUnderflowException {
        String[] value = this.getStringArray(20);
        return value != null && value.length >= 1 ? value[0] : null;
    }

    public final String getMessageFilter() throws BufferUnderflowException {
        String[] value = this.getStringArray(20);
        return value != null && value.length >= 2 ? value[1] : null;
    }

    public void setBrowserID(long browser_id) throws BufferOverflowException {
        this.setLong(8, browser_id);
    }

    public int getConsumerLimit() throws BufferUnderflowException {
        return this.getInt(16);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        args.add("DestinationName:");
        args.add(this.getDestinationName());
        args.add("MessageFilter:");
        args.add(this.getMessageFilter());
        out.printf("%-30s %-s\n%-30s %-s\n", args);
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-42, "QueueBrowserCreateRequest");
    }
}

