/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketWithBrowserID;
import com.sap.jms.protocol.PacketWithDestinationID;
import com.sap.jms.protocol.PacketWithSessionIDAndDestinationIDImpl;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

class QueueBrowserBasePacket
extends PacketWithSessionIDAndDestinationIDImpl
implements PacketWithBrowserID,
PacketWithDestinationID {
    protected static final int POS_BROWSER_ID = 8;
    protected static final int SIZE = 16;

    protected QueueBrowserBasePacket() {
    }

    protected QueueBrowserBasePacket(byte type_id, int size, int session_id, long browser_id) throws JMSException {
        super(type_id, size, session_id);
        this.setLong(8, browser_id);
    }

    protected QueueBrowserBasePacket(byte type_id, int session_id, long browser_id) throws JMSException {
        super(type_id, 16, session_id);
        this.setLong(8, browser_id);
    }

    protected QueueBrowserBasePacket(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public final long getBrowserID() throws BufferUnderflowException {
        return this.getLong(8);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        args.add("BrowserID:");
        args.add(this.getBrowserID());
        out.printf("%-30s %-d\n", args);
    }
}

