/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferOverflowException;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.notification.ProducerBasePacket;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class ProducerCreateRequest
extends ProducerBasePacket {
    public static final byte TYPE_ID = -37;
    static final int POS_TYPE = 16;
    static final int POS_DESTINATION_NAME = 17;
    static final int SIZE = 17;

    public ProducerCreateRequest() {
    }

    public ProducerCreateRequest(int session_id, String destination_name, byte destination_type) throws JMSException {
        super((byte)-37, 17 + PacketImpl.strlenUTF8(destination_name), session_id);
        this.setByte(16, destination_type);
        this.setUTF8(17, destination_name);
    }

    public ProducerCreateRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public final byte getType() throws BufferUnderflowException {
        return this.getByte(16);
    }

    public final String getDestinationName() throws BufferUnderflowException {
        return this.getString(17);
    }

    public void setProducerID(long producer_id) throws BufferOverflowException {
        this.setLong(8, producer_id);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        out.println("------------------------------ Producer Content --------------------------------");
        super.toString(out, args);
        args.add("DestinationName:");
        args.add(this.getDestinationName());
        args.add("Type:");
        args.add(this.getType());
        out.printf("%-30s %-s\n%-30s %-d\n", args);
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-37, "ProducerCreateRequest");
    }
}

