/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketWithProducerID;
import com.sap.jms.protocol.PacketWithSessionIDAndDestinationIDImpl;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class ProducerBasePacket
extends PacketWithSessionIDAndDestinationIDImpl
implements PacketWithProducerID {
    protected static final int POS_PRODUCER_ID = 8;
    protected static final int SIZE = 16;

    protected ProducerBasePacket() {
    }

    protected ProducerBasePacket(byte type_id, int size, int session_id) throws JMSException {
        this(type_id, size, session_id, 0L);
    }

    protected ProducerBasePacket(byte type_id, int session_id, long producer_id) throws JMSException {
        this(type_id, 16, session_id, producer_id);
    }

    protected ProducerBasePacket(byte type_id, int size, int session_id, long producer_id) throws JMSException {
        super(type_id, size, session_id);
        this.setLong(8, producer_id);
    }

    public ProducerBasePacket(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public final long getProducerID() throws BufferUnderflowException {
        return this.getLong(8);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        args.add("ProducerID:");
        args.add(this.getProducerID());
        out.printf("%-30s %-d\n", args);
    }
}

