/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithConsumerIDsAndMessageCounts;
import com.sap.jms.protocol.PacketWithSessionIDImpl;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class MessageAcknowledgeRequest
extends PacketWithSessionIDImpl
implements PacketWithConsumerIDsAndMessageCounts {
    public static final byte TYPE_ID = -80;
    private static final int POS_CONSUMER_IDS = 4;
    private static final int SIZE = 4;

    public MessageAcknowledgeRequest() {
    }

    public MessageAcknowledgeRequest(int session_id, long[] consumer_ids, int[] message_counts, int length) throws JMSException {
        super((byte)-80, 4 + length * 8 + (length + 2) * 4, session_id);
        this.setPosition(4);
        this.writeInt(length);
        int i = 0;
        while (i < length) {
            this.writeLong(consumer_ids[i]);
            ++i;
        }
        this.writeInt(length);
        int i2 = 0;
        while (i2 < length) {
            this.writeInt(message_counts[i2]);
            ++i2;
        }
    }

    public MessageAcknowledgeRequest(int session_id, long consumerID) throws JMSException {
        this(session_id, new long[]{consumerID}, new int[]{1}, 1);
    }

    public MessageAcknowledgeRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public long[] getConsumerIDs() throws JMSException {
        this.setPosition(4);
        long[] consumer_ids = new long[this.readInt()];
        int i = 0;
        while (i < consumer_ids.length) {
            consumer_ids[i] = this.readLong();
            ++i;
        }
        return consumer_ids;
    }

    public int[] getMessageCounts() throws JMSException {
        this.setPosition(4);
        this.setPosition(4 + this.readInt() * 8 + 4);
        int[] message_counts = new int[this.readInt()];
        int i = 0;
        while (i < message_counts.length) {
            message_counts[i] = this.readInt();
            ++i;
        }
        return message_counts;
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        long[] array = this.getConsumerIDs();
        int[] message_counts = this.getMessageCounts();
        int j = 0;
        while (j < message_counts.length) {
            args.add("MessageCounts(");
            args.add(j + 1);
            args.add("):");
            args.add(message_counts[j]);
            out.printf("%-14s %-d %-13s %-5d\n", args);
            ++j;
        }
        int i = 0;
        while (i < array.length) {
            args.add("ConsumerID(");
            args.add(i + 1);
            args.add("):");
            args.add(array[i]);
            out.printf("%-7s %-d  %-15s %-5x\n", args);
            ++i;
        }
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-80, "MessageAcknowledgeRequest");
    }
}

