/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithConnectionIDImpl;
import com.sap.jms.protocol.PacketWithDestinationID;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class DestinationCreateResponse
extends PacketWithConnectionIDImpl
implements PacketWithDestinationID {
    public static final byte TYPE_ID = -98;
    protected static final int POS_DESTINATION_ID = 8;
    protected static final int POS_DESTINATION_NAME = 12;
    protected static final int SIZE = 12;

    public DestinationCreateResponse() {
    }

    public DestinationCreateResponse(long client_id, int destination_id, String destination_name) throws JMSException {
        super((byte)-98, 12 + PacketImpl.strlenUTF8(destination_name), client_id);
        this.setInt(8, destination_id);
        this.setUTF8(12, destination_name);
    }

    public DestinationCreateResponse(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public int getDestinationID() throws BufferUnderflowException {
        return this.getInt(8);
    }

    public final String getDestinationName() throws BufferUnderflowException {
        return this.getString(12);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        out.println("------------------------------ Destination Content -----------------------------");
        args.add("DestinationID:");
        args.add(this.getDestinationID());
        args.add("DestinationName:");
        args.add(this.getDestinationName());
        out.printf("%-30s %-d\n%-30s %-s", args);
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-98, "DestinationCreateResponse");
    }
}

