/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferOverflowException;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithConnectionIDImpl;
import com.sap.jms.protocol.PacketWithDestinationID;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class DestinationCreateRequest
extends PacketWithConnectionIDImpl
implements PacketWithDestinationID {
    public static final byte TYPE_ID = -97;
    public static final byte QUEUE = 0;
    public static final byte TOPIC = 1;
    static final int POS_DESTINATION_ID = 8;
    static final int POS_BITSET = 12;
    static final int POS_DESTINATION_NAME = 13;
    static final int SIZE = 13;
    static final byte BIT_TEMPORARY = 1;

    public DestinationCreateRequest() {
    }

    public DestinationCreateRequest(long client_id, String destination_name, byte destination_type, boolean is_temporary) throws JMSException {
        super((byte)-97, 13 + PacketImpl.strlenUTF8(destination_name), client_id);
        this.setByte(12, (byte)(destination_type << 4 | (is_temporary ? 1 : 0)));
        this.setUTF8(13, destination_name);
    }

    public DestinationCreateRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public final byte getType() throws BufferUnderflowException {
        return (byte)(this.getByte(12) >>> 4 & 0xF);
    }

    public final boolean isTemporary() throws BufferUnderflowException {
        return (this.getByte(12) & 1) != 0;
    }

    public final String getDestinationName() throws BufferUnderflowException {
        return this.getString(13);
    }

    public int getDestinationID() throws BufferUnderflowException {
        return this.getInt(8);
    }

    public void setDestinationID(int destination_id) throws BufferOverflowException {
        this.setInt(8, destination_id);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        out.println("------------------------------ Destination Content -----------------------------");
        args.add("DestinationID:");
        args.add(this.getDestinationID());
        args.add("DestinationName:");
        args.add(this.getDestinationName());
        args.add("Type:");
        args.add(this.getType() == 1 ? "Topic" : "Queue");
        args.add("IsTemporary:");
        args.add(this.isTemporary() ? "true" : "false");
        out.printf("%-30s %-d\n%-30s %-s\n%-30s %-s\n%-30s %-s\n", args);
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-97, "DestinationCreateRequest");
    }
}

