/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferOverflowException;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithConnectionID;
import com.sap.jms.protocol.PacketWithConsumerID;
import com.sap.jms.protocol.PacketWithDestinationID;
import com.sap.jms.protocol.notification.ConsumerBasePacket;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class ConsumerCreateRequest
extends ConsumerBasePacket
implements PacketWithConsumerID,
PacketWithDestinationID,
PacketWithConnectionID {
    public static final byte TYPE_ID = -33;
    static final int POS_CONNECTION_ID = 16;
    static final int POS_CLIENT_LIMIT = 24;
    static final int POS_BITSET = 28;
    static final int POS_STRING_ARRAY = 29;
    static final int SIZE = 29;
    static final byte BIT_NOLOCAL = 1;

    public ConsumerCreateRequest() {
    }

    public ConsumerCreateRequest(int session_id, String subscription_name, String destination_name, byte destination_type, boolean no_local, String message_filter, int client_limit) throws JMSException {
        String[] value = new String[]{destination_name, message_filter, subscription_name};
        this.allocate((byte)-33, 29 + PacketImpl.strlenUTF8(value));
        this.setSessionID(session_id);
        this.setDestinationID(0);
        this.setByte(28, (byte)(destination_type << 4 | (no_local ? 1 : 0)));
        this.setInt(24, client_limit);
        this.setUTF8Array(29, value);
    }

    public ConsumerCreateRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public final byte getType() throws BufferUnderflowException {
        return (byte)(this.getByte(28) >>> 4 & 0xF);
    }

    public final boolean isNoLocal() throws BufferUnderflowException {
        return (this.getByte(28) & 1) != 0;
    }

    public final String getDestinationName() throws BufferUnderflowException {
        String[] value = this.getStringArray(29);
        return value != null && value.length >= 1 ? value[0] : null;
    }

    public final String getMessageFilter() throws BufferUnderflowException {
        String[] value = this.getStringArray(29);
        return value != null && value.length >= 2 ? value[1] : null;
    }

    public final String getSubscriptionName() throws BufferUnderflowException {
        String[] value = this.getStringArray(29);
        return value != null && value.length >= 3 ? value[2] : null;
    }

    public void setConsumerID(long consumer_id) throws BufferOverflowException {
        this.setLong(8, consumer_id);
    }

    public void setConnectionID(long connection_id) throws BufferOverflowException {
        this.setLong(16, connection_id);
    }

    public long getConnectionID() throws BufferUnderflowException {
        return this.getLong(16);
    }

    public int getClientLimit() throws BufferUnderflowException {
        return this.getInt(24);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        out.println("------------------------------ Consumer Content ----------------------------------");
        args.add("DestinationName:");
        args.add(this.getDestinationName());
        args.add("MessageFilter:");
        args.add(this.getMessageFilter());
        args.add("SubscriptionName:");
        args.add(this.getSubscriptionName());
        args.add("Type:");
        args.add(this.getType());
        args.add("IsNoLocal:");
        args.add(this.isNoLocal() ? "true" : "false");
        out.printf("%-30s %-s\n%-30s %-s\n%-30s %-s\n%-30s %-d\n%-30s %-s\n", args);
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-33, "ConsumerCreateRequest");
    }
}

