/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketWithConsumerID;
import com.sap.jms.protocol.PacketWithSessionIDAndDestinationIDImpl;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

class ConsumerBasePacket
extends PacketWithSessionIDAndDestinationIDImpl
implements PacketWithConsumerID {
    protected static final int POS_CONSUMER_ID = 8;
    protected static final int SIZE = 16;

    protected ConsumerBasePacket() {
    }

    protected ConsumerBasePacket(byte type_id, int size, int session_id, long consumer_id) throws JMSException {
        super(type_id, size, session_id);
        this.setLong(8, consumer_id);
    }

    protected ConsumerBasePacket(byte type_id, int session_id, long consumer_id) throws JMSException {
        super(type_id, 16, session_id);
        this.setLong(8, consumer_id);
    }

    protected ConsumerBasePacket(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public final long getConsumerID() throws BufferUnderflowException {
        return this.getLong(8);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        args.add("ConsumerID:");
        args.add(this.getConsumerID());
        out.printf("%-30s %-x\n", args);
    }
}

