/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.notification;

import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class ConnectionCreateRequest
extends PacketImpl {
    public static final byte TYPE_ID = -3;
    static final int POS_MAGIC_NUMBER = 0;
    static final int POS_PROTOCOL_VERSION = 4;
    static final int POS_CREDENTIALS_TYPE = 8;
    static final int POS_CREDENTIALS = 9;
    static final int SIZE = 9;
    static final int MAGIC_NUMBER = 24081961;
    static final byte CREDENTIALS_USER_PASSWORD = 0;
    static final byte CREDENTIALS_CERTIFICATE = 1;

    public ConnectionCreateRequest() {
    }

    public ConnectionCreateRequest(String instance, String username, String password) throws JMSException {
        String[] value = new String[]{instance, username, password};
        this.allocate((byte)-3, 9 + PacketImpl.strlenUTF8(value));
        this.setInt(0, 24081961);
        this.setInt(4, 10000);
        this.setByte(8, (byte)0);
        this.setUTF8Array(9, value);
    }

    public ConnectionCreateRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public int getProtocolMajorVersionNumber() throws BufferUnderflowException {
        return this.getInt(4) / 10000;
    }

    public int getProtocolMinorVersionNumber() throws BufferUnderflowException {
        int version = this.getInt(4);
        int major = version / 10000;
        return (version - major * 10000) / 100;
    }

    public int getProtocolRevisionNumber() throws BufferUnderflowException {
        int version = this.getInt(4);
        int major = version / 10000;
        int minor = (version - major * 10000) / 100;
        return version - major * 10000 - minor * 100;
    }

    public String getJMSServerInstanceName() throws BufferUnderflowException {
        String[] value = this.getStringArray(9);
        return value != null && value.length >= 1 ? value[0] : null;
    }

    public String getUsername() throws BufferUnderflowException {
        if (this.getByte(8) != 0) {
            return null;
        }
        String[] value = this.getStringArray(9);
        return value != null && value.length >= 2 ? value[1] : null;
    }

    public String getPassword() throws BufferUnderflowException {
        if (this.getByte(8) != 0) {
            return null;
        }
        String[] value = this.getStringArray(9);
        return value != null && value.length >= 3 ? value[2] : null;
    }

    public String getFactoryName() throws BufferUnderflowException {
        if (this.getByte(8) != 0) {
            return null;
        }
        String[] value = this.getStringArray(9);
        return value != null && value.length >= 3 && value[1].equals("") ? value[2] : null;
    }

    public byte[] getCertificate() throws BufferUnderflowException {
        if (this.getByte(8) != 1) {
            return null;
        }
        return this.getByteArray(9);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        out.println("------------------------------ Connection Info ---------------------------------");
        args.add("JMSServerInstanceName:");
        args.add(this.getJMSServerInstanceName());
        args.add("Password:");
        args.add(this.getPassword());
        args.add("ProtocolMajorVersion:");
        args.add(this.getProtocolMajorVersionNumber());
        args.add("ProtocolMinorVersion:");
        args.add(this.getProtocolMinorVersionNumber());
        args.add("ProtocolRevisionNumber:");
        args.add(this.getProtocolRevisionNumber());
        out.printf("%-30s %-s\n%-30s %-s\n%-30s %-d\n%-30s %-d\n%-30s %-d\n", args);
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-3, "ConnectionCreateRequest");
    }
}

