/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.message;

import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithSessionIDImpl;
import javax.jms.JMSException;

public class MessageResponse
extends PacketWithSessionIDImpl {
    public static final byte TYPE_ID = -96;
    static final int POS_NUM_MESSAGE_IDS = 4;
    static final int POS_MESSAGE_IDS = 8;
    static final int SIZE = 8;

    public MessageResponse() {
    }

    public MessageResponse(int session_id, byte[] message_id) throws JMSException {
        super((byte)-96, 26, session_id);
        this.setInt(4, 1);
        this.setByteArray(8, message_id);
    }

    public MessageResponse(int session_id, byte[][] message_ids) throws JMSException {
        super((byte)-96, 8 + 18 * message_ids.length, session_id);
        this.setInt(4, message_ids.length);
        int inc = 12;
        int i = 0;
        int pos = 8;
        while (i < message_ids.length) {
            this.setByteArray(pos, message_ids[i]);
            ++i;
            pos += inc;
        }
    }

    public MessageResponse(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(-96, "MessageResponse");
    }
}

