/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol.message;

import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.jms.protocol.BufferOverflowException;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.PacketImpl;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWithConnectionIDAndSessionIDImpl;
import com.sap.jms.protocol.PacketWithConsumerID;
import com.sap.jms.protocol.PacketWithDestinationID;
import com.sap.jms.protocol.serialization.JMSInputStream;
import com.sap.jms.util.MessageID;
import com.sap.jms.util.PrintfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;

public class MessageRequest
extends PacketWithConnectionIDAndSessionIDImpl
implements Cloneable,
PacketWithDestinationID,
PacketWithConsumerID {
    static final byte BIT_PERSISTENT = 1;
    static final byte BIT_REDELIVERED = 2;
    static final byte BIT_TOPIC = 4;
    static final byte BIT_TEMPORARY = 8;
    static final byte BIT_REPLYTO_TOPIC = 16;
    static final byte BIT_REPLYTO_TEMPORARY = 32;
    static final int POS_CONSUMER_ID = 12;
    static final int POS_DESTINATION_ID = 12;
    static final int POS_TIMESTAMP = 20;
    static final int POS_EXPIRATION = 28;
    static final int POS_MESSAGE_ID = 36;
    static final int POS_BITSET = 50;
    static final int POS_PRIORITY = 51;
    protected static final int POS_HEADER_VALUES_OFFSET = 52;
    protected static final int POS_MESSAGE_PROPERTIES_OFFSET = 56;
    public static final int POS_MESSAGE_BODY_OFFSET = 60;
    public static final int SIZE = 64;
    private static final byte[] DISABLED_MESSAGE_ID_BYTES;
    transient HashMapObjectObject m_header_values = null;
    transient HashMapObjectObject m_properties = null;
    transient Object m_body = null;
    transient int m_body_length = 0;

    public MessageRequest() {
    }

    public MessageRequest(byte type_id, int packet_size, long connection_id, int session_id) throws JMSException {
        super(type_id, packet_size <= 78 ? 64 : packet_size, connection_id, session_id);
    }

    public MessageRequest(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public MessageRequest(byte[] buffer, int offset, int length, int priority, long timestamp, boolean is_persistent) throws JMSException {
        super(buffer, offset, length);
        this.setJMSPriority(priority);
        this.setJMSTimestamp(timestamp);
        this.setJMSDeliveryMode(is_persistent ? 2 : 2);
    }

    public void flush() throws JMSException {
        this.encode();
    }

    private final int getHeaderValuesOffset() throws BufferUnderflowException {
        return this.getInt(52);
    }

    private final int getHeaderValuesSize() throws BufferUnderflowException {
        int hoffset = this.getHeaderValuesOffset();
        if (hoffset == 0) {
            return 0;
        }
        int poffset = this.getMessagePropertiesOffset();
        if (poffset == 0) {
            int boffset = this.getMessageBodyOffset();
            return (boffset == 0 ? this.m_end : boffset) - hoffset;
        }
        return poffset - hoffset;
    }

    private final int getMessagePropertiesOffset() throws BufferUnderflowException {
        return this.getInt(56);
    }

    private final int getMessagePropertiesSize() throws BufferUnderflowException {
        int poffset = this.getMessagePropertiesOffset();
        if (poffset == 0) {
            return 0;
        }
        int boffset = this.getMessageBodyOffset();
        return (boffset == 0 ? this.m_end : boffset) - poffset;
    }

    public final int getMessageBodyOffset() throws BufferUnderflowException {
        return this.getInt(60);
    }

    public final int getMessageBodySize() throws BufferUnderflowException {
        int boffset = this.getMessageBodyOffset();
        return boffset == 0 ? 0 : this.m_end - boffset;
    }

    private void writeProperties(HashMapObjectObject properties) throws JMSException, MessageFormatException {
        this.writeInt(properties.size());
        Enumeration i = properties.keys();
        while (i.hasMoreElements()) {
            String name = (String)i.nextElement();
            Object value = properties.get(name);
            this.writeProperty(name, value);
        }
    }

    private HashMapObjectObject getProperties(int position) throws JMSException, BufferUnderflowException, MessageFormatException {
        if (position == 0 || this.getMessagePropertiesSize() == 0) {
            return null;
        }
        int old_position = this.getPosition();
        this.setPosition(position - 14);
        HashMapObjectObject properties = new HashMapObjectObject();
        int num_properties = this.readInt();
        int i = 0;
        while (i < num_properties) {
            Object value;
            byte type = this.readByte();
            String name = this.readString();
            switch (type) {
                case -10: {
                    value = this.readString();
                    break;
                }
                case -1: {
                    value = new Byte(this.readByte());
                    break;
                }
                case -3: {
                    value = new Short(this.readShort());
                    break;
                }
                case -4: {
                    value = new Integer(this.readInt());
                    break;
                }
                case -5: {
                    value = new Long(this.readLong());
                    break;
                }
                case -6: {
                    value = new Float(this.readFloat());
                    break;
                }
                case -7: {
                    value = new Double(this.readDouble());
                    break;
                }
                case -8: {
                    byte bool = this.readByte();
                    value = bool == 1 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case -12: {
                    value = this.readByteArray();
                    break;
                }
                case -2: {
                    value = new Character(this.readChar());
                    break;
                }
                default: {
                    throw new MessageFormatException("Non primitive property encountered");
                }
            }
            properties.put(name, value);
            ++i;
        }
        this.setPosition(old_position);
        return properties;
    }

    private int strlenProperties(HashMapObjectObject properties) throws MessageFormatException {
        int size = 4;
        Enumeration i = properties.keys();
        while (i.hasMoreElements()) {
            String name = (String)i.nextElement();
            Object value = properties.get(name);
            size += this.strlenProperty(name, value);
        }
        return size;
    }

    private int strlenProperty(String name, Object value) throws MessageFormatException {
        int length = PacketImpl.strlenUTF8(name) + 1;
        if (value instanceof String) {
            length += PacketImpl.strlenUTF8((String)value);
        } else if (value instanceof Byte) {
            ++length;
        } else if (value instanceof Character) {
            length += 2;
        } else if (value instanceof Short) {
            length += 2;
        } else if (value instanceof Integer) {
            length += 4;
        } else if (value instanceof Long) {
            length += 8;
        } else if (value instanceof Float) {
            length += 4;
        } else if (value instanceof Double) {
            length += 8;
        } else if (value instanceof Boolean) {
            ++length;
        } else if (value instanceof byte[]) {
            length += ((byte[])value).length + 4;
        } else {
            throw new MessageFormatException("Non primitive property encountered");
        }
        return length;
    }

    private final Object readBody() throws JMSException {
        try {
            int type = this.getPacketType();
            int position = this.getInt(60);
            if (position == 0 || this.getMessageBodySize() == 0) {
                return null;
            }
            this.setPosition(this.m_start + position - this.m_payload_start);
            Object body = null;
            if (type == 1 || type == 3) {
                body = this.readByteArray();
            } else if (type == 2) {
                body = this.readString();
            } else if (type == 4) {
                body = this.getProperties(position);
            } else if (type == 5) {
                body = this.readByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream((byte[])body);
                JMSInputStream ois = new JMSInputStream(bis, Thread.currentThread().getContextClassLoader());
                body = ois.readObject();
            }
            return body;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
    }

    private void writeProperty(String name, Object value) throws BufferOverflowException, MessageFormatException {
        int length = PacketImpl.strlenUTF8(name) + 1;
        if (value instanceof String) {
            length += PacketImpl.strlenUTF8((String)value);
            this.writeByte((byte)-10);
            this.writeUTF8(name);
            this.writeUTF8((String)value);
        } else if (value instanceof Byte) {
            ++length;
            this.writeByte((byte)-1);
            this.writeUTF8(name);
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            length += 2;
            this.writeByte((byte)-3);
            this.writeUTF8(name);
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            length += 4;
            this.writeByte((byte)-4);
            this.writeUTF8(name);
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            length += 8;
            this.writeByte((byte)-5);
            this.writeUTF8(name);
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            length += 4;
            this.writeByte((byte)-6);
            this.writeUTF8(name);
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            length += 8;
            this.writeByte((byte)-7);
            this.writeUTF8(name);
            this.writeDouble((Double)value);
        } else if (value instanceof Boolean) {
            ++length;
            this.writeByte((byte)-8);
            this.writeUTF8(name);
            this.writeByte((Boolean)value != false ? (byte)1 : 0);
        } else if (value instanceof byte[]) {
            length += 4 + ((byte[])value).length;
            this.writeByte((byte)-12);
            this.writeUTF8(name);
            this.writeByteArray((byte[])value);
        } else if (value instanceof Character) {
            length += 2;
            this.writeByte((byte)-2);
            this.writeUTF8(name);
            this.writeChar(((Character)value).charValue());
        } else {
            throw new MessageFormatException("Non primitive property encountered");
        }
    }

    public int getDestinationID() throws BufferUnderflowException {
        return (int)this.getLong(12);
    }

    public final int getJMSDestinationID() throws BufferUnderflowException {
        return this.getDestinationID();
    }

    public final boolean isDestinationTopic() throws BufferUnderflowException {
        return (byte)(this.getByte(50) & 4) != 0;
    }

    public final boolean isDestinationTemporary() throws BufferUnderflowException {
        return (byte)(this.getByte(50) & 8) != 0;
    }

    public final void setDestinationTopic(boolean isTopic) throws BufferOverflowException {
        try {
            if (isTopic) {
                this.setByte(50, (byte)(this.getByte(50) | 4));
            } else {
                this.setByte(50, (byte)(this.getByte(50) & 0xFFFFFFFB));
            }
        }
        catch (BufferUnderflowException bue) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.setLinkedException((Exception)((Object)bue));
            throw boe;
        }
    }

    public final void setDestinationTemporary(boolean isTemporary) throws BufferOverflowException {
        try {
            if (isTemporary) {
                this.setByte(50, (byte)(this.getByte(50) | 8));
            } else {
                this.setByte(50, (byte)(this.getByte(50) & 0xFFFFFFF7));
            }
        }
        catch (BufferUnderflowException bue) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.setLinkedException((Exception)((Object)bue));
            throw boe;
        }
    }

    public final void setJMSReplyToTopic(boolean isTopic) throws BufferOverflowException {
        try {
            if (isTopic) {
                this.setByte(50, (byte)(this.getByte(50) | 0x10));
            } else {
                this.setByte(50, (byte)(this.getByte(50) & 0xFFFFFFEF));
            }
        }
        catch (BufferUnderflowException bue) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.setLinkedException((Exception)((Object)bue));
            throw boe;
        }
    }

    public final boolean isJMSReplyToTopic() throws BufferUnderflowException {
        return (byte)(this.getByte(50) & 0x10) != 0;
    }

    public final void setJMSReplyToTemporary(boolean isTemporary) throws BufferOverflowException {
        try {
            if (isTemporary) {
                this.setByte(50, (byte)(this.getByte(50) | 0x20));
            } else {
                this.setByte(50, (byte)(this.getByte(50) & 0xFFFFFFDF));
            }
        }
        catch (BufferUnderflowException bue) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.setLinkedException((Exception)((Object)bue));
            throw boe;
        }
    }

    public final boolean isJMSReplyToTemporary() throws BufferUnderflowException {
        return (byte)(this.getByte(50) & 0x20) != 0;
    }

    public final void setJMSDestinationID(int destination_id) throws BufferOverflowException {
        this.setLong(12, destination_id);
    }

    public final long getJMSConsumerID() throws BufferUnderflowException {
        return this.getConsumerID();
    }

    public final long getConsumerID() throws BufferUnderflowException {
        return this.getLong(12);
    }

    public final void setConsumerID(long consumer_id) throws BufferOverflowException {
        this.setLong(12, consumer_id);
    }

    public final long getJMSTimestamp() throws BufferUnderflowException {
        return this.getLong(20);
    }

    public final void setJMSTimestamp(long timestamp) throws BufferOverflowException {
        this.setLong(20, timestamp);
    }

    public final long getJMSExpiration() throws BufferUnderflowException {
        return this.getLong(28);
    }

    public final void setJMSExpiration(long timestamp) throws BufferOverflowException {
        this.setLong(28, timestamp);
    }

    public final int getJMSPriority() throws BufferUnderflowException {
        return this.getByte(51) >>> 4 & 0xF;
    }

    public final void setJMSPriority(int priority) throws BufferOverflowException {
        byte bitset = 0;
        try {
            bitset = (byte)(this.getByte(51) & 0xF);
        }
        catch (BufferUnderflowException ex) {
            BufferOverflowException ex2 = new BufferOverflowException();
            ex2.setLinkedException((Exception)((Object)ex));
            throw ex2;
        }
        this.setByte(51, (byte)(bitset | priority << 4));
    }

    public int getJMSDeliveryMode() throws BufferUnderflowException {
        if ((this.getByte(50) & 1) != 0) {
            return 2;
        }
        return 1;
    }

    public void setJMSDeliveryMode(int delivery_mode) throws BufferOverflowException {
        byte bitset = 0;
        try {
            bitset = this.getByte(50);
        }
        catch (BufferUnderflowException ex) {
            BufferOverflowException ex2 = new BufferOverflowException();
            ex2.setLinkedException((Exception)((Object)ex));
            throw ex2;
        }
        bitset = delivery_mode == 2 ? (byte)(bitset | 1) : (byte)(bitset & 0xFFFFFFFE);
        this.setByte(50, bitset);
    }

    public final boolean getJMSRedelivered() throws BufferUnderflowException {
        return (this.getByte(50) & 2) != 0;
    }

    public final void setJMSRedelivered(boolean redelivered) throws BufferOverflowException {
        byte bitset;
        try {
            bitset = this.getByte(50);
        }
        catch (BufferUnderflowException ex) {
            BufferOverflowException ex2 = new BufferOverflowException();
            ex2.setLinkedException((Exception)((Object)ex));
            throw ex2;
        }
        bitset = redelivered ? (byte)(bitset | 2) : (byte)(bitset & 0xFFFFFFFD);
        this.setByte(50, bitset);
    }

    public final byte[] getJMSMessageIDAsBytes() throws BufferUnderflowException {
        return this.getBytes(36, 14);
    }

    public final void setJMSMessageIDAsBytes(byte[] message_id) throws BufferOverflowException {
        this.setBytes(36, message_id, 0, Math.min(message_id.length, 14));
    }

    public String getJMSMessageID() throws BufferUnderflowException {
        byte[] JMSMessageIDAsBytes = this.getJMSMessageIDAsBytes();
        String result = Arrays.equals(DISABLED_MESSAGE_ID_BYTES, JMSMessageIDAsBytes) ? null : "ID:" + MessageID.toString(JMSMessageIDAsBytes);
        return result;
    }

    private final HashMapObjectObject readHeaderValues() throws BufferUnderflowException {
        try {
            return this.getProperties(this.getHeaderValuesOffset());
        }
        catch (Exception ex) {
            throw new BufferUnderflowException();
        }
    }

    public final String getJMSCorrelationID() throws BufferUnderflowException {
        if (this.m_header_values == null) {
            this.m_header_values = this.readHeaderValues();
        }
        if (this.m_header_values == null) {
            return null;
        }
        return (String)this.m_header_values.get("JMSCorrelationID");
    }

    public final void setJMSCorrelationID(String correlation_id) throws BufferOverflowException {
        if (this.m_header_values == null) {
            this.m_header_values = new HashMapObjectObject();
        }
        this.m_header_values.put("JMSCorrelationID", correlation_id);
    }

    public final String getJMSType() throws BufferUnderflowException {
        if (this.m_header_values == null) {
            this.m_header_values = this.readHeaderValues();
        }
        if (this.m_header_values == null) {
            return null;
        }
        return (String)this.m_header_values.get("JMSType");
    }

    public final void setJMSType(String type) throws BufferOverflowException {
        if (this.m_header_values == null) {
            this.m_header_values = new HashMapObjectObject();
        }
        this.m_header_values.put("JMSType", type);
    }

    public final void setJMSReplyToID(int destination_id) throws BufferOverflowException {
        if (this.m_header_values == null) {
            this.m_header_values = new HashMapObjectObject();
        }
        this.m_header_values.put("JMSReplyToID", new Integer(destination_id));
    }

    public final int getJMSReplyToID() throws BufferUnderflowException {
        if (this.m_header_values == null) {
            this.m_header_values = this.readHeaderValues();
        }
        if (this.m_header_values == null) {
            return 0;
        }
        Integer obj = (Integer)this.m_header_values.get("JMSReplyToID");
        return obj != null ? obj : 0;
    }

    public final HashMapObjectObject getMessageProperties() throws JMSException, MessageFormatException {
        if (this.m_properties == null) {
            this.m_properties = this.getProperties(this.getMessagePropertiesOffset());
        }
        return this.m_properties;
    }

    public final void setMessageProperties(HashMapObjectObject properties) throws JMSException, MessageFormatException {
        this.m_properties = properties;
    }

    public final Object getMessageBody() throws JMSException {
        if (this.m_body == null) {
            this.m_body = this.readBody();
        }
        return this.m_body;
    }

    public final void setMessageBody(Object body) throws JMSException {
        this.m_body = body;
    }

    public final void setMessageBody(byte[] body, int length) throws JMSException {
        this.m_body = body;
        this.m_body_length = length;
    }

    public final void setMessageBodyAndType(Object body, byte packet_type) throws JMSException {
        this.m_body = body;
        this.setPacketType(packet_type);
    }

    public final void setMessageBodyAndType(byte[] body, int length, byte packet_type) throws JMSException {
        this.m_body = body;
        this.m_body_length = length;
        this.setPacketType(packet_type);
    }

    public final HashMapObjectObject getMessageFilterProperties() throws JMSException {
        int position;
        HashMapObjectObject properties = new HashMapObjectObject();
        properties.put("JMSDeliveryMode", this.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON_PERSISTENT");
        properties.put("JMSPriority", new Integer(this.getJMSPriority()));
        properties.put("JMSTimestamp", new Long(this.getJMSTimestamp()));
        properties.put("JMSExpiration", new Long(this.getJMSExpiration()));
        properties.put("JMSRedelivered", this.getJMSRedelivered() ? Boolean.TRUE : Boolean.FALSE);
        Object value = this.getJMSMessageID();
        if (value != null) {
            properties.put("JMSMessageID", value);
        }
        if ((value = this.getJMSCorrelationID()) != null) {
            properties.put("JMSCorrelationID", value.toString());
        }
        if ((value = this.getJMSType()) != null) {
            properties.put("JMSType", value.toString());
        }
        if ((position = this.getMessagePropertiesOffset()) == 0) {
            return properties;
        }
        int old_position = this.getPosition();
        this.setPosition(position - this.m_payload_start);
        int num_properties = this.readInt();
        int i = 0;
        while (i < num_properties) {
            byte type = this.readByte();
            String name = this.readString();
            switch (type) {
                case -10: {
                    value = this.readString();
                    break;
                }
                case -1: {
                    value = new Byte(this.readByte());
                    break;
                }
                case -3: {
                    value = new Short(this.readShort());
                    break;
                }
                case -4: {
                    value = new Integer(this.readInt());
                    break;
                }
                case -5: {
                    value = new Long(this.readLong());
                    break;
                }
                case -6: {
                    value = new Float(this.readFloat());
                    break;
                }
                case -7: {
                    value = new Double(this.readDouble());
                    break;
                }
                case -8: {
                    byte bool = this.readByte();
                    value = new Boolean(bool == 1);
                    break;
                }
                case -2: {
                    value = new Character(this.readChar());
                    break;
                }
                default: {
                    throw new JMSException("Non primitive property encountered");
                }
            }
            properties.put(name, value);
            ++i;
        }
        this.setPosition(old_position);
        return properties;
    }

    private final void encode() throws JMSException {
        int total_size;
        if (this.m_header_values == null && this.m_properties == null && this.m_body == null) {
            return;
        }
        int header_size = 0;
        int old_properties_size = 0;
        int properties_size = 0;
        int body_size = 0;
        int offsetInOldBuffer = total_size = 78;
        int type = this.getPacketType();
        int oldBufferPointer = 0;
        int newBufferPointer = 0;
        try {
            boolean write_body;
            boolean write_properties;
            boolean write_header;
            int old_header_size = this.getHeaderValuesSize();
            if (this.m_header_values != null) {
                header_size = this.strlenProperties(this.m_header_values);
                write_header = true;
            } else {
                header_size = old_header_size;
                write_header = false;
            }
            old_properties_size = this.getMessagePropertiesSize();
            if (this.m_properties != null) {
                properties_size = this.strlenProperties(this.m_properties);
                write_properties = properties_size > 0;
            } else {
                properties_size = old_properties_size;
                write_properties = false;
            }
            int old_body_size = this.getMessageBodySize();
            if (this.m_body == null) {
                body_size = old_body_size;
                write_body = false;
            } else if (this.m_body instanceof byte[]) {
                body_size = this.m_body_length + 4;
                write_body = true;
            } else if (this.m_body instanceof String && type != 5) {
                body_size = PacketImpl.strlenUTF8((String)this.m_body);
                write_body = true;
            } else if (this.m_body instanceof HashMapObjectObject) {
                body_size = this.strlenProperties((HashMapObjectObject)this.m_body);
                write_body = true;
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(this.m_body);
                oos.flush();
                this.m_body = bos.toByteArray();
                this.m_body_length = ((byte[])this.m_body).length;
                body_size = this.m_body_length + 4;
                write_body = true;
            }
            byte[] newBuffer = new byte[total_size += header_size + properties_size + body_size];
            byte[] oldBuffer = this.m_buffer;
            int length = offsetInOldBuffer;
            if (this.m_buffer != null) {
                System.arraycopy(this.m_buffer, oldBufferPointer, newBuffer, newBufferPointer, length);
            }
            oldBufferPointer = length;
            newBufferPointer = length;
            int nextOffsetInNewBuffer = length;
            this.setBuffer(newBuffer, 0, newBuffer.length);
            this.setIntInternal(0, newBuffer.length);
            this.setByteInternal(4, (byte)type);
            newBuffer = null;
            if (write_header) {
                oldBufferPointer += old_header_size;
                this.setInt(52, nextOffsetInNewBuffer);
                this.setPosition(newBufferPointer - this.m_payload_start);
                this.writeProperties(this.m_header_values);
                this.m_header_values = null;
                newBufferPointer += header_size;
            } else {
                this.setInt(52, nextOffsetInNewBuffer);
            }
            nextOffsetInNewBuffer += header_size;
            offsetInOldBuffer += old_header_size;
            if (write_properties) {
                if (offsetInOldBuffer > oldBufferPointer) {
                    length = offsetInOldBuffer - oldBufferPointer;
                    System.arraycopy(oldBuffer, oldBufferPointer, this.m_buffer, newBufferPointer, length);
                    oldBufferPointer += length;
                    newBufferPointer += length;
                }
                oldBufferPointer += old_properties_size;
                this.setInt(56, newBufferPointer);
                this.setPosition(newBufferPointer - this.m_payload_start);
                this.writeProperties(this.m_properties);
                this.m_properties = null;
                newBufferPointer += properties_size;
            } else {
                this.setInt(56, nextOffsetInNewBuffer);
            }
            nextOffsetInNewBuffer += properties_size;
            offsetInOldBuffer += old_properties_size;
            if (write_body) {
                if (offsetInOldBuffer > oldBufferPointer) {
                    length = offsetInOldBuffer - oldBufferPointer;
                    System.arraycopy(oldBuffer, oldBufferPointer, this.m_buffer, newBufferPointer, length);
                    newBufferPointer += length;
                }
                this.setInt(60, newBufferPointer);
                this.setPosition(newBufferPointer - this.m_payload_start);
                if (this.m_body instanceof byte[]) {
                    this.writeByteArray((byte[])this.m_body, 0, this.m_body_length);
                } else if (this.m_body instanceof String) {
                    this.writeUTF8((String)this.m_body);
                } else if (this.m_body instanceof HashMapObjectObject) {
                    this.writeProperties((HashMapObjectObject)this.m_body);
                }
                this.m_body = null;
            } else {
                length = (offsetInOldBuffer += old_body_size) - oldBufferPointer;
                System.arraycopy(oldBuffer, oldBufferPointer, this.m_buffer, newBufferPointer, length);
                this.setInt(60, nextOffsetInNewBuffer);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JMSException(ex.getMessage());
        }
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        Object body;
        HashMapObjectObject properties;
        HashMapObjectObject header_values;
        super.toString(out, args);
        out.println("------------------------------ Message Header ----------------------------------");
        args.add("MessageID:");
        args.add(this.getJMSMessageID());
        args.add("Priority:");
        args.add(this.getJMSPriority());
        args.add("DeliveryMode:");
        args.add(this.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON-PERSISTENT");
        args.add("Timestamp:");
        args.add(DateFormat.getDateInstance().format(new Date(this.getJMSTimestamp())));
        args.add("Expiration:");
        args.add(this.getJMSExpiration() == 0L ? "never" : DateFormat.getDateInstance().format(new Date(this.getJMSExpiration())));
        args.add("Redelivered:");
        args.add(this.getJMSRedelivered() ? "true" : "false");
        args.add("DestinationID:");
        args.add(this.getJMSDestinationID());
        out.printf("%-30s %-s\n%-30s %d\n%-30s %-s\n%-30s %-s\n%-30s %-s\n%-30s %-s\n%-30s %08x\n", args);
        HashMapObjectObject hashMapObjectObject = header_values = this.m_header_values != null ? this.m_header_values : this.readHeaderValues();
        if (header_values != null && header_values.size() > 0) {
            StringBuffer fmt = new StringBuffer();
            Enumeration i = header_values.keys();
            while (i.hasMoreElements()) {
                String name = (String)i.nextElement();
                Object value = header_values.get(name);
                args.add(name + ":");
                args.add(value.toString());
                fmt.append("%-30s %-s\n");
            }
            out.printf(fmt.toString(), args);
        }
        HashMapObjectObject hashMapObjectObject2 = properties = this.m_properties != null ? this.m_properties : this.getProperties(this.getMessagePropertiesOffset());
        if (properties != null && properties.size() > 0) {
            out.println("------------------------------ Message Properties ------------------------------");
            StringBuffer fmt = new StringBuffer();
            Enumeration i = properties.keys();
            while (i.hasMoreElements()) {
                String name = (String)i.nextElement();
                String valueAsString = properties.get(name).toString();
                args.add(name + ":");
                if (valueAsString.length() > 80) {
                    args.add(valueAsString.substring(0, 66));
                    fmt.append("%-30s %-66s[...truncated]\n");
                    continue;
                }
                args.add(valueAsString);
                fmt.append("%-30s %-s\n");
            }
            out.printf(fmt.toString(), args);
        }
        Object object = body = this.m_body != null ? this.m_body : this.readBody();
        if (body != null) {
            out.println("------------------------------ Message Body ------------------------------------");
            if (body instanceof String) {
                args.add((String)body);
                if (((String)body).length() <= 80) {
                    out.printfln("%-80s", args);
                } else {
                    out.printfln("%-66s[...truncated]", args);
                }
            } else if (body instanceof byte[]) {
                args.add((byte[])body);
                if (((byte[])body).length <= 80) {
                    out.printfln("%-80s", args);
                } else {
                    out.printfln("%-66s[...truncated]", args);
                }
            } else if (body instanceof HashMapObjectObject) {
                HashMapObjectObject hashmap = (HashMapObjectObject)body;
                StringBuffer fmt = new StringBuffer();
                Enumeration i = hashmap.keys();
                while (i.hasMoreElements()) {
                    String name = (String)i.nextElement();
                    Object value = hashmap.get(name);
                    args.add(name + ":");
                    args.add(value.toString());
                    fmt.append("%-30s %-49s\n");
                }
                out.printf(fmt.toString(), args);
            } else {
                String s = body.toString();
                args.add(s);
                if (s.length() <= 80) {
                    out.printfln("%-80s", args);
                } else {
                    out.printfln("%-68s[...truncated]", args);
                }
            }
        }
    }

    static {
        PacketTypesImpl.PACKET_NAMES.put(1, "JMSBytesMessage");
        PacketTypesImpl.PACKET_NAMES.put(2, "JMSTextMessage");
        PacketTypesImpl.PACKET_NAMES.put(3, "JMSStreamMessage");
        PacketTypesImpl.PACKET_NAMES.put(4, "JMSMapMessage");
        PacketTypesImpl.PACKET_NAMES.put(5, "JMSObjectMessage");
        PacketTypesImpl.PACKET_NAMES.put(6, "JMSGenericMessage");
        DISABLED_MESSAGE_ID_BYTES = new byte[14];
    }
}

