/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol;

import com.sap.jms.protocol.BufferOverflowException;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.Packet;
import com.sap.jms.protocol.PacketWithConnectionID;
import com.sap.jms.protocol.PacketWithConnectionIDImpl;
import com.sap.jms.protocol.PacketWithSessionID;
import com.sap.jms.util.PrintfWriter;
import javax.jms.JMSException;

public class PacketWithConnectionIDAndSessionIDImpl
extends PacketWithConnectionIDImpl
implements Packet,
PacketWithConnectionID,
PacketWithSessionID {
    protected static final int POS_SESSION_ID = 8;
    protected static final int SIZE = 12;

    protected PacketWithConnectionIDAndSessionIDImpl() {
    }

    protected PacketWithConnectionIDAndSessionIDImpl(byte packet_type, int packet_size, long client_id, int session_id) throws JMSException {
        super(packet_type, packet_size, client_id);
        this.setInt(8, session_id);
    }

    protected PacketWithConnectionIDAndSessionIDImpl(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public long getConnectionID() throws BufferUnderflowException {
        return this.getLong(0);
    }

    public int getSessionID() throws BufferUnderflowException {
        return this.getInt(8);
    }

    public void setSessionID(int session_id) throws BufferOverflowException {
        this.setInt(8, session_id);
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        super.toString(out, args);
        args.add("SessionID:");
        args.add(this.getSessionID());
        out.printf("%-30s %-d\n", args);
    }
}

