/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.jms.protocol.BufferOverflowException;
import com.sap.jms.protocol.BufferUnderflowException;
import com.sap.jms.protocol.Packet;
import com.sap.jms.protocol.PacketFactory;
import com.sap.jms.protocol.PacketFactoryBaseImpl;
import com.sap.jms.protocol.PacketReader;
import com.sap.jms.protocol.PacketTypes;
import com.sap.jms.protocol.PacketTypesImpl;
import com.sap.jms.protocol.PacketWriter;
import com.sap.jms.util.PrintfWriter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.jms.JMSException;

public class PacketImpl
extends PacketTypesImpl
implements PacketReader,
PacketWriter,
Packet,
PacketTypes {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.protocol.PacketImpl");
    private static final Category logger = Category.getCategory((String)"/System/Server");
    protected static byte[] EMPTY_ARRAY = null;
    private final int chunkSize = 102400;
    protected static PacketFactory.MemoryAllocator MEMORY_ALLOCATOR = PacketFactoryBaseImpl.MEMORY_ALLOCATOR;
    protected static boolean POOL_USED = false;
    protected byte[] m_buffer;
    protected int m_start;
    protected int m_end;
    protected int m_payload_start;
    protected int m_position;
    static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String HEXSTRING = "0123456789ABCDEFabcdef";
    static /* synthetic */ Class class$com$sap$jms$protocol$PacketImpl;

    public PacketImpl() {
    }

    protected PacketImpl(byte packet_type) {
        try {
            this.allocate(packet_type, 0);
        }
        catch (JMSException ex) {
            logger.warningT(tracer, "constructor", "Could not construct PacketImpl due to " + ex.getMessage());
            LoggingHelper.traceThrowable(400, tracer, "constructor", ex);
        }
    }

    protected PacketImpl(byte packet_type, int packet_size) throws JMSException {
        this.allocate(packet_type, packet_size);
    }

    protected PacketImpl(byte[] buffer, int offset, int length) {
        this.setBuffer(buffer, offset, length);
    }

    public Object clone() {
        PacketImpl packet = null;
        try {
            int length = this.getLength();
            byte[] buffer = MEMORY_ALLOCATOR.malloc(length);
            System.arraycopy(this.m_buffer, this.m_start, buffer, 0, Math.min(this.m_end - this.m_start, length));
            Class<?> packet_class = this.getClass();
            packet = (PacketImpl)packet_class.newInstance();
            packet.setBuffer(buffer, 0, length);
        }
        catch (Exception ex) {
            packet = null;
        }
        return packet;
    }

    protected void allocate(byte packet_type, int packet_size) throws JMSException {
        int size = 14 + packet_size;
        byte[] buffer = MEMORY_ALLOCATOR.malloc(size);
        if (this.m_buffer != null) {
            System.arraycopy(this.m_buffer, this.m_start, buffer, 0, Math.min(this.m_end - this.m_start, size));
            MEMORY_ALLOCATOR.free(this.m_buffer);
        } else if (POOL_USED) {
            Class clazz = class$com$sap$jms$protocol$PacketImpl == null ? (class$com$sap$jms$protocol$PacketImpl = PacketImpl.class$("com.sap.jms.protocol.PacketImpl")) : class$com$sap$jms$protocol$PacketImpl;
            synchronized (clazz) {
                if (EMPTY_ARRAY == null) {
                    EMPTY_ARRAY = new byte[102400];
                }
            }
            int i = 0;
            while (i < size) {
                System.arraycopy(EMPTY_ARRAY, 0, buffer, i, Math.min(size - i, 102400));
                i += 102400;
            }
        }
        this.setBuffer(buffer, 0, size);
        this.setIntInternal(0, size);
        this.setByteInternal(4, packet_type);
    }

    public void setBuffer(byte[] buffer, int start, int capacity) {
        this.m_buffer = buffer;
        this.m_start = start;
        this.m_end = start + capacity;
        this.m_payload_start = this.m_start + 14;
        if (this.m_end > this.m_buffer.length) {
            this.m_end = this.m_buffer.length;
        }
        this.m_position = this.m_payload_start;
    }

    public void releaseBuffer() {
        if (this.m_buffer != null) {
            MEMORY_ALLOCATOR.free(this.m_buffer);
        }
        this.clearBuffer();
    }

    public void clearBuffer() {
        this.m_buffer = null;
        this.m_start = 0;
        this.m_end = 0;
        this.m_payload_start = 0;
        this.m_position = 0;
    }

    public final int getOffset() {
        return this.m_start;
    }

    public final int getLength() throws JMSException {
        this.flush();
        return this.m_end - this.m_start;
    }

    public final byte[] getBuffer() throws JMSException {
        this.flush();
        return this.m_buffer;
    }

    public final int getCapacity() throws JMSException {
        this.flush();
        return this.m_end - this.m_payload_start;
    }

    public final int getPosition() {
        return this.m_position - this.m_payload_start;
    }

    public void setPosition(int position) throws BufferUnderflowException, BufferOverflowException {
        if (this.m_payload_start + position > this.m_end) {
            throw new BufferOverflowException();
        }
        if (this.m_payload_start + position < this.m_payload_start) {
            throw new BufferUnderflowException();
        }
        this.m_position = this.m_payload_start + position;
    }

    public final boolean isNotification() throws JMSException {
        return !this.isMessage();
    }

    public final boolean isMessage() throws JMSException {
        return this.getByteInternal(this.m_start + 4) > 0;
    }

    public final int getPacketType() throws JMSException {
        return this.getByteInternal(this.m_start + 4);
    }

    protected final void setPacketType(byte packet_type) throws JMSException {
        this.setByteInternal(this.m_start + 4, packet_type);
    }

    public final String getPacketTypeAsString() throws JMSException {
        byte type = this.getByteInternal(this.m_start + 4);
        String s = (String)PacketTypesImpl.PACKET_NAMES.get(type);
        return s != null ? s : "Unknown";
    }

    public final long getRequestID() throws JMSException {
        return this.getLongInternal(this.m_start + 6);
    }

    public final void setRequestID(long request_id) throws JMSException {
        this.setLongInternal(this.m_start + 6, request_id);
    }

    private int checkOverflow(int position, int size) throws BufferOverflowException {
        if ((position += this.m_payload_start) < this.m_payload_start || position + size > this.m_end) {
            throw new BufferOverflowException();
        }
        return position;
    }

    private int checkUnderflow(int position, int size) throws BufferUnderflowException {
        if ((position += this.m_payload_start) < this.m_payload_start || position + size > this.m_end) {
            throw new BufferUnderflowException();
        }
        return position;
    }

    public final void reset() {
        this.m_position = this.m_payload_start;
    }

    protected final byte getByteInternal(int position) {
        return this.m_buffer[position];
    }

    public final byte getByte(int position) throws BufferUnderflowException {
        position = this.checkUnderflow(position, 1);
        return this.m_buffer[position];
    }

    public final byte readByte() throws BufferUnderflowException {
        byte value = this.getByte(this.m_position - this.m_payload_start);
        ++this.m_position;
        return value;
    }

    protected final PacketWriter setByteInternal(int position, byte value) throws BufferOverflowException {
        this.m_buffer[position] = value;
        return this;
    }

    public final PacketWriter setByte(int position, byte value) throws BufferOverflowException {
        position = this.checkOverflow(position, 1);
        this.m_buffer[position] = value;
        return this;
    }

    public final PacketWriter writeByte(byte value) throws BufferOverflowException {
        this.setByte(this.m_position - this.m_payload_start, value);
        ++this.m_position;
        return this;
    }

    public final byte[] getBytes(int position, int length) throws BufferUnderflowException {
        position = this.checkUnderflow(position, length);
        byte[] value = new byte[length];
        System.arraycopy(this.m_buffer, position, value, 0, length);
        return value;
    }

    public final PacketWriter setBytes(int position, byte[] value) throws BufferOverflowException {
        int length = value != null ? value.length : 0;
        return this.setBytes(position, value, 0, length);
    }

    public final PacketWriter setBytes(int position, byte[] value, int offset, int length) throws BufferOverflowException {
        this.m_position = this.encodeByteArray(position, value, offset, length, false);
        return this;
    }

    public final byte[] readByteArray() throws BufferUnderflowException {
        byte[] value = this.getByteArray(this.m_position - this.m_payload_start);
        this.m_position += value.length + 4;
        return value;
    }

    public final byte[] getByteArray(int position) throws BufferUnderflowException {
        int length = this.getInt(position);
        position = this.checkUnderflow(position + 4, length);
        byte[] value = new byte[length];
        System.arraycopy(this.m_buffer, position, value, 0, length);
        return value;
    }

    public final PacketWriter setByteArray(int position, byte[] value) throws BufferOverflowException {
        int length = value != null ? value.length : 0;
        return this.setByteArray(position, value, 0, length);
    }

    public final PacketWriter setByteArray(int position, byte[] value, int offset, int length) throws BufferOverflowException {
        this.m_position = this.encodeByteArray(position, value, offset, length, true);
        return this;
    }

    public final PacketWriter writeByteArray(byte[] value) throws BufferOverflowException {
        int length = value != null ? value.length : 0;
        return this.writeByteArray(value, 0, length);
    }

    public final PacketWriter writeByteArray(byte[] value, int offset, int length) throws BufferOverflowException {
        this.m_position = this.encodeByteArray(this.m_position - this.m_payload_start, value, offset, length, true);
        return this;
    }

    private final int encodeByteArray(int position, byte[] value, int offset, int length, boolean with_length) throws BufferOverflowException {
        length = value != null ? (value.length < length ? value.length : length) : 0;
        position = this.checkOverflow(position, length + (with_length ? 4 : 0));
        if (with_length) {
            this.setIntInternal(position, length);
            position += 4;
        }
        System.arraycopy(value, offset, this.m_buffer, position, length);
        return position + length;
    }

    public final char getChar(int position) throws BufferUnderflowException {
        position = this.checkUnderflow(position, 2);
        return (char)(this.m_buffer[position++] << 8 | this.m_buffer[position]);
    }

    public final char readChar() throws BufferUnderflowException {
        char value = this.getChar(this.m_position - this.m_payload_start);
        this.m_position += 2;
        return value;
    }

    public final PacketWriter setChar(int position, char value) throws BufferOverflowException {
        position = this.checkOverflow(position, 2);
        this.m_buffer[position++] = (byte)(value >>> 8 & 0xFF);
        this.m_buffer[position] = (byte)(value & 0xFF);
        return this;
    }

    public final PacketWriter writeChar(char value) throws BufferOverflowException {
        this.setChar(this.m_position - this.m_payload_start, value);
        this.m_position += 2;
        return this;
    }

    public final short getShort(int position) throws BufferUnderflowException {
        position = this.checkUnderflow(position, 2);
        return (short)((this.m_buffer[position++] & 0xFF) << 8 | this.m_buffer[position] & 0xFF);
    }

    public final short readShort() throws BufferUnderflowException {
        short value = this.getShort(this.m_position - this.m_payload_start);
        this.m_position += 2;
        return value;
    }

    public final PacketWriter setShort(int position, short value) throws BufferOverflowException {
        position = this.checkOverflow(position, 2);
        this.m_buffer[position++] = (byte)(value >>> 8 & 0xFF);
        this.m_buffer[position] = (byte)(value & 0xFF);
        return this;
    }

    public final PacketWriter writeShort(short value) throws BufferOverflowException {
        this.setShort(this.m_position - this.m_payload_start, value);
        this.m_position += 2;
        return this;
    }

    protected final int getIntInternal(int position) {
        return PacketImpl.getIntInternal(this.m_buffer, position);
    }

    protected static final int getIntInternal(byte[] buffer, int position) {
        return (buffer[position++] & 0xFF) << 24 | (buffer[position++] & 0xFF) << 16 | (buffer[position++] & 0xFF) << 8 | buffer[position] & 0xFF;
    }

    protected static final int setIntInternal(byte[] buffer, int position, int value) {
        buffer[position++] = (byte)(value >>> 24 & 0xFF);
        buffer[position++] = (byte)(value >>> 16 & 0xFF);
        buffer[position++] = (byte)(value >>> 8 & 0xFF);
        buffer[position++] = (byte)(value & 0xFF);
        return position;
    }

    public final int getInt(int position) throws BufferUnderflowException {
        position = this.checkUnderflow(position, 4);
        return this.getIntInternal(position);
    }

    public final int readInt() throws BufferUnderflowException {
        int value = this.getInt(this.m_position - this.m_payload_start);
        this.m_position += 4;
        return value;
    }

    protected final int setIntInternal(int position, int value) {
        this.m_buffer[position++] = (byte)(value >>> 24 & 0xFF);
        this.m_buffer[position++] = (byte)(value >>> 16 & 0xFF);
        this.m_buffer[position++] = (byte)(value >>> 8 & 0xFF);
        this.m_buffer[position++] = (byte)(value & 0xFF);
        return position;
    }

    public final PacketWriter setInt(int position, int value) throws BufferOverflowException {
        position = this.checkOverflow(position, 4);
        this.setIntInternal(position, value);
        return this;
    }

    public final PacketWriter writeInt(int value) throws BufferOverflowException {
        this.setInt(this.m_position - this.m_payload_start, value);
        this.m_position += 4;
        return this;
    }

    protected final long getLongInternal(int position) {
        return ((long)this.m_buffer[position++] & 0xFFL) << 56 | ((long)this.m_buffer[position++] & 0xFFL) << 48 | ((long)this.m_buffer[position++] & 0xFFL) << 40 | ((long)this.m_buffer[position++] & 0xFFL) << 32 | ((long)this.m_buffer[position++] & 0xFFL) << 24 | ((long)this.m_buffer[position++] & 0xFFL) << 16 | ((long)this.m_buffer[position++] & 0xFFL) << 8 | (long)this.m_buffer[position] & 0xFFL;
    }

    public final long getLong(int position) throws BufferUnderflowException {
        position = this.checkUnderflow(position, 8);
        return this.getLongInternal(position);
    }

    public final long readLong() throws BufferUnderflowException {
        long value = this.getLong(this.m_position - this.m_payload_start);
        this.m_position += 8;
        return value;
    }

    public final PacketWriter setLong(int position, long value) throws BufferOverflowException {
        position = this.checkOverflow(position, 8);
        return this.setLongInternal(position, value);
    }

    protected final PacketWriter setLongInternal(int position, long value) {
        this.m_buffer[position++] = (byte)(value >> 56 & 0xFFL);
        this.m_buffer[position++] = (byte)(value >> 48 & 0xFFL);
        this.m_buffer[position++] = (byte)(value >> 40 & 0xFFL);
        this.m_buffer[position++] = (byte)(value >> 32 & 0xFFL);
        this.m_buffer[position++] = (byte)(value >> 24 & 0xFFL);
        this.m_buffer[position++] = (byte)(value >> 16 & 0xFFL);
        this.m_buffer[position++] = (byte)(value >> 8 & 0xFFL);
        this.m_buffer[position] = (byte)(value & 0xFFL);
        return this;
    }

    public final PacketWriter writeLong(long value) throws BufferOverflowException {
        this.setLong(this.m_position - this.m_payload_start, value);
        this.m_position += 8;
        return this;
    }

    public final float getFloat(int position) throws BufferUnderflowException {
        return Float.intBitsToFloat(this.getInt(position));
    }

    public final float readFloat() throws BufferUnderflowException {
        float value = this.getFloat(this.m_position - this.m_payload_start);
        this.m_position += 4;
        return value;
    }

    public final PacketWriter setFloat(int position, float value) throws BufferOverflowException {
        return this.setInt(position, Float.floatToIntBits(value));
    }

    public final PacketWriter writeFloat(float value) throws BufferOverflowException {
        this.setFloat(this.m_position - this.m_payload_start, value);
        this.m_position += 4;
        return this;
    }

    public final double getDouble(int position) throws BufferUnderflowException {
        return Double.longBitsToDouble(this.getLong(position));
    }

    public final double readDouble() throws BufferUnderflowException {
        double value = this.getDouble(this.m_position - this.m_payload_start);
        this.m_position += 8;
        return value;
    }

    public final PacketWriter setDouble(int position, double value) throws BufferOverflowException {
        return this.setLong(position, Double.doubleToLongBits(value));
    }

    public final PacketWriter writeDouble(double value) throws BufferOverflowException {
        this.setDouble(this.m_position - this.m_payload_start, value);
        this.m_position += 8;
        return this;
    }

    public final String getString(int position) throws BufferUnderflowException {
        return this.getStringInternal(position, false);
    }

    public final String readString() throws BufferUnderflowException {
        return this.getStringInternal(this.m_position - this.m_payload_start, true);
    }

    protected final int strlen(int position) throws BufferUnderflowException {
        position = this.checkUnderflow(position, 5) + 1;
        return this.getIntInternal(position) + 1 + 4;
    }

    protected final String getStringInternal(int position, boolean advance) throws BufferUnderflowException {
        position = this.checkUnderflow(position, 5);
        byte encoding = this.m_buffer[position++];
        int length = this.getIntInternal(position);
        position += 4;
        if (length < 0) {
            length = 0;
        }
        char[] chars = new char[length];
        if (encoding == -10) {
            int i = 0;
            int end = position + length;
            while (position < end) {
                int char1 = this.m_buffer[position++] & 0xFF;
                switch (char1 >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        chars[i++] = (char)char1;
                        break;
                    }
                    case 12: 
                    case 13: {
                        byte char2 = this.m_buffer[position++];
                        if ((char2 & 0xC0) != 128) {
                            chars[i++] = 63;
                            break;
                        }
                        chars[i++] = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                        break;
                    }
                    case 14: {
                        byte char2 = this.m_buffer[position++];
                        byte char3 = this.m_buffer[position++];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            chars[i++] = 63;
                            break;
                        }
                        chars[i++] = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        break;
                    }
                    default: {
                        chars[i++] = 63;
                    }
                }
            }
            length = i;
        } else if (encoding == -9) {
            int i = 0;
            while (i < length) {
                chars[i] = (char)(this.m_buffer[position++] << 8 | this.m_buffer[position++]);
                ++i;
            }
        } else if (encoding == -11) {
            int i = 0;
            while (i < length) {
                chars[i] = (char)this.m_buffer[position++];
                ++i;
            }
        }
        if (advance) {
            this.m_position = position;
        }
        return new String(chars, 0, length);
    }

    public final PacketWriter setUTF8(int position, String value) throws BufferOverflowException {
        this.encodeUTF8(position, value);
        return this;
    }

    public final PacketWriter writeUTF8(String value) throws BufferOverflowException {
        this.m_position = this.encodeUTF8(this.m_position - this.m_payload_start, value);
        return this;
    }

    private final int encodeUTF8(int position, String value) throws BufferOverflowException {
        int length_utf8 = 0;
        int length = value != null ? value.length() : 0;
        length_utf8 = PacketImpl.strlenUTF8(value);
        position = this.checkOverflow(position, length_utf8);
        this.m_buffer[position++] = -10;
        this.setIntInternal(position, length_utf8 - 5);
        position += 4;
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.m_buffer[position++] = (byte)c;
            } else if (c > '\u07ff') {
                this.m_buffer[position++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.m_buffer[position++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.m_buffer[position++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                this.m_buffer[position++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.m_buffer[position++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        return position;
    }

    public final PacketWriter setUCS2(int position, String value) throws BufferOverflowException {
        this.encodeUCS2(position, value);
        return this;
    }

    public final PacketWriter writeUCS2(String value) throws BufferOverflowException {
        this.m_position = this.encodeUCS2(this.m_position - this.m_payload_start, value);
        return this;
    }

    private final int encodeUCS2(int position, String value) throws BufferOverflowException {
        int length = value.length();
        position = this.checkOverflow(position, length * 2 + 1 + 4);
        this.m_buffer[position++] = -9;
        this.setIntInternal(position, length);
        position += 4;
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            this.m_buffer[position++] = (byte)(c >>> 8 & 0xFF);
            this.m_buffer[position++] = (byte)(c & 0xFF);
            ++i;
        }
        return position;
    }

    public final PacketWriter setASCII(int position, String value) throws BufferOverflowException {
        this.encodeASCII(position, value);
        return this;
    }

    public final PacketWriter writeASCII(String value) throws BufferOverflowException {
        this.m_position = this.encodeASCII(this.m_position - this.m_payload_start, value);
        return this;
    }

    private final int encodeASCII(int position, String value) throws BufferOverflowException {
        int length = value.length();
        position = this.checkOverflow(position, length + 1 + 4);
        this.m_buffer[position++] = -11;
        this.setIntInternal(position, length);
        position += 4;
        int i = 0;
        while (i < length) {
            this.m_buffer[position++] = (byte)value.charAt(i);
            ++i;
        }
        return position;
    }

    public final String[] getStringArray(int position) throws BufferUnderflowException {
        return this.getStringArrayInternal(position, false);
    }

    public final String[] readStringArray() throws BufferUnderflowException {
        return this.getStringArrayInternal(this.m_position - this.m_payload_start, true);
    }

    protected final String[] getStringArrayInternal(int position, boolean advance) throws BufferUnderflowException {
        int position_save = this.m_position;
        String[] strings = null;
        try {
            try {
                position = this.checkUnderflow(position, 4);
                int length = this.getIntInternal(position);
                strings = new String[length];
                this.setPosition((position += 4) - this.m_payload_start);
                int i = 0;
                while (i < length) {
                    strings[i] = this.readString();
                    ++i;
                }
                String[] stringArray = strings;
                Object var9_9 = null;
                if (!advance) {
                    this.m_position = position_save;
                }
                return stringArray;
            }
            catch (BufferOverflowException ex) {
                logger.warningT(tracer, "getStringArrayInternal", "Could not get string array due to " + ((Throwable)((Object)ex)).getMessage());
                LoggingHelper.traceThrowable(400, tracer, "getStringArrayInternal", (Throwable)((Object)ex));
                Object var9_10 = null;
                if (!advance) {
                    this.m_position = position_save;
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!advance) {
                this.m_position = position_save;
            }
            throw throwable;
        }
        return strings;
    }

    public final PacketWriter setUTF8Array(int position, String[] value) throws BufferOverflowException {
        this.encodeUTF8Array(position, value, false);
        return this;
    }

    public final PacketWriter writeUTF8Array(String[] value) throws BufferOverflowException {
        this.encodeUTF8Array(this.m_position - this.m_payload_start, value, true);
        return this;
    }

    private final int encodeUTF8Array(int position, String[] value, boolean advance) throws BufferOverflowException {
        position = this.checkOverflow(position, 4);
        int position_save = this.m_position;
        int length = value == null ? 0 : value.length;
        try {
            try {
                this.setIntInternal(position, length);
                this.setPosition((position += 4) - this.m_payload_start);
                int i = 0;
                while (i < length) {
                    position = this.encodeUTF8(position - this.m_payload_start, value[i]);
                    ++i;
                }
            }
            catch (BufferUnderflowException ex) {
                logger.warningT(tracer, "encodeUTF8Array", "Could not encode UTF8 array due to " + ((Throwable)((Object)ex)).getMessage());
                LoggingHelper.traceThrowable(400, tracer, "encodeUTF8Array", (Throwable)((Object)ex));
                Object var8_9 = null;
                if (!advance) {
                    this.m_position = position_save;
                }
            }
            Object var8_8 = null;
            if (!advance) {
                this.m_position = position_save;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!advance) {
                this.m_position = position_save;
            }
            throw throwable;
        }
        return this.m_position - this.m_payload_start;
    }

    public static final int strlenASCII(String value) {
        return value == null ? 5 : value.length() + 5;
    }

    public static final int strlenUCS2(String value) {
        return value == null ? 5 : value.length() * 2 + 5;
    }

    public static final int strlenUTF8(String[] value) {
        int length_utf8 = 4;
        if (value == null) {
            return length_utf8;
        }
        int i = 0;
        while (i < value.length) {
            length_utf8 += PacketImpl.strlenUTF8(value[i]);
            ++i;
        }
        return length_utf8;
    }

    public static final int strlenUTF8(String value) {
        int length_utf8 = 5;
        if (value == null) {
            return length_utf8;
        }
        int length = value.length();
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            length_utf8 = c >= '\u0001' && c <= '\u007f' ? ++length_utf8 : (c > '\u07ff' ? (length_utf8 += 3) : (length_utf8 += 2));
            ++i;
        }
        return length_utf8;
    }

    protected static final String toHexString(byte[] value) {
        char[] s = new char[value.length * 2 + (value.length - 1) / 2];
        int i = 0;
        int k = 0;
        while (i < value.length) {
            s[k++] = HEXCHARS[value[i] >> 4 & 0xF];
            s[k++] = HEXCHARS[value[i] & 0xF];
            if (i % 2 == 0 && i > 0 && i < value.length - 1) {
                s[k++] = 45;
            }
            ++i;
        }
        return new String(s);
    }

    protected static final byte[] fromHexString(String value) {
        char[] s = value.toCharArray();
        int l = 0;
        int i = 0;
        while (i < s.length) {
            if (HEXSTRING.indexOf(s[i]) >= 0) {
                ++l;
            }
            ++i;
        }
        byte[] b = new byte[l];
        l = 0;
        int i2 = 0;
        while (i2 < s.length) {
            if (HEXSTRING.indexOf(s[i2]) > 0) {
                b[l++] = (byte)Character.digit(s[i2], 16);
            }
            ++i2;
        }
        return b;
    }

    public String toString() {
        PrintfWriter printf_writer = PrintfWriter.getInstance();
        try {
            PrintfWriter.Arg args = new PrintfWriter.Arg();
            printf_writer.println("============================== Start of Packet =================================");
            int pos = this.getPosition();
            this.toString(printf_writer, args);
            this.setPosition(pos);
            printf_writer.println("============================== End of Packet ===================================");
        }
        catch (Exception ex) {
            logger.warningT(tracer, "toString", "Caught exception: " + ex.getMessage());
            LoggingHelper.traceThrowable(400, tracer, "toString", ex);
            return ex.toString();
        }
        return printf_writer.toString();
    }

    protected void toString(PrintfWriter out, PrintfWriter.Arg args) throws Exception {
        this.flush();
        args.add("Type:");
        args.add(this.getPacketTypeAsString());
        args.add("Size:");
        args.add(this.getLength());
        args.add("Request-ID:");
        args.add(this.getRequestID());
        out.printf("%-30s %-30s\n%-30s %-d\n%-30s %x\n", args);
    }

    protected void flush() throws JMSException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

