/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.protocol;

import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.jms.protocol.MultiPacket;
import com.sap.jms.protocol.Packet;
import com.sap.jms.protocol.PacketFactory;
import com.sap.jms.protocol.PacketImpl;
import javax.jms.JMSException;

public class MultiPacketImpl
implements MultiPacket {
    private Packet m_packet = null;
    private Packet m_extra_packet = null;
    private ArrayObject m_packets = null;
    private boolean isProcessed = false;
    private static PacketFactory.MemoryAllocator m_memory_allocator;
    private static int MAX_PACKET_LENGTH;

    public static void setMemoryAllocator(PacketFactory.MemoryAllocator memory_allocator) {
        m_memory_allocator = memory_allocator;
    }

    public static void setMaxPacketLength(int length) {
        MAX_PACKET_LENGTH = length;
    }

    public MultiPacketImpl(byte[] buffer, int offset, int length) throws JMSException {
        this.m_packet = this.createNewPacket(buffer, offset, length, false);
    }

    public MultiPacketImpl(Packet packet) throws JMSException {
        this(packet.getBuffer(), packet.getOffset(), packet.getLength());
    }

    public synchronized void appendBufferToPacket(byte[] buffer, int offset, int length) throws JMSException {
        int p_length;
        int p_start;
        int p_end;
        this.isProcessed = false;
        byte[] p_buffer = this.m_packet.getBuffer();
        if (p_buffer.length >= length + (p_end = (p_start = this.m_packet.getOffset()) + (p_length = this.m_packet.getLength()))) {
            System.arraycopy(buffer, offset, p_buffer, p_end, length);
            this.m_packet.setBuffer(p_buffer, p_start, p_length += length);
        } else {
            int new_length = length + p_length;
            byte[] new_buffer = m_memory_allocator.malloc(new_length);
            System.arraycopy(p_buffer, p_start, new_buffer, 0, p_length);
            System.arraycopy(buffer, offset, new_buffer, p_length, length);
            this.m_packet.setBuffer(new_buffer, 0, new_length);
            m_memory_allocator.free(p_buffer);
        }
    }

    public Packet getNotCompletePacket() throws JMSException {
        if (!this.isProcessed) {
            this.createPackets();
        }
        return this.m_extra_packet;
    }

    public RootIterator getPacketsIterator() throws JMSException {
        if (!this.isProcessed) {
            this.createPackets();
        }
        return this.m_packets.elementsIterator();
    }

    public void clear() throws JMSException {
        if (this.m_packet != null) {
            m_memory_allocator.free(this.m_packet.getBuffer());
            this.m_packet = null;
            this.isProcessed = false;
        }
    }

    private synchronized void createPackets() throws JMSException {
        byte[] m_buffer = this.m_packet.getBuffer();
        int m_start = this.m_packet.getOffset();
        int m_length = this.m_packet.getLength();
        int m_end = m_start + m_length;
        int start = m_start;
        boolean hasExtra = true;
        this.m_extra_packet = null;
        this.m_packets = new ArrayObject();
        try {
            while (start + 0 + 4 <= m_end) {
                int p_length = PacketImpl.getIntInternal(m_buffer, start + 0);
                if (p_length <= 0) {
                    throw new JMSException("Packet with invalid length (" + p_length + ") received or wrong packet order!");
                }
                if (p_length > MAX_PACKET_LENGTH) {
                    throw new JMSException("Packet length (" + p_length + ") bigger than the max specified!");
                }
                if (start + p_length > m_end) break;
                if (start + p_length == m_end) {
                    hasExtra = false;
                }
                Packet packet = this.createNewPacket(m_buffer, start, p_length, hasExtra);
                this.m_packets.add(packet);
                start += p_length;
            }
            if (start == m_end) {
                Object var10_9 = null;
                if (!this.m_packets.isEmpty() && hasExtra) {
                    m_memory_allocator.free(this.m_packet.getBuffer());
                    this.m_packet = null;
                }
                this.isProcessed = true;
                return;
            }
            this.m_extra_packet = this.createNewPacket(m_buffer, start, m_end - start, true);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!this.m_packets.isEmpty() && hasExtra) {
                m_memory_allocator.free(this.m_packet.getBuffer());
                this.m_packet = null;
            }
            this.isProcessed = true;
            throw throwable;
        }
        Object var10_10 = null;
        if (!this.m_packets.isEmpty() && hasExtra) {
            m_memory_allocator.free(this.m_packet.getBuffer());
            this.m_packet = null;
        }
        this.isProcessed = true;
    }

    private Packet createNewPacket(byte[] buffer, int offset, int length, boolean shouldCopy) throws JMSException {
        try {
            PacketImpl packet = new PacketImpl();
            if (shouldCopy) {
                byte[] new_buffer = m_memory_allocator.malloc(length);
                System.arraycopy(buffer, offset, new_buffer, 0, length);
                packet.setBuffer(new_buffer, 0, length);
            } else {
                packet.setBuffer(buffer, offset, length);
            }
            return packet;
        }
        catch (Exception ex) {
            JMSException ex2 = new JMSException("Could not create packet");
            ex2.setLinkedException(ex);
            throw ex2;
        }
    }

    static {
        MAX_PACKET_LENGTH = 0xA00000;
    }
}

