/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.session;

import com.sap.engine.lib.util.base.NextItem;
import com.sap.jms.client.session.ThreadPool;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class WaiterThread
extends Thread
implements NextItem {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.session.WaiterThread");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    Runnable runnableObject = null;
    ThreadPool threadPool = null;
    private volatile boolean isRunning = false;
    NextItem nextItem = null;

    public WaiterThread(ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.setDaemon(true);
    }

    public synchronized void setRunnableObject(Runnable runnableObject) {
        this.runnableObject = runnableObject;
        this.notify();
    }

    public void run() {
        try {
            WaiterThread waiterThread = this;
            synchronized (waiterThread) {
                this.isRunning = true;
                this.notify();
                while (true) {
                    this.wait();
                    if (this.runnableObject == null) continue;
                    this.runnableObject.run();
                    this.runnableObject = null;
                    this.threadPool.releaseObject(this);
                }
            }
        }
        catch (InterruptedException e) {
            logger.warningT(tracer, "run", "InterruptedException caught. Process returns.");
            return;
        }
    }

    public void waitToStart() throws InterruptedException {
        WaiterThread waiterThread = this;
        synchronized (waiterThread) {
            if (!this.isRunning) {
                this.wait();
            }
        }
    }

    public NextItem getNext() {
        return this.nextItem;
    }

    public void setNext(NextItem nextItem) {
        this.nextItem = nextItem;
    }

    public void clearItem() {
        this.nextItem = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exc) {
            logger.warningT(tracer, "clone", "CloneNotSupportedException caught. Method returns null.");
            return null;
        }
    }
}

