/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jms.client.session;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.lib.util.NextItemPointer;
import com.sap.engine.lib.util.Queue;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class WaitBlockableQueue
extends Queue {
    private static final Location tracer = Location.getLocation((String)"com.sap.jms.client.session.WaitBlockableQueue");
    private static final Category logger = Category.getCategory((String)"/Applications/JMS");
    private transient int waitingToEnqueue = 0;
    private transient int waitingToDequeue = 0;
    private boolean isDequeueBlocked = false;
    private boolean destroyed = false;
    private Object enqueueMonitor = new Object();

    public WaitBlockableQueue() {
        this(0);
    }

    public WaitBlockableQueue(int limit) {
        super(limit);
    }

    public synchronized Object head() {
        Object result;
        while ((result = this.getFirst()) == null) {
            Object var4_2;
            ++this.waitingToDequeue;
            try {
                try {
                    this.wait();
                    if (this.destroyed) {
                        Object var2_3 = null;
                        var4_2 = null;
                        --this.waitingToDequeue;
                        return var2_3;
                    }
                    var4_2 = null;
                    --this.waitingToDequeue;
                }
                catch (Exception _) {
                    var4_2 = null;
                    --this.waitingToDequeue;
                    break;
                }
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this.waitingToDequeue;
                throw throwable;
            }
        }
        return result;
    }

    public synchronized Object head(long timeout) throws InterruptedException {
        Object result = this.getFirst();
        if (result == null) {
            ++this.waitingToDequeue;
            try {
                this.wait(timeout);
                if (this.destroyed) {
                    Object var4_3 = null;
                    Object var6_4 = null;
                    --this.waitingToDequeue;
                    return var4_3;
                }
                Object var6_5 = null;
                --this.waitingToDequeue;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                --this.waitingToDequeue;
                throw throwable;
            }
            return this.getFirst();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object dequeue() {
        Object result = null;
        WaitBlockableQueue waitBlockableQueue = this;
        synchronized (waitBlockableQueue) {
            while (true) {
                Object var5_6;
                if (!this.isDequeueBlocked && result != null) {
                    // MONITOREXIT @DISABLED, blocks:[4, 8, 11] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                    Object object = this.enqueueMonitor;
                    synchronized (object) {
                        if (result == null) return result;
                        if (this.waitingToEnqueue <= 0) return result;
                        this.enqueueMonitor.notifyAll();
                        return result;
                    }
                }
                ++this.waitingToDequeue;
                try {
                    try {
                        if (!this.isDequeueBlocked) {
                            result = this.removeFirst();
                        }
                        if (result == null) {
                            this.wait();
                        }
                        if (this.destroyed) {
                            Object var3_4 = null;
                            var5_6 = null;
                            --this.waitingToDequeue;
                            return var3_4;
                        }
                    }
                    catch (Exception e) {
                        logger.warningT(tracer, "dequeue", "Exception caught in dequeue : " + e.getMessage());
                        LoggingHelper.traceThrowable(400, tracer, "dequeue", e);
                        var5_6 = null;
                        --this.waitingToDequeue;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    --this.waitingToDequeue;
                    throw throwable;
                }
                var5_6 = null;
                --this.waitingToDequeue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object dequeue(long timeout) throws InterruptedException {
        Object result;
        block13: {
            if (timeout == 0L) {
                return this.dequeue();
            }
            result = null;
            WaitBlockableQueue waitBlockableQueue = this;
            synchronized (waitBlockableQueue) {
                if (this.isDequeueBlocked || (result = this.removeFirst()) == null) {
                    ++this.waitingToDequeue;
                    try {
                        try {
                            this.wait(timeout);
                            if (this.destroyed) {
                                Object var5_4 = null;
                                Object var7_7 = null;
                                --this.waitingToDequeue;
                                return var5_4;
                            }
                            if (!this.isDequeueBlocked) {
                                result = this.removeFirst();
                            }
                        }
                        catch (Exception e) {
                            logger.warningT(tracer, "dequeue", "Exception caught in dequeue(timeout) : " + e.getMessage());
                            LoggingHelper.traceThrowable(400, tracer, "dequeue(timeout)", e);
                            Object var7_9 = null;
                            --this.waitingToDequeue;
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        --this.waitingToDequeue;
                        throw throwable;
                    }
                    Object var7_8 = null;
                    --this.waitingToDequeue;
                }
            }
        }
        Object object = this.enqueueMonitor;
        synchronized (object) {
            if (result == null) return result;
            if (this.waitingToEnqueue <= 0) return result;
            this.enqueueMonitor.notifyAll();
            return result;
        }
    }

    public Object dequeueNoWait() {
        Object result = null;
        WaitBlockableQueue waitBlockableQueue = this;
        synchronized (waitBlockableQueue) {
            if (!this.isDequeueBlocked) {
                result = this.removeFirst();
            }
        }
        Object object = this.enqueueMonitor;
        synchronized (object) {
            if (result != null && this.waitingToEnqueue > 0) {
                this.enqueueMonitor.notifyAll();
            }
        }
        return result;
    }

    public boolean enqueue(Object item) {
        boolean result;
        Object object = this.enqueueMonitor;
        synchronized (object) {
            while (!(result = this.addLast(item) != null)) {
                Object var6_4;
                ++this.waitingToEnqueue;
                try {
                    try {
                        this.enqueueMonitor.wait();
                    }
                    catch (Exception _) {
                        var6_4 = null;
                        --this.waitingToEnqueue;
                        break;
                    }
                    var6_4 = null;
                    --this.waitingToEnqueue;
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    --this.waitingToEnqueue;
                    throw throwable;
                }
            }
        }
        if (result) {
            this.notifyDequeueThread();
        }
        return result;
    }

    public boolean enqueue(Object item, long timeout) throws InterruptedException {
        boolean result;
        if (timeout == 0L) {
            return this.enqueue(item);
        }
        Object object = this.enqueueMonitor;
        synchronized (object) {
            result = this.addLast(item) != null;
            if (!result) {
                ++this.waitingToEnqueue;
                try {
                    this.enqueueMonitor.wait(timeout);
                    Object var7_5 = null;
                    --this.waitingToEnqueue;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    --this.waitingToEnqueue;
                    throw throwable;
                }
                result = this.addLast(item) != null;
            }
        }
        if (result) {
            this.notifyDequeueThread();
        }
        return result;
    }

    public synchronized NextItemPointer addLast(Object value) {
        return super.addLast(value);
    }

    private synchronized void notifyDequeueThread() {
        if (this.waitingToDequeue > 0 && !this.isDequeueBlocked && this.size() > 0) {
            this.notify();
        }
    }

    public synchronized boolean isDequeueBlocked() {
        return this.isDequeueBlocked;
    }

    public synchronized void setDequeueBlocked(boolean dequeueBlocked) {
        this.isDequeueBlocked = dequeueBlocked;
        if (!this.isDequeueBlocked && this.waitingToDequeue > 0 && this.size() > 0) {
            this.notify();
        }
    }

    public synchronized void stopWaitingToDequeue() {
        if (this.waitingToDequeue > 0) {
            this.notify();
        }
    }

    public synchronized void destroyQueue() {
        this.destroyed = true;
        this.clear();
        this.notify();
    }
}

